/*
 * Decompiled with CFR 0.152.
 */
package tangram.qrcode;

import com.bysquare.document.invoice.Contact;
import com.bysquare.document.invoice.CustomerParty;
import com.bysquare.document.invoice.Invoice;
import com.bysquare.document.invoice.MonetarySummary;
import com.bysquare.document.invoice.Party;
import com.bysquare.document.invoice.PaymentMean;
import com.bysquare.document.invoice.PostalAddress;
import com.bysquare.document.invoice.SingleInvoiceLine;
import com.bysquare.document.invoice.SupplierParty;
import com.bysquare.document.invoice.TaxCategorySummaries;
import com.bysquare.document.invoice.TaxCategorySummary;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import tangram.qrcode.TngBysquareUtils;

public class TngInvoiceBysquareFactory {
    public static Invoice createInvoice(String invoiceId, Date issueDate, Date taxPointDate, String orderId, String deliveryNoteId, String localCurrencyCode, String foreignCurrencyCode, BigDecimal currRate, BigDecimal referenceCurrRate, SupplierParty supplierParty, CustomerParty customerParty, Integer numberOfInvoiceLines, String invoiceDescription, SingleInvoiceLine singleInvoiceLine, TaxCategorySummaries taxCategorySummaries, MonetarySummary monetarySummary, List<PaymentMean> paymentMeans) {
        Invoice invoice = new Invoice();
        invoice.setInvoiceID(invoiceId);
        invoice.setIssueDate(issueDate);
        invoice.setTaxPointDate(taxPointDate);
        invoice.setOrderID(orderId);
        invoice.setDeliveryNoteID(deliveryNoteId);
        invoice.setLocalCurrencyCode(localCurrencyCode);
        invoice.setForeignCurrencyCode(foreignCurrencyCode);
        invoice.setCurrRate(TngBysquareUtils.decimalToDouble(currRate));
        invoice.setReferenceCurrRate(TngBysquareUtils.decimalToDouble(referenceCurrRate));
        invoice.setSupplierParty(supplierParty);
        invoice.setCustomerParty(customerParty);
        invoice.setNumberOfInvoiceLines(numberOfInvoiceLines);
        invoice.setInvoiceDescription(invoiceDescription);
        invoice.setSingleInvoiceLine(singleInvoiceLine);
        invoice.setTaxCategorySummaries(taxCategorySummaries);
        invoice.setMonetarySummary(monetarySummary);
        invoice.setPaymentMeans(paymentMeans);
        return invoice;
    }

    public static Party createParty(String partyName, String companyTaxID, String companyVATID, String companyRegisterID) {
        Party party = new Party();
        party.setPartyName(partyName);
        party.setCompanyTaxID(companyTaxID);
        party.setCompanyVATID(companyVATID);
        party.setCompanyRegisterID(companyRegisterID);
        return party;
    }

    public static SupplierParty createSupplierParty(Party party, PostalAddress postalAddress, Contact contact) {
        SupplierParty supplierParty = new SupplierParty();
        if (party != null) {
            supplierParty.setPartyName(party.getPartyName());
            supplierParty.setCompanyTaxID(party.getCompanyTaxID());
            supplierParty.setCompanyVATID(party.getCompanyVATID());
            supplierParty.setCompanyRegisterID(party.getCompanyRegisterID());
        }
        supplierParty.setPostalAddress(postalAddress);
        supplierParty.setContact(contact);
        return supplierParty;
    }

    public static CustomerParty createCustomerParty(Party party, String partyIdentification) {
        CustomerParty customerParty = new CustomerParty();
        if (party != null) {
            customerParty.setPartyName(party.getPartyName());
            customerParty.setCompanyTaxID(party.getCompanyTaxID());
            customerParty.setCompanyVATID(party.getCompanyVATID());
            customerParty.setCompanyRegisterID(party.getCompanyRegisterID());
        }
        customerParty.setPartyIdentification(partyIdentification);
        return customerParty;
    }

    public static PostalAddress createPostalAddress(String streetName, String buildingNumber, String cityName, String postalZone, String state, String country) {
        PostalAddress postalAddress = new PostalAddress();
        postalAddress.setStreetName(streetName);
        postalAddress.setBuildingNumber(buildingNumber);
        postalAddress.setCityName(cityName);
        postalAddress.setPostalZone(postalZone);
        postalAddress.setState(state);
        postalAddress.setCountry(country);
        return postalAddress;
    }

    public static Contact createContact(String name, String telephone, String email) {
        Contact contact = new Contact();
        contact.setName(name);
        contact.setTelephone(telephone);
        contact.setEMail(email);
        return contact;
    }

    public static SingleInvoiceLine createSingleInvoiceLine(String orderLineID, String deliveryNoteLineID, String itemName, String itemEANCode, Date periodFromDate, Date periodToDate, BigDecimal invoicedQuantity) {
        SingleInvoiceLine singleInvoiceLine = new SingleInvoiceLine();
        singleInvoiceLine.setOrderLineID(orderLineID);
        singleInvoiceLine.setDeliveryNoteLineID(deliveryNoteLineID);
        singleInvoiceLine.setItemName(itemName);
        singleInvoiceLine.setItemEANCode(itemEANCode);
        singleInvoiceLine.setPeriodFromDate(periodFromDate);
        singleInvoiceLine.setPeriodToDate(periodToDate);
        singleInvoiceLine.setInvoicedQuantity(TngBysquareUtils.decimalToDouble(invoicedQuantity));
        return singleInvoiceLine;
    }

    public static TaxCategorySummary createTaxCategorySummary(BigDecimal classifiedTaxCategory, BigDecimal taxExclusiveAmount, BigDecimal taxAmount, BigDecimal alreadyClaimedTaxExclusiveAmount, BigDecimal alreadyClaimedTaxAmount) {
        TaxCategorySummary taxCategorySummary = new TaxCategorySummary();
        taxCategorySummary.setClassifiedTaxCategory(TngBysquareUtils.decimalToDouble(classifiedTaxCategory));
        taxCategorySummary.setTaxExclusiveAmount(TngBysquareUtils.decimalToDouble(taxExclusiveAmount));
        taxCategorySummary.setTaxAmount(TngBysquareUtils.decimalToDouble(taxAmount));
        taxCategorySummary.setAlreadyClaimedTaxExclusiveAmount(TngBysquareUtils.decimalToDouble(alreadyClaimedTaxExclusiveAmount));
        taxCategorySummary.setAlreadyClaimedTaxAmount(TngBysquareUtils.decimalToDouble(alreadyClaimedTaxAmount));
        return taxCategorySummary;
    }

    public static MonetarySummary createMonetarySummary(BigDecimal payableRoundingAmount, BigDecimal paidDepositsAmount) {
        MonetarySummary monetarySummary = new MonetarySummary();
        monetarySummary.setPayableRoundingAmount(TngBysquareUtils.decimalToDouble(payableRoundingAmount));
        monetarySummary.setPaidDepositsAmount(TngBysquareUtils.decimalToDouble(paidDepositsAmount));
        return monetarySummary;
    }
}

