/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PrinterResolution;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;
import tangram.report.TngReportBind;
import tangram.report.TngReportBindReader;
import tangram.report.TngReportBindWriter;
import tangram.report.TngReportExportXls;
import tangram.report.TngReportFormat;
import tangram.report.TngReportPrinter;
import tangram.report.TngReportSelectReader;
import tangram.report.alternative.TngReportAlternative;
import tangram.report.alternative.TngReportAlternativeExecutor;
import tangram.swing.panel.TngProgressableWorker;

public class TngReport {
    private JasperReport jasperReport;
    private JasperPrint jasperPrint;
    private JRSwapFileVirtualizer virtualizer;
    private TngProgressableWorker worker;
    private File fileData;
    private File fileDataExternal;
    private String lastSelect;

    public void close() {
        this.jasperReport = null;
        this.jasperPrint = null;
        if (this.virtualizer != null) {
            this.virtualizer.cleanup();
        }
        this.virtualizer = null;
        this.lastSelect = null;
        if (this.fileData != null && this.fileData.isFile() && !this.fileData.equals(this.fileDataExternal)) {
            this.fileData.delete();
        }
        this.fileData = null;
        this.fileDataExternal = null;
    }

    public JasperReport getJasperReport() {
        return this.jasperReport;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public void setWorker(TngProgressableWorker worker) {
        this.worker = worker;
    }

    public int getPages() {
        if (this.jasperPrint == null) {
            return 0;
        }
        return this.jasperPrint.getPages().size();
    }

    public List<String> getParams() {
        ArrayList<String> p2 = new ArrayList<String>();
        if (this.jasperReport == null) {
            return p2;
        }
        JRParameter[] params = this.jasperReport.getParameters();
        if (params == null) {
            return p2;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            JRParameter param = params[i2];
            if (param.isSystemDefined()) continue;
            p2.add(param.getName());
            String v = this.expresionToSingleString(param.getDefaultValueExpression());
            p2.add(v);
        }
        return p2;
    }

    public List<String> getFields() {
        ArrayList<String> f2 = new ArrayList<String>();
        if (this.jasperReport == null) {
            return f2;
        }
        JRField[] fields = this.jasperReport.getFields();
        if (fields == null) {
            return f2;
        }
        for (int i2 = 0; i2 < fields.length; ++i2) {
            f2.add(fields[i2].getName());
        }
        return f2;
    }

    private void checkPages(int fromPage, int toPage) throws Exception {
        int pages = this.getPages();
        if (fromPage < 1 || fromPage > this.getPages()) {
            throw new Exception("Strana " + fromPage + " je mimo rozsah 1.." + pages);
        }
        if (toPage < 1 || toPage > this.getPages()) {
            throw new Exception("Strana " + toPage + " je mimo rozsah 1.." + pages);
        }
    }

    public void getPage(int page, float zoom, String format, String filePng) throws Exception {
        this.checkPages(page, page);
        int imageType = 1;
        if ("GIF".equalsIgnoreCase(format)) {
            imageType = 13;
        }
        BufferedImage pageImage = new BufferedImage((int)(zoom * (float)this.jasperPrint.getPageWidth()), (int)(zoom * (float)this.jasperPrint.getPageHeight()), imageType);
        JRGraphics2DExporter exporter = new JRGraphics2DExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
        exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(page - 1));
        exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, pageImage.createGraphics());
        exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(zoom));
        HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
        attrs.add(new PrinterResolution((int)(zoom * (float)this.jasperPrint.getPageWidth()), (int)(zoom * (float)this.jasperPrint.getPageHeight()), 100));
        exporter.setParameter(JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, attrs);
        exporter.exportReport();
        ImageIO.write((RenderedImage)pageImage, format, new File(filePng));
    }

    public void print(String printer, int pageStart, int pageEnd, int copies, boolean displayDialog) throws Exception {
        TngReportPrinter reportPrinter = new TngReportPrinter(this.jasperPrint);
        reportPrinter.setData(printer, pageStart, pageEnd, copies, displayDialog);
        reportPrinter.setWorker(this.worker);
        reportPrinter.printPages();
    }

    public void exportToPdf(String pdfFile, int pageStart, int pageEnd) throws Exception {
        if (this.getPages() == 0) {
            throw new Exception(Nat.x("Tla\u010dov\u00e1 zostava je pr\u00e1zdna"));
        }
        JRProperties.setProperty("net.sf.jasperreports.default.pdf.encoding", "Cp1250");
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, "Cp1250");
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
        if (pageStart > 0) {
            exporter.setParameter(JRExporterParameter.START_PAGE_INDEX, new Integer(pageStart - 1));
        }
        if (pageEnd > 0) {
            exporter.setParameter(JRExporterParameter.END_PAGE_INDEX, new Integer(pageEnd - 1));
        }
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, pdfFile);
        if (this.worker != null) {
            int pageFrom = pageStart <= 0 ? 0 : pageStart - 1;
            int pageTo = pageEnd <= 0 ? this.getPages() : pageEnd - 1;
            this.worker.setProgressMax(pageTo - pageFrom);
            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, new JRExportProgressMonitor(){

                @Override
                public void afterPageExport() {
                    TngReport.this.worker.addProgressValue(1);
                }
            });
        }
        exporter.exportReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToXls(String xlsFile) throws Exception {
        if (this.getPages() == 0) {
            throw new Exception(Nat.x("Tla\u010dov\u00e1 zostava je pr\u00e1zdna"));
        }
        if (this.fileData == null) {
            throw new Exception(Nat.x("Neexistuje d\u00e1tov\u00fd s\u00fabor"));
        }
        TngReportBindReader dataReader = new TngReportBindReader();
        try {
            dataReader.open(this.fileData, this.loadFields(), this.worker);
            TngReportExportXls xls = new TngReportExportXls();
            List<String> fields = this.getFields();
            xls.setData(new File(xlsFile), fields.toArray(new String[fields.size()]));
            xls.setDataReader(dataReader);
            xls.export();
        }
        finally {
            dataReader.close();
        }
    }

    public void load(String fileTrap) throws Exception {
        int p2;
        String fileJrxml = fileTrap = fileTrap.replace('/', '\\');
        TngReportAlternative alter = null;
        int a2 = fileTrap.indexOf(42);
        if (a2 > 0) {
            fileJrxml = fileTrap.substring(0, a2);
            String fileAlter = fileTrap.substring(a2 + 1);
            alter = TngReportAlternative.load(fileAlter);
        }
        if ((p2 = fileJrxml.indexOf(".zip\\")) > 0) {
            String zip = fileJrxml.substring(0, p2 += 4);
            String file = fileJrxml.substring(p2 + 1);
            this.loadFromZip(zip, file, alter);
        } else {
            this.loadFromDirectory(fileJrxml, alter);
        }
    }

    public void loadFromDirectory(String fileJrxml, TngReportAlternative alter) throws Exception {
        this.close();
        if (fileJrxml == null || fileJrxml.length() == 0) {
            throw new Exception(Nat.x("Nezadan\u00fd n\u00e1zov JASPER s\u00faboru"));
        }
        File file = new File(fileJrxml);
        if (!file.isFile()) {
            throw new Exception(Nat.x("JASPER s\u00fabor %1 neexistuje", file.getAbsolutePath()));
        }
        JasperDesign jasperDesign = JRXmlLoader.load(file);
        this.prepareAndComile(jasperDesign, alter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromZip(String zip, String fileJrxml, TngReportAlternative alter) throws Exception {
        this.close();
        if (fileJrxml == null || fileJrxml.length() == 0) {
            throw new Exception(Nat.x("Nezadan\u00fd n\u00e1zov JASPER s\u00faboru"));
        }
        if (zip == null || zip.length() == 0) {
            throw new Exception(Nat.x("Nezadan\u00fd ZIP s\u00fabor"));
        }
        File fileZip = new File(zip);
        if (!fileZip.isFile()) {
            throw new Exception(Nat.x("ZIP s\u00fabor %1 neexistuje", fileZip.getAbsolutePath()));
        }
        InputStream stream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileZip);
            ZipEntry zipEntry = zipFile.getEntry(fileJrxml);
            if (zipEntry == null) {
                throw new Exception(Nat.x("JASPER s\u00fabor %1 neexistuje v ZIP s\u00fabore %2", fileJrxml, fileZip.getAbsolutePath()));
            }
            stream = zipFile.getInputStream(zipEntry);
            JasperDesign jasperDesign = JRXmlLoader.load(stream);
            this.prepareAndComile(jasperDesign, alter);
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(stream);
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(stream);
        TngUtilities.closeSafe(zipFile);
    }

    private void prepareAndComile(JasperDesign jasperDesign, TngReportAlternative alter) throws Exception {
        if (alter != null) {
            TngReportAlternativeExecutor.modifyReport(jasperDesign, alter);
        }
        this.resolveStyles(jasperDesign);
        this.resolveFormats(jasperDesign);
        this.jasperReport = JasperCompileManager.compileReport(jasperDesign);
    }

    private void resolveStyles(JasperDesign jasperDesign) throws Exception {
        List<JRReportTemplate> templates = jasperDesign.getTemplatesList();
        for (int i2 = 0; i2 < templates.size(); ++i2) {
            JRDesignReportTemplate template = (JRDesignReportTemplate)templates.get(i2);
            JRDesignExpression exp = (JRDesignExpression)template.getSourceExpression();
            String file = this.resolveStyleFile(this.expresionToSingleString(exp));
            if (file == null) continue;
            file = file.replace('\\', '/');
            file = "new URL(\"" + file + "\")";
            exp.setText(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveStyleFile(String fileWithPath) throws Exception {
        if (fileWithPath.length() == 0) {
            return null;
        }
        String name = new File(fileWithPath).getName();
        File fileStyle = new File("custom", name);
        if (fileStyle.exists()) {
            return "file:" + fileStyle.getAbsolutePath();
        }
        fileStyle = new File("reports.zip");
        if (fileStyle.exists()) {
            ZipFile zipFile;
            block5: {
                String string;
                zipFile = null;
                try {
                    zipFile = new ZipFile(fileStyle);
                    if (zipFile.getEntry(name) == null) break block5;
                    string = "jar:file:" + fileStyle.getAbsolutePath() + "!\\" + name;
                }
                catch (Throwable throwable) {
                    TngUtilities.closeSafe(zipFile);
                    throw throwable;
                }
                TngUtilities.closeSafe(zipFile);
                return string;
            }
            TngUtilities.closeSafe(zipFile);
        }
        throw new Exception(Nat.x("JRTX s\u00fabor %1 neexistuje ani v adres\u00e1ri CUSTOM ani v ZIP s\u00fabore %2", name, fileStyle.getAbsolutePath()));
    }

    private void resolveFormats(JasperDesign jasperDesign) throws Exception {
        JRBand[] bands = jasperDesign.getAllBands();
        if (bands == null) {
            return;
        }
        for (int i2 = 0; i2 < bands.length; ++i2) {
            this.resolveFormats(bands[i2].getElements());
        }
    }

    private void resolveFormats(JRElement[] elements) throws Exception {
        if (elements == null) {
            return;
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            JRDesignTextField field;
            String pattern;
            if (elements[i2] instanceof JRElementGroup) {
                JRElementGroup group = (JRElementGroup)((Object)elements[i2]);
                this.resolveFormats(group.getElements());
                continue;
            }
            if (!(elements[i2] instanceof JRDesignTextField) || (pattern = (field = (JRDesignTextField)elements[i2]).getPattern()) == null || pattern.length() <= 0 || !"styled".equals(field.getMarkup())) continue;
            pattern = "'ALIGN_TO_DEC'" + pattern;
            field.setPattern(pattern);
        }
    }

    private String expresionToSingleString(JRExpression expression) {
        if (expression == null) {
            return "";
        }
        String v = expression.getText();
        if (v == null) {
            return "";
        }
        if (v.length() > 1 && v.charAt(0) == '\"' && v.charAt(v.length() - 1) == '\"') {
            v = v.substring(1, v.length() - 1);
        }
        return v;
    }

    public void fill(String paramsData, TngConnection connection, String select, boolean forced) throws Exception {
        HashMap<String, Object> params = this.paramsFromString(paramsData);
        if (forced || !select.equals(this.lastSelect) || this.fileData == null) {
            this.fill(params, connection, select);
        } else {
            this.fill(params, this.fileData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(HashMap<String, Object> params, TngConnection connection, String select) throws Exception {
        this.jasperPrint = null;
        if (this.jasperReport == null) {
            throw new Exception(Nat.x("Tla\u010dov\u00e1 zostava nebola nahran\u00e1"));
        }
        this.lastSelect = select;
        TngReportSelectReader selectReader = new TngReportSelectReader();
        TngReportBindWriter dataWriter = new TngReportBindWriter();
        try {
            dataWriter.setFile(this.fileData);
            dataWriter.begin();
            this.fileData = dataWriter.getFile();
            selectReader.open(connection, select, dataWriter, this.worker, this.loadFields());
            JRBaseFiller filler = JRFiller.createFiller(DefaultJasperReportsContext.getInstance(), this.jasperReport);
            filler.addFillListener(new FillListener(){

                @Override
                public void pageGenerated(JasperPrint jasperPrint, int pageIndex) {
                    TngReport.this.worker.setProgressStatus(Nat.x("Vytv\u00e1ranie tla\u010dovej zostavy, po\u010det str\u00e1n: %1", pageIndex));
                }

                @Override
                public void pageUpdated(JasperPrint jasperPrint, int pageIndex) {
                }
            });
            HashMap<String, Object> paramsExtend = this.extendParams(params);
            this.jasperPrint = filler.fill(paramsExtend, selectReader);
            if (selectReader.getNextException() != null) {
                throw selectReader.getNextException();
            }
            dataWriter.end();
        }
        finally {
            selectReader.close();
            dataWriter.close();
        }
    }

    public void fill(String paramsFile, String dataFileExternal) throws Exception {
        HashMap<String, Object> params = this.paramsFromFile(paramsFile);
        this.fill(params, new File(dataFileExternal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(HashMap<String, Object> params, File fileDataExternal) throws Exception {
        this.jasperPrint = null;
        if (this.jasperReport == null) {
            throw new Exception(Nat.x("Tla\u010dov\u00e1 zostava nebola nahran\u00e1"));
        }
        this.fileDataExternal = fileDataExternal;
        this.fileData = fileDataExternal;
        TngReportBindReader dataReader = new TngReportBindReader();
        try {
            dataReader.open(this.fileData, this.loadFields(), this.worker);
            JRBaseFiller filler = JRFiller.createFiller(DefaultJasperReportsContext.getInstance(), this.jasperReport);
            filler.addFillListener(new FillListener(){

                @Override
                public void pageGenerated(JasperPrint jasperPrint, int pageIndex) {
                    TngReport.this.worker.setProgressStatus(Nat.x("Vytv\u00e1ranie tla\u010dovej zostavy, po\u010det str\u00e1n: %1", pageIndex));
                }

                @Override
                public void pageUpdated(JasperPrint jasperPrint, int pageIndex) {
                }
            });
            HashMap<String, Object> paramsExtend = this.extendParams(params);
            this.jasperPrint = filler.fill(paramsExtend, dataReader);
            if (dataReader.getNextException() != null) {
                throw dataReader.getNextException();
            }
        }
        finally {
            dataReader.close();
        }
    }

    private HashMap<String, Object> paramsFromString(String paramsData) throws Exception {
        String[] data = TngUtilities.strTokenizeNotNull(paramsData, '\u0001');
        HashMap<String, TngReportBind> binds = this.loadParams();
        for (int i2 = 0; i2 < data.length; ++i2) {
            String h2 = data[i2];
            int p2 = h2.indexOf(61);
            if (p2 <= 0) {
                throw new Exception(Nat.x("Chyba v %1. prametri", i2 + 1));
            }
            String name = h2.substring(0, p2);
            TngReportBind bind = binds.get(name);
            if (bind == null) continue;
            String value = h2.substring(p2 + 1);
            bind.setValue(value);
        }
        return this.getUsedParams(binds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Object> paramsFromFile(String paramsFile) throws Exception {
        TngReportBindReader dataParams = new TngReportBindReader();
        try {
            dataParams.open(new File(paramsFile), this.loadParams(), null);
            dataParams.nextWithExceptionAndProgress();
            HashMap<String, Object> hashMap = this.getUsedParams(dataParams.getBinds());
            return hashMap;
        }
        finally {
            dataParams.close();
        }
    }

    private HashMap<String, Object> extendParams(HashMap<String, Object> paramsInput) {
        HashMap<String, Object> params = new HashMap<String, Object>(paramsInput);
        params.put("REPORT_FORMAT_FACTORY", new TngReportFormat());
        if (this.virtualizer != null) {
            this.virtualizer.cleanup();
        }
        this.virtualizer = null;
        String tmpDir = System.getProperty("java.io.tmpdir");
        JRSwapFile swapFile = new JRSwapFile(tmpDir, 1024, 16);
        this.virtualizer = new JRSwapFileVirtualizer(8, swapFile);
        params.put("REPORT_VIRTUALIZER", this.virtualizer);
        return params;
    }

    private HashMap<String, Object> getUsedParams(HashMap<String, TngReportBind> binds) {
        HashMap<String, Object> used = new HashMap<String, Object>();
        JRParameter[] params = this.jasperReport.getParameters();
        if (params == null) {
            return used;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            TngReportBind bind;
            JRParameter param = params[i2];
            if (param.isSystemDefined() || (bind = binds.get(param.getName())) == null || !bind.changed) continue;
            used.put(bind.name, bind.value);
        }
        return used;
    }

    private HashMap<String, TngReportBind> loadParams() throws Exception {
        HashMap<String, TngReportBind> binds = new HashMap<String, TngReportBind>();
        JRParameter[] params = this.jasperReport.getParameters();
        if (params == null) {
            return binds;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            JRParameter param = params[i2];
            if (param.isSystemDefined()) continue;
            TngReportBind bind = new TngReportBind(false, param.getName(), param.getValueClassName());
            binds.put(bind.name, bind);
        }
        return binds;
    }

    private HashMap<String, TngReportBind> loadFields() throws Exception {
        HashMap<String, TngReportBind> binds = new HashMap<String, TngReportBind>();
        JRField[] fields = this.jasperReport.getFields();
        if (fields == null) {
            return binds;
        }
        for (int i2 = 0; i2 < fields.length; ++i2) {
            JRField field = fields[i2];
            TngReportBind bind = new TngReportBind(true, field.getName(), field.getValueClassName());
            binds.put(bind.name, bind);
        }
        return binds;
    }
}

