/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.TngReportBind;

public class TngReportBindWriter {
    private File file;
    private Writer writer;
    private ArrayList<TngReportBind> binds = new ArrayList();
    private HashMap<String, TngReportBind> index = new HashMap();

    public void setValueString(String name, String value) throws Exception {
        if (value.length() == 0) {
            value = null;
        }
        this.setValue(name, value, 0);
    }

    public void setValueInteger(String name, int value) throws Exception {
        this.setValue(name, value, 1);
    }

    public void setValueBigDecimal(String name, BigDecimal value) throws Exception {
        this.setValue(name, value, 2);
    }

    public void setValueDate(String name, Date value) throws Exception {
        this.setValue(name, value, 3);
    }

    public void setValueBoolean(String name, boolean value) throws Exception {
        this.setValue(name, value, 4);
    }

    public void setValue(TngReportBind bind) throws Exception {
        this.setValue(bind.name, bind.value, bind.type);
    }

    private void setValue(String name, Object value, int type) throws Exception {
        TngReportBind bind = this.index.get(name);
        if (bind == null) {
            bind = new TngReportBind(true, name, type);
            bind.value = value;
            bind.changed = true;
            this.binds.add(bind);
            this.index.put(name, bind);
        } else {
            if (bind.type != type) {
                throw new Exception(Nat.x("%1 men\u00ed typ", bind.getFullName()));
            }
            if (bind.changed) {
                throw new Exception(Nat.x("%1 u\u017e m\u00e1 nastaven\u00fa hodnotu", bind.getFullName()));
            }
            if (value == bind.value) {
                return;
            }
            if (value != null && value.equals(bind.value)) {
                return;
            }
            bind.value = value;
            bind.changed = true;
            this.binds.add(bind);
        }
    }

    public void setFile(File file) {
        if (file == null) {
            this.file = file;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void begin() throws Exception {
        if (this.file == null) {
            this.file = File.createTempFile("reports", ".tmp");
            this.file.deleteOnExit();
        }
        this.writer = new BufferedWriter(new FileWriter(this.file));
        this.writer.write("#BEGIN\r");
    }

    public void end() throws Exception {
        this.binds.clear();
        this.index.clear();
        this.writer.write("#END\r");
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }

    public void close() {
        TngUtilities.closeSafe(this.writer);
        this.writer = null;
    }

    public void delete() {
        this.close();
        if (this.file != null && this.file.isFile()) {
            this.file.delete();
        }
        this.file = null;
    }

    public void write() throws Exception {
        for (int i2 = 0; i2 < this.binds.size(); ++i2) {
            TngReportBind bind = this.binds.get(i2);
            if (!bind.changed) continue;
            bind.changed = false;
            this.writer.write(bind.name);
            this.writer.write(61);
            if (bind.value != null) {
                this.writeValue(bind.value);
            }
            this.writer.write(13);
        }
        this.writer.write("#\r");
    }

    private void writeValue(Object value) throws Exception {
        if (value instanceof BigDecimal || value instanceof Integer) {
            this.writer.write(value.toString());
        } else if (value instanceof Date) {
            String h2 = TngReportBind.sdfYYYYMMDDHHMMSS.format((Date)value);
            if (h2.endsWith("000000")) {
                this.writer.write(h2, 0, 8);
            } else {
                this.writer.write(h2);
            }
        } else if (value instanceof Boolean) {
            Boolean b2 = (Boolean)value;
            this.writer.write(b2 != false ? 49 : 48);
        } else {
            String s2 = value.toString();
            if (s2.indexOf(13) >= 0) {
                for (int i2 = 0; i2 < s2.length(); ++i2) {
                    char c2 = s2.charAt(i2);
                    if (c2 == '\r') continue;
                    this.writer.write(c2);
                }
            } else {
                this.writer.write(s2);
            }
        }
    }
}

