/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.alternative.TngReportAlternative;

public class TngReportFile
implements Comparable<TngReportFile> {
    private String fullTitle;
    private String fileJrxml;
    private String fileAlter;

    public TngReportFile(String fullTitle, String fileJrxml) {
        this.fullTitle = fullTitle;
        this.fileJrxml = fileJrxml;
        this.fileAlter = null;
    }

    public TngReportFile(TngReportFile reportFile, String fullTitleAlter, String fileAlter) {
        this.fullTitle = reportFile.fullTitle + " (" + fullTitleAlter + ")";
        this.fileJrxml = reportFile.fileJrxml;
        this.fileAlter = fileAlter;
    }

    public void setFileAlter(String fileAlter) {
        this.fileAlter = fileAlter;
    }

    public String getTitle() {
        int f2 = this.fullTitle.indexOf(126);
        if (f2 < 0 || f2 > 3) {
            return this.fullTitle;
        }
        this.fullTitle = this.fullTitle.substring(f2 + 1);
        return this.fullTitle;
    }

    public String getFileJrml() {
        return this.fileJrxml;
    }

    public String getFileAlter() {
        return this.fileAlter;
    }

    public String getFileTrap() {
        if (this.fileAlter == null) {
            return this.fileJrxml;
        }
        return this.fileJrxml + "*" + this.fileAlter;
    }

    public String getJrxmlName() {
        String name = new File(this.fileJrxml).getName();
        return name.substring(0, name.length() - 6);
    }

    @Override
    public int compareTo(TngReportFile o2) {
        int c2 = this.fullTitle.compareTo(o2.fullTitle);
        if (c2 != 0) {
            return c2;
        }
        c2 = this.fileJrxml.compareTo(o2.fileJrxml);
        return c2;
    }

    public static List<TngReportFile> getFiles(String prefix, String dir) throws Exception {
        if (prefix == null || prefix.length() == 0) {
            throw new Exception(Nat.x("Nezadan\u00fd prefix JRXML s\u00faborov"));
        }
        if (dir == null || dir.length() == 0) {
            throw new Exception(Nat.x("Nezadan\u00fd adres\u00e1r pre JRXML s\u00fabory"));
        }
        File fileDir = new File(dir);
        if (!fileDir.isDirectory()) {
            throw new Exception(Nat.x("Adres\u00e1r pre JRXML s\u00fabory %1 neexistuje", dir));
        }
        ArrayList<TngReportFile> rfiles = new ArrayList<TngReportFile>();
        File fileReportsZip = new File(fileDir, "reports.zip");
        File fileCustomDir = new File(fileDir, "custom");
        TngReportFile.addFilesFromZip(prefix, fileReportsZip, rfiles);
        TngReportFile.addFilesFromDirectory(prefix, fileCustomDir, rfiles);
        TngReportFile.addAlternatives(fileReportsZip, fileCustomDir, rfiles);
        Collections.sort(rfiles);
        return rfiles;
    }

    public static void addFilesFromDirectory(String prefix, File fileDir, ArrayList<TngReportFile> rfiles) throws Exception {
        if (!fileDir.isDirectory()) {
            return;
        }
        final String prefixLower = prefix == null ? null : prefix.toLowerCase();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowerName = name.toLowerCase();
                return lowerName.endsWith(".jrxml") && (prefixLower == null || lowerName.startsWith(prefixLower));
            }
        };
        File[] files = fileDir.listFiles(filter);
        for (int i2 = 0; i2 < files.length; ++i2) {
            File f2 = files[i2];
            String title = TngReportFile.getReportTitle(f2);
            TngReportFile r2 = new TngReportFile(title, f2.getAbsolutePath());
            rfiles.add(r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilesFromZip(String prefix, File fileZip, ArrayList<TngReportFile> rfiles) throws Exception {
        if (!fileZip.isFile()) {
            return;
        }
        String prefixLower = prefix == null ? null : prefix.toLowerCase();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileZip);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String lowerName = zipEntry.getName().toLowerCase();
                if (!lowerName.endsWith(".jrxml") || prefixLower != null && !lowerName.startsWith(prefixLower)) continue;
                String title = TngReportFile.getReportTitle(zipFile, zipEntry);
                TngReportFile r2 = new TngReportFile(title, fileZip.getAbsolutePath() + "\\" + zipEntry.getName());
                rfiles.add(r2);
            }
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.closeSafe(zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAlternatives(File fileZip, File fileDir, ArrayList<TngReportFile> rfiles) throws Exception {
        ZipFile zipFile = null;
        try {
            if (fileZip.isFile()) {
                zipFile = new ZipFile(fileZip);
            }
            int size = rfiles.size();
            for (int i2 = 0; i2 < size; ++i2) {
                TngReportFile r2 = rfiles.get(i2);
                if (zipFile != null) {
                    TngReportFile.addAlternativesFromZip(r2, fileZip, zipFile, rfiles);
                }
                TngReportFile.addAlternativesFromDirectory(r2, fileDir, rfiles);
            }
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.closeSafe(zipFile);
    }

    public static void addAlternativesFromDirectory(TngReportFile reportFile, File fileDir, ArrayList<TngReportFile> rfiles) throws Exception {
        if (!fileDir.isDirectory()) {
            return;
        }
        final String prefixLower = reportFile.getJrxmlName().toLowerCase();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowerName = name.toLowerCase();
                return lowerName.startsWith(prefixLower) && lowerName.endsWith(".alter");
            }
        };
        File[] files = fileDir.listFiles(filter);
        for (int i2 = 0; i2 < files.length; ++i2) {
            File f2 = files[i2];
            String title = TngReportFile.getAlternativeTitle(f2);
            rfiles.add(new TngReportFile(reportFile, title, f2.getAbsolutePath()));
        }
    }

    public static void addAlternativesFromZip(TngReportFile reportFile, File fileZip, ZipFile zipFile, ArrayList<TngReportFile> rfiles) throws Exception {
        String prefixLower = reportFile.getJrxmlName().toLowerCase();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String lowerName = zipEntry.getName().toLowerCase();
            if (!lowerName.startsWith(prefixLower) || !lowerName.endsWith(".alter")) continue;
            String title = TngReportFile.getAlternativeTitle(zipFile, zipEntry);
            rfiles.add(new TngReportFile(reportFile, title, fileZip.getAbsolutePath() + "\\" + zipEntry.getName()));
        }
    }

    public static String getReportTitle(File file) {
        String title = null;
        try {
            JasperDesign jasperDesign = JRXmlLoader.load(file);
            title = jasperDesign.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (title == null || title.length() == 0) {
            title = file.getAbsolutePath();
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReportTitle(ZipFile zipFile, ZipEntry zipEntry) {
        String title = null;
        InputStream stream = null;
        try {
            stream = zipFile.getInputStream(zipEntry);
            JasperDesign jasperDesign = JRXmlLoader.load(stream);
            title = jasperDesign.getName();
        }
        catch (Throwable e2) {
        }
        finally {
            TngUtilities.streamCloseSafe(stream);
        }
        if (title == null || title.length() == 0) {
            title = zipFile.getName() + ":" + zipEntry.getName();
        }
        return title;
    }

    public static String getAlternativeTitle(File file) {
        String title = null;
        try {
            TngReportAlternative a2 = TngReportAlternative.load(file);
            title = a2.getTitle();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (title == null || title.length() == 0) {
            title = file.getName();
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAlternativeTitle(ZipFile zipFile, ZipEntry zipEntry) {
        String title = null;
        InputStream stream = null;
        try {
            stream = zipFile.getInputStream(zipEntry);
            TngReportAlternative a2 = TngReportAlternative.load(stream);
            title = a2.getTitle();
        }
        catch (Throwable e2) {
        }
        finally {
            TngUtilities.streamCloseSafe(stream);
        }
        if (title == null || title.length() == 0) {
            title = zipEntry.getName();
        }
        return title;
    }

    public static TngReportFile getReportFileByFileTrap(List<TngReportFile> reportFiles, String fileTrap) {
        if (reportFiles == null || reportFiles.size() == 0) {
            return null;
        }
        for (TngReportFile reportFile : reportFiles) {
            if (!reportFile.getFileTrap().equals(fileTrap)) continue;
            return reportFile;
        }
        return reportFiles.get(0);
    }
}

