/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;

public class TngReportFormat
extends DefaultFormatFactory {
    public static final String PRERFIX_DECIMAL_ALIGN = "'ALIGN_TO_DEC'";

    @Override
    public DateFormat createDateFormat(String string, Locale locale, TimeZone tz) {
        return super.createDateFormat(string, locale, tz);
    }

    @Override
    public NumberFormat createNumberFormat(String string, Locale locale) {
        NumberFormat format;
        boolean decimalAlign;
        boolean bl = decimalAlign = string != null && string.startsWith(PRERFIX_DECIMAL_ALIGN);
        if (decimalAlign) {
            string = string.substring(PRERFIX_DECIMAL_ALIGN.length());
        }
        if (decimalAlign & (format = super.createNumberFormat(string, locale)) instanceof DecimalFormat) {
            return new ReportFormatDecimalAlign((DecimalFormat)format, null);
        }
        return format;
    }

    public static StringBuffer hideDecimalZeros(StringBuffer number, char decimalChar) {
        int zer;
        int end;
        int dec;
        for (dec = 0; dec < number.length() && number.charAt(dec) != decimalChar; ++dec) {
        }
        if (dec == number.length()) {
            return number;
        }
        for (end = dec + 1; end < number.length() && Character.isDigit(number.charAt(end)); ++end) {
        }
        if (--end == dec) {
            return number;
        }
        for (zer = end; zer > dec && number.charAt(zer) == '0'; --zer) {
        }
        if (zer == end) {
            return number;
        }
        if (zer == dec) {
            --zer;
        }
        number.insert(end + 1, "</style>");
        number.insert(zer + 1, "<style forecolor=\"white\">");
        return number;
    }

    private class ReportFormatDecimalAlign
    extends NumberFormat {
        private DecimalFormat format;
        private char decimalChar;

        private ReportFormatDecimalAlign(DecimalFormat format, Locale locale) {
            this.format = format;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            this.decimalChar = symbols.getDecimalSeparator();
        }

        @Override
        public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
            this.format.format(number, toAppendTo, pos);
            return TngReportFormat.hideDecimalZeros(toAppendTo, this.decimalChar);
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format.format(number, toAppendTo, pos);
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format.format(number, toAppendTo, pos);
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return this.format.parse(source, parsePosition);
        }
    }
}

