/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRField;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.report.TngReportBind;
import tangram.report.TngReportBindWriter;
import tangram.swing.panel.TngProgressableWorker;

public class TngReportSelectReader
implements JRDataSource {
    private HashMap<String, TngReportBind> binds;
    private TngReportBindWriter dataWriter;
    private TngConnection connection;
    private Statement st;
    private ResultSet rs;
    private TngReportBind[] colBinds;
    private int[] colIndexes;
    private int colCount;
    private String select;
    private Exception nextException;
    private TngProgressableWorker worker;

    public void open(TngConnection connection, String select, TngReportBindWriter dataWriter, TngProgressableWorker worker, HashMap<String, TngReportBind> binds) throws Exception {
        this.close();
        this.connection = connection;
        this.select = select;
        this.dataWriter = dataWriter;
        this.worker = worker;
        this.binds = binds;
        worker.setProgressCancelable(true);
        worker.setProgressMax(-1);
        this.st = connection.execStatement(select);
        this.rs = this.st.getResultSet();
        this.prepareResultColumns();
    }

    public void close() {
        if (this.connection != null) {
            this.connection.close(this.st);
        }
        this.connection = null;
        this.st = null;
        this.rs = null;
        this.worker = null;
        this.dataWriter = null;
        this.colBinds = null;
        this.colIndexes = null;
        this.colCount = 0;
    }

    public boolean hasSelect(String selectCompare) {
        if (this.select == null) {
            return false;
        }
        return this.select.equals(selectCompare);
    }

    private void prepareResultColumns() throws Exception {
        ResultSetMetaData rsm = this.rs.getMetaData();
        int count = rsm.getColumnCount();
        this.colBinds = new TngReportBind[count];
        this.colIndexes = new int[count];
        this.colCount = 0;
        String[] names = this.binds.keySet().toArray(new String[0]);
        for (int i2 = 1; i2 <= count; ++i2) {
            String name = rsm.getColumnName(i2);
            TngReportBind bind = this.binds.get(name = this.findIgnoreCase(names, name));
            if (bind == null) continue;
            this.colBinds[this.colCount] = bind;
            this.colIndexes[this.colCount] = i2;
            ++this.colCount;
        }
    }

    private String findIgnoreCase(String[] names, String name) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (!name.equalsIgnoreCase(names[i2])) continue;
            return names[i2];
        }
        return null;
    }

    private void resolveValues() throws Exception {
        for (int i2 = 0; i2 < this.colCount; ++i2) {
            TngReportBind bind = this.colBinds[i2];
            int idx = this.colIndexes[i2];
            int type = bind.type;
            if (type == 0) {
                bind.setValueString(this.rs.getString(idx));
            } else if (type == 1) {
                bind.setValueInteger(this.rs.getInt(idx));
            } else if (type == 2) {
                bind.setValueBigDecimal(this.rs.getBigDecimal(idx));
            } else if (type == 3) {
                bind.setValueDate(this.rs.getDate(idx));
            } else if (type == 4) {
                bind.setValueBoolean("1".equals(this.rs.getString(idx)));
            } else {
                throw new Exception(Nat.x("Nezn\u00e1my typ pre pole %1", bind.name));
            }
            this.dataWriter.setValue(bind);
        }
        this.dataWriter.write();
    }

    public Exception getNextException() {
        return this.nextException;
    }

    @Override
    public boolean next() {
        try {
            if (!this.rs.next()) {
                return false;
            }
            if (this.rs.getRow() == 1) {
                this.worker.setProgressMax(this.rs.getInt(1));
            }
            this.worker.addProgressValue(1);
            if (this.worker.isProgressCanceled()) {
                return false;
            }
            this.resolveValues();
            return true;
        }
        catch (Exception e2) {
            this.nextException = e2;
            return false;
        }
    }

    @Override
    public Object getFieldValue(JRField jrField) {
        TngReportBind bind = this.binds.get(jrField.getName());
        if (bind == null) {
            return null;
        }
        if (bind.value == null && bind.type == 0) {
            return "";
        }
        return bind.value;
    }
}

