/*
 * Decompiled with CFR 0.152.
 */
package tangram.report;

import java.util.HashMap;
import java.util.List;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.report.TngReport;
import tangram.report.TngReportFile;
import tangram.swing.panel.TngProgressableWorker;

public class TngReports {
    private static final HashMap<String, TngReport> reports = new HashMap();

    public static void create(String id) throws Exception {
        if (reports.containsKey(id)) {
            throw new Exception(Nat.x("Tla\u010dov\u00e1 zostava %1 u\u017e existuje", id));
        }
        reports.put(id, new TngReport());
    }

    public static void close(String id) {
        TngReport report = reports.get(id);
        if (report != null) {
            report.close();
            reports.remove(id);
        }
    }

    public static List<TngReportFile> getFiles(String prefix, String dir) throws Exception {
        return TngReportFile.getFiles(prefix, dir);
    }

    public static void load(String id, String fileJrxml) throws Exception {
        TngReports.getReport(id).load(fileJrxml);
    }

    public static List<String> getParams(String id) throws Exception {
        return TngReports.getReport(id).getParams();
    }

    public static List<String> getFields(String id) throws Exception {
        return TngReports.getReport(id).getFields();
    }

    public static void fill(String id, String paramsFile, String fieldsFile, TngProgressableWorker worker) throws Exception {
        TngReport report = TngReports.getReport(id);
        report.setWorker(worker);
        report.fill(paramsFile, fieldsFile);
    }

    public static void fillSelect(String id, String paramsData, TngConnection connection, String select, boolean forced, TngProgressableWorker worker) throws Exception {
        TngReport report = TngReports.getReport(id);
        report.setWorker(worker);
        report.fill(paramsData, connection, select, forced);
    }

    public static int getPages(String id) throws Exception {
        return TngReports.getReport(id).getPages();
    }

    public static void getPage(String id, int page, float zoom, String format, String filePng) throws Exception {
        TngReports.getReport(id).getPage(page, zoom, format, filePng);
    }

    public static void print(String id, String printer, int pageStart, int pageEnd, int copies, boolean displayDialog, TngProgressableWorker worker) throws Exception {
        TngReport report = TngReports.getReport(id);
        report.setWorker(worker);
        report.print(printer, pageStart, pageEnd, copies, displayDialog);
    }

    public static void exportToPdf(String id, String pdfFile, int pageStart, int pageEnd, TngProgressableWorker worker) throws Exception {
        TngReport report = TngReports.getReport(id);
        report.setWorker(worker);
        report.exportToPdf(pdfFile, pageStart, pageEnd);
    }

    public static void exportToXls(String id, String xlsFile, TngProgressableWorker worker) throws Exception {
        TngReport report = TngReports.getReport(id);
        report.setWorker(worker);
        report.exportToXls(xlsFile);
    }

    private static TngReport getReport(String id) throws Exception {
        TngReport report = reports.get(id);
        if (report == null) {
            throw new Exception(Nat.x("Tla\u010dov\u00e1 zostava pre ID %1 nebola vytvoren\u00e1", id));
        }
        return report;
    }
}

