/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.alternative;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.TngReportFile;
import tangram.report.alternative.TngReportAlternative;
import tangram.report.alternative.field.TngReportAlternativeDefinitionField;
import tangram.report.alternative.field.TngReportAlternativeFieldAlign;

public class TngReportAlternativeDesigner {
    private String fileJrxml;
    private int totalWidth;
    private List<TngReportAlternativeDefinitionField> fieldDefinitions;
    private String fileAlter;
    private TngReportAlternative alternative;
    private boolean isNew;

    public String getFileJrxml() {
        return this.fileJrxml;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public List<TngReportAlternativeDefinitionField> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFileAlter(String fileAlter) {
        this.fileAlter = fileAlter;
    }

    public String getFileAlter() {
        return this.fileAlter;
    }

    public TngReportAlternative getAlternative() {
        return this.alternative;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void createFileAlter(String alterName) {
        String name = new File(this.fileJrxml).getAbsolutePath();
        name = name.substring(0, name.length() - 6);
        name = name.replace("reports.zip", "custom");
        this.fileAlter = name + "_" + alterName + ".alter";
    }

    public static List<TngReportFile> getJrxmlFiles(File fileDir) throws Exception {
        ArrayList<TngReportFile> rfiles = new ArrayList<TngReportFile>();
        TngReportFile.addFilesFromZip(null, new File(fileDir, "reports.zip"), rfiles);
        TngReportFile.addFilesFromDirectory(null, new File(fileDir, "custom"), rfiles);
        Collections.sort(rfiles);
        return rfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TngReportFile> getAlternatives(TngReportFile rfile, File fileDir) throws Exception {
        ArrayList<TngReportFile> rfiles = new ArrayList<TngReportFile>();
        rfiles.add(rfile);
        ZipFile zipFile = null;
        try {
            File fileZip = new File(fileDir, "reports.zip");
            if (fileZip.isFile()) {
                zipFile = new ZipFile(fileZip);
                TngReportFile.addAlternativesFromZip(rfile, fileZip, zipFile, rfiles);
            }
        }
        finally {
            TngUtilities.closeSafe(zipFile);
        }
        TngReportFile.addAlternativesFromDirectory(rfile, new File(fileDir, "custom"), rfiles);
        Collections.sort(rfiles);
        return rfiles;
    }

    public void load(String fileJrxml, String fileAlter) throws Exception {
        this.alternative = TngUtilities.isEmpty(fileAlter) ? new TngReportAlternative() : TngReportAlternative.load(fileAlter);
        JasperDesign jasperDesign = null;
        int p1 = (fileJrxml = fileJrxml.replace('/', '\\')).indexOf(".zip\\");
        if (p1 > 0) {
            String zip = fileJrxml.substring(0, p1 += 4);
            String file = fileJrxml.substring(p1 + 1);
            jasperDesign = TngReportAlternativeDesigner.loadJrxmlFromZip(zip, file);
        } else {
            jasperDesign = JRXmlLoader.load(fileJrxml);
        }
        int p2 = TngUtilities.isEmpty(fileAlter) ? -1 : fileAlter.indexOf(".zip\\");
        this.fileJrxml = fileJrxml;
        this.fileAlter = p2 > 0 ? null : fileAlter;
        this.isNew = TngUtilities.isEmpty(fileAlter);
        this.totalWidth = jasperDesign.getPageWidth() - jasperDesign.getLeftMargin() - jasperDesign.getRightMargin();
        this.fieldDefinitions = TngReportAlternativeDesigner.getFieldDefinitions(jasperDesign);
    }

    public void save() throws Exception {
        this.alternative.marshal(new File(this.fileAlter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JasperDesign loadJrxmlFromZip(String zip, String fileJrxml) throws Exception {
        JasperDesign jasperDesign;
        File fileZip = new File(zip);
        ZipFile zipFile = null;
        InputStream stream = null;
        try {
            zipFile = new ZipFile(fileZip);
            ZipEntry zipEntry = zipFile.getEntry(fileJrxml);
            if (zipEntry == null) {
                throw new Exception(Nat.x("JASPER s\u00fabor %1 neexistuje v ZIP s\u00fabore %2", fileJrxml, fileZip.getAbsolutePath()));
            }
            stream = zipFile.getInputStream(zipEntry);
            jasperDesign = JRXmlLoader.load(stream);
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(stream);
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(stream);
        TngUtilities.closeSafe(zipFile);
        return jasperDesign;
    }

    private static List<TngReportAlternativeDefinitionField> getFieldDefinitions(JasperDesign jasperDesign) {
        ArrayList<TngReportAlternativeDefinitionField> defs = new ArrayList<TngReportAlternativeDefinitionField>();
        List<JRField> fields = jasperDesign.getFieldsList();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            JRDesignField f2 = (JRDesignField)fields.get(i2);
            TngReportAlternativeDefinitionField d2 = new TngReportAlternativeDefinitionField();
            d2.name = f2.getName();
            String[] c2 = TngUtilities.strTokenizeNotNull(f2.getDescription(), '~');
            if (c2.length > 0) {
                d2.title = c2[0].trim();
            }
            if (c2.length > 1) {
                d2.align = TngReportAlternativeDesigner.getAlignFromString(c2[1].trim());
            }
            if (c2.length > 2) {
                d2.format = TngUtilities.emptyToNull(c2[2].trim());
            }
            if (d2.title == null || d2.title.length() == 0) {
                d2.title = d2.name;
            }
            if (d2.align == null) {
                d2.align = TngReportAlternativeFieldAlign.LEFT;
            }
            defs.add(d2);
        }
        return defs;
    }

    private static TngReportAlternativeFieldAlign getAlignFromString(String align) {
        if ("R".equalsIgnoreCase(align)) {
            return TngReportAlternativeFieldAlign.RIGHT;
        }
        if ("C".equalsIgnoreCase(align)) {
            return TngReportAlternativeFieldAlign.CENTER;
        }
        return TngReportAlternativeFieldAlign.LEFT;
    }
}

