/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.alternative;

import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.report.alternative.TngReportAlternative;
import tangram.report.alternative.field.TngReportAlternativeFieldAlign;
import tangram.report.alternative.field.TngReportAlternativeRowField;

public class TngReportAlternativeExecutor {
    private static final int ROW_HEIGHT = 11;

    public static void modifyReport(JasperDesign jasperDesign, TngReportAlternative alter) throws Exception {
        TngReportAlternativeExecutor.validateReport(jasperDesign);
        TngReportAlternativeExecutor.validateAlter(alter);
        JRBand[] details = jasperDesign.getDetailSection().getBands();
        TngReportAlternativeExecutor.addReportHeader((JRDesignBand)details[0], alter);
        TngReportAlternativeExecutor.addReportDetail((JRDesignBand)details[1], alter);
    }

    private static void addReportHeader(JRDesignBand band, TngReportAlternative alter) {
        int rows = alter.getRowsCount();
        int bandHeight = rows * 11;
        band.setHeight(bandHeight);
        TngReportAlternativeExecutor.clearReportBand(band, "tFrameHeader", bandHeight);
        for (int i2 = 0; i2 < rows; ++i2) {
            TngReportAlternativeExecutor.addReportHeaderRow(band, alter, i2);
        }
    }

    private static void addReportDetail(JRDesignBand band, TngReportAlternative alter) {
        int rows = alter.getRowsCount();
        int bandHeight = rows * 11;
        band.setHeight(bandHeight);
        TngReportAlternativeExecutor.clearReportBand(band, "tFrameDetail", bandHeight);
        for (int i2 = 0; i2 < rows; ++i2) {
            TngReportAlternativeExecutor.addReportDetailRow(band, alter, i2);
        }
    }

    private static void addReportHeaderRow(JRDesignBand band, TngReportAlternative alter, int r2) {
        int x = 0;
        int y = r2 * 11;
        List<TngReportAlternativeRowField> row = alter.getRow(r2);
        List<JRChild> children = band.getChildren();
        for (int i2 = 0; i2 < row.size(); ++i2) {
            TngReportAlternativeRowField a2 = row.get(i2);
            JRDesignStaticText child = new JRDesignStaticText();
            child.setX(x);
            child.setY(y);
            child.setWidth(a2.getWidth());
            child.setHeight(11);
            child.setStyleNameReference("tTextBoldNoLine");
            child.setText(a2.getTitle());
            if (a2.getAlign() == TngReportAlternativeFieldAlign.RIGHT) {
                child.setHorizontalAlignment(HorizontalAlignEnum.RIGHT);
            } else if (a2.getAlign() == TngReportAlternativeFieldAlign.CENTER) {
                child.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
            }
            children.add(child);
            x += a2.getWidth();
        }
    }

    private static void addReportDetailRow(JRDesignBand band, TngReportAlternative alter, int r2) {
        int x = 0;
        int y = r2 * 11;
        List<TngReportAlternativeRowField> row = alter.getRow(r2);
        List<JRChild> children = band.getChildren();
        for (int i2 = 0; i2 < row.size(); ++i2) {
            TngReportAlternativeRowField a2 = row.get(i2);
            JRDesignTextField child = new JRDesignTextField();
            child.setX(x);
            child.setY(y);
            child.setWidth(a2.getWidth());
            child.setHeight(11);
            child.setStyleNameReference("tTextNoLine");
            child.setExpression(new JRDesignExpression("$F{" + a2.getName() + "}"));
            child.setPattern(a2.getFormat());
            if (a2.getAlign() == TngReportAlternativeFieldAlign.RIGHT) {
                child.setHorizontalAlignment(HorizontalAlignEnum.RIGHT);
            } else if (a2.getAlign() == TngReportAlternativeFieldAlign.CENTER) {
                child.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
            }
            children.add(child);
            x += a2.getWidth();
        }
    }

    private static void saveToJrxml(JasperDesign jasperDesign) throws Exception {
        JasperReport jasperReport = JasperCompileManager.compileReport(jasperDesign);
        JasperCompileManager.writeReportToXmlFile(jasperReport, "e:\\temp\\test.jrxml");
    }

    private static void clearReportBand(JRDesignBand band, String undeleteStyle, int bandHeight) {
        List<JRChild> children = band.getChildren();
        for (int i2 = children.size() - 1; i2 >= 0; --i2) {
            JRChild child = children.get(i2);
            if (!(child instanceof JRElement)) continue;
            JRElement e2 = (JRElement)child;
            String style = e2.getStyleNameReference();
            if (undeleteStyle != null && undeleteStyle.equals(style) && e2 instanceof JRDesignStaticText) {
                JRDesignStaticText t = (JRDesignStaticText)e2;
                t.setHeight(bandHeight);
                continue;
            }
            children.remove(child);
        }
    }

    public static void validateReport(JasperDesign jasperDesign) throws Exception {
        JRSection details = jasperDesign.getDetailSection();
        if (details.getBands().length < 2) {
            throw new Exception(Nat.x("JRXML s\u00fabor nem\u00e1 band Detail 1 alebo Detail 2"));
        }
    }

    public static void validateAlter(TngReportAlternative alter) throws Exception {
        if (TngUtilities.isEmpty(alter.getTitle())) {
            throw new Exception(Nat.x("Alternat\u00edva nem\u00e1 titulok"));
        }
        int rows = alter.getRowsCount();
        if (rows == 0) {
            throw new Exception(Nat.x("Alternat\u00edva nem\u00e1 \u017eiaden riadok"));
        }
        for (int i2 = 0; i2 < rows; ++i2) {
            TngReportAlternativeExecutor.validateAlterRow(alter, i2);
        }
    }

    private static void validateAlterRow(TngReportAlternative alter, int r2) throws Exception {
        List<TngReportAlternativeRowField> row = alter.getRow(r2);
        if (row.size() == 0) {
            throw new Exception(Nat.x("%1. riadok alternat\u00edvy nem\u00e1 \u017eiadne pole", r2 + 1));
        }
        for (int i2 = 0; i2 < row.size(); ++i2) {
            TngReportAlternativeRowField a2 = row.get(i2);
            if (TngUtilities.isEmpty(a2.getName())) {
                throw new Exception(Nat.x("%1. riadok alternat\u00edvy nem\u00e1 v %2. poli k\u00f3d po\u013ea", r2 + 1, i2 + 1));
            }
            if (TngUtilities.isEmpty(a2.getTitle())) {
                throw new Exception(Nat.x("%1. riadok alternat\u00edvy nem\u00e1 v %2. poli n\u00e1zov po\u013ea", r2 + 1, i2 + 1));
            }
            if (a2.getWidth() >= 1) continue;
            throw new Exception(Nat.x("%1. riadok alternat\u00edvy nem\u00e1 v %2. poli \u0161\u00edrku po\u013ea", r2 + 1, i2 + 1));
        }
    }
}

