/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.variant;

import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngParams;
import tangram.report.variant.TngReportVariant;
import tangram.report.variant.TngReportVariantOperator;
import tangram.swing.TngSwing;

public class TngReportVariantOperatorString
implements TngReportVariantOperator {
    public static final String KEY_PREFIX = "Report_Variant_";
    public static final String KEY_PREFIX_USER = "Report_Variant_Default_";
    private TngConnection conn;

    public TngReportVariantOperatorString(TngConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean load(String prefix, List<TngReportVariant> variants) {
        try {
            Object hodnota = this.conn.queryObject("SELECT hodnota FROM tngvar WHERE kluc='" + KEY_PREFIX + prefix + "'");
            this.fromString(hodnota == null ? "" : hodnota.toString(), variants);
            return true;
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed ulo\u017een\u00fdch parametrov"), e2);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String prefix, List<TngReportVariant> variants) {
        if (variants == null) {
            return false;
        }
        PreparedStatement st = null;
        boolean rollback = false;
        try {
            String value = this.toString(variants);
            this.conn.exec("DELETE tngvar WHERE kluc='Report_Variant_" + prefix + "'");
            rollback = true;
            st = this.conn.prepareStatement("INSERT INTO tngvar(kluc,hodnota) VALUES(?,?)");
            st.setString(1, KEY_PREFIX + prefix);
            st.setString(2, value);
            st.execute();
            this.conn.commit();
            rollback = false;
            boolean bl = true;
            if (rollback) {
                this.conn.rollback();
            }
            this.conn.close(st);
            return bl;
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri ukladan\u00ed ulo\u017een\u00fdch parametrov"), e2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rollback) {
                this.conn.rollback();
            }
            this.conn.close(st);
        }
    }

    private void fromString(String s2, List<TngReportVariant> variants) throws Exception {
        if (s2 == null || s2.length() == 0) {
            return;
        }
        Collection toAdd = null;
        if (toAdd != null) {
            variants.addAll(toAdd);
        }
    }

    private String toString(List<TngReportVariant> variants) throws Exception {
        if (variants == null || variants.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("COUNT{" + variants.size() + "} ");
        int pc = 1;
        for (TngReportVariant variant : variants) {
            sb.append("VARIANT" + pc++ + "{");
            this.variantToString(variant, sb);
            sb.append("} ");
        }
        return sb.toString();
    }

    private void variantToString(TngReportVariant variant, StringBuilder sb) {
        sb.append("NAME{" + (variant.name == null ? "" : variant.name) + "} ");
        sb.append("REPORT{" + (variant.reportFileName == null ? "" : variant.reportFileName) + "} ");
        sb.append("COPIES{" + (variant.copies < 0 ? 1 : variant.copies) + "} ");
        sb.append("ORDER_BY{" + (variant.orderBy == null ? "" : variant.orderBy) + "} ");
        sb.append("ORDER_BY_REVERSED{" + (variant.orderByReversed ? "T" : "F") + "} ");
        sb.append("GROUP_BY{" + (variant.groupBy == null ? "" : variant.groupBy) + "} ");
        sb.append("WHERE{");
        this.variantWhereToString(variant.where, sb);
        sb.append("} ");
        sb.append("NOTE{" + (variant.note == null ? "" : variant.note) + "} ");
    }

    private void variantWhereToString(TngParams where, StringBuilder sb) {
        if (where == null || where.getParams() == null || where.getParams().size() == 0) {
            return;
        }
        sb.append("COUNT{" + where.getParams().size() + "} ");
        Enumeration<String> keys = where.getParams().keys();
        int pc = 1;
        while (keys.hasMoreElements()) {
            sb.append("W" + pc++ + "{");
            String k2 = keys.nextElement();
            String v = where.getParams().get(k2);
            sb.append(k2 + "{" + v + "}");
            sb.append("} ");
        }
    }

    @Override
    public String loadUserDefault(String prefix) {
        try {
            Object hodnota = this.conn.queryObject("SELECT hodnota FROM tngvar WHERE uzivatel=user AND kluc='" + KEY_PREFIX_USER + prefix + "'");
            return hodnota == null ? null : hodnota.toString();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed ulo\u017een\u00fdch parametrov pou\u017e\u00edvate\u013ea"), e2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserDefault(String prefix, String variantName) {
        if (variantName == null) {
            return;
        }
        PreparedStatement st = null;
        boolean rollback = false;
        try {
            this.conn.exec("DELETE tngvar WHERE uzivatel=user AND kluc='Report_Variant_Default_" + prefix + "'");
            rollback = true;
            st = this.conn.prepareStatement("INSERT INTO tngvar(kluc,hodnota,uzivatel) VALUES(?,?,user)");
            st.setString(1, KEY_PREFIX_USER + prefix);
            st.setString(2, variantName);
            st.execute();
            this.conn.commit();
            rollback = false;
            if (rollback) {
                this.conn.rollback();
            }
            this.conn.close(st);
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri ukladan\u00ed ulo\u017een\u00fdch parametrov pou\u017e\u00edvate\u013ea"), e2);
        }
        finally {
            if (rollback) {
                this.conn.rollback();
            }
            this.conn.close(st);
        }
    }
}

