/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JViewport;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.component.TngLabel;

public class TngReportComponent
extends TngLabel {
    private JasperPrint jasperPrint;
    private JRGraphics2DExporter exporter;
    private int pageIndex;
    private float realZoom;
    private boolean fitPage;
    private boolean fitWidth;
    private boolean statusOk;
    private String pageError;
    private int mouseDownX = 0;
    private int mouseDownY = 0;

    public TngReportComponent() {
        try {
            this.jbInit();
            this.clear();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void clear() {
        this.statusOk = false;
        this.jasperPrint = null;
        this.realZoom = 0.1f;
        this.pageIndex = -1;
        this.fitPage = false;
        this.fitWidth = false;
        this.pageError = null;
    }

    public void loadReport(JasperPrint jasperPrint, String errorMessage) {
        this.clear();
        this.jasperPrint = jasperPrint;
        this.pageError = errorMessage;
        this.setPageIndex(0);
    }

    public void setPageIndex(int index) {
        this.statusOk = false;
        if (this.hasPages()) {
            if (index >= 0 && index < this.jasperPrint.getPages().size()) {
                this.pageIndex = index;
            }
            this.statusOk = true;
        }
    }

    public boolean hasPages() {
        return this.jasperPrint != null && this.jasperPrint.getPages() != null && this.jasperPrint.getPages().size() > 0;
    }

    public int getPageCount() {
        return !this.hasPages() ? 0 : this.jasperPrint.getPages().size();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void paintComponent(Graphics g2) {
        this.paintPage((Graphics2D)g2.create());
    }

    protected void paintPage(Graphics2D grx) {
        if (!this.statusOk) {
            this.paintPageMessage(grx);
            return;
        }
        try {
            if (this.exporter == null) {
                this.exporter = this.getGraphics2DExporter();
            } else {
                this.exporter.reset();
            }
            this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
            this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, grx.create());
            this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, this.pageIndex);
            this.exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(this.realZoom));
            this.exporter.setParameter(JRExporterParameter.OFFSET_X, 1);
            this.exporter.setParameter(JRExporterParameter.OFFSET_Y, 1);
            this.exporter.setParameter(JRExporterParameter.FILE_RESOLVER, null);
            this.exporter.exportReport();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.pageError = "CHYBA: " + e2.getMessage();
            this.refreshPage();
        }
    }

    protected JRGraphics2DExporter getGraphics2DExporter() throws JRException {
        return new JRGraphics2DExporter();
    }

    protected void paintPageMessage(Graphics2D grx) {
        grx.setColor(Color.RED);
        grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        grx.drawString(TngUtilities.isEmpty(this.pageError) ? Nat.x("Tla\u010dov\u00e1 zostava je pr\u00e1zdna") : this.pageError, 30, 30);
    }

    protected void refreshPage() {
        Dimension dim = null;
        dim = this.hasPages() && this.statusOk ? new Dimension((int)((float)this.jasperPrint.getPageWidth() * this.realZoom), (int)((float)this.jasperPrint.getPageHeight() * this.realZoom)) : new Dimension((int)this.getPageCanvasWidth(), (int)this.getPageCanvasHeight());
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.revalidate();
        this.repaint();
    }

    protected void componentResized() {
        if (this.fitPage) {
            this.fitPage();
        } else if (this.fitWidth) {
            this.fitWidth();
        }
    }

    protected void fitPage() {
        float widthRatio;
        if (!this.statusOk) {
            return;
        }
        this.fitPage = true;
        this.fitWidth = false;
        float heightRatio = this.getPageCanvasHeight() / (float)this.jasperPrint.getPageHeight();
        this.setRealZoomRatio(heightRatio < (widthRatio = this.getPageCanvasWidth() / (float)this.jasperPrint.getPageWidth()) ? heightRatio : widthRatio);
    }

    protected void fitWidth() {
        if (!this.statusOk) {
            return;
        }
        this.fitPage = false;
        this.fitWidth = true;
        this.setRealZoomRatio(this.getPageCanvasWidth() / (float)this.jasperPrint.getPageWidth());
    }

    protected float getPageCanvasWidth() {
        return (float)this.getVisibleRect().getWidth() - 20.0f;
    }

    protected float getPageCanvasHeight() {
        return (float)this.getVisibleRect().getHeight() - 20.0f;
    }

    public void setZoomRatio(float newZoom) {
        this.fitPage = false;
        this.fitWidth = false;
        this.setRealZoomRatio(newZoom);
    }

    public void addZoomRatio(float addZoom) {
        this.setZoomRatio(this.realZoom + addZoom);
    }

    protected void setRealZoomRatio(float newZoom) {
        if (newZoom < 0.1f) {
            newZoom = 0.1f;
        }
        if (this.realZoom != newZoom) {
            this.realZoom = newZoom;
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(409, 312));
        this.setDoubleBuffered(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TngReportComponent.this.compMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TngReportComponent.this.compMouseReleased();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                TngReportComponent.this.compMouseDragged(evt);
            }
        });
    }

    private void compMousePressed(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.mouseDownX = evt.getX();
        this.mouseDownY = evt.getY();
    }

    private void compMouseDragged(MouseEvent evt) {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.mouseDownX);
            int newY = point.y - (evt.getY() - this.mouseDownY);
            int maxX = this.getWidth() - viewport.getWidth();
            int maxY = this.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    private void compMouseReleased() {
        this.setCursor(Cursor.getDefaultCursor());
    }
}

