/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import tangram.filter.TngFilterSet;
import tangram.library.Nat;
import tangram.library.TngOrderNamed;
import tangram.library.TngParams;
import tangram.library.TngUtilities;
import tangram.report.TngReportFile;
import tangram.report.variant.TngReportVariant;
import tangram.report.variant.TngReportVariantListener;
import tangram.report.visual.TngReportPanelFilter;
import tangram.report.visual.TngReportPanelOrderByGroupBy;
import tangram.report.visual.TngReportPanelPrinter;
import tangram.report.visual.TngReportPanelVariant;
import tangram.report.visual.TngReportPanelVariantCtrl;
import tangram.report.visual.TngReportPanelVariantForm;
import tangram.report.visual.TngReportPanelVariantWizard;
import tangram.report.visual.TngReportParams;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;

public class TngReportPanelConfig
extends TngPanel
implements TngReportVariantListener {
    public static final String PREDEFINED_VARIANT = Nat.x("<preddefinovan\u00fd>");
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngReportPanelVariant jPanelVariant = new TngReportPanelVariant();
    private TngReportPanelPrinter jPanelPrinter = new TngReportPanelPrinter();
    private TngReportPanelOrderByGroupBy jPanelOrderByGroupBy = new TngReportPanelOrderByGroupBy();
    private TngReportPanelFilter jPanelFilter = new TngReportPanelFilter();
    private TngReportPanelVariantCtrl jPanelVariantCtrl = new TngReportPanelVariantCtrl();
    private TngReportParams reportParams;
    private List<TngOrderNamed> definitionOrderBy;
    private List<TngOrderNamed> definitionGroupBy;
    private TngFilterSet definitionFilterSet;
    private boolean isInitializing = false;
    private boolean firstRun = true;

    public TngReportPanelConfig() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(TngReportParams reportParams, List<TngOrderNamed> definitionOrderBy, List<TngOrderNamed> definitionGroupBy, TngFilterSet definitionFilterSet) {
        this.reportParams = reportParams;
        this.definitionOrderBy = definitionOrderBy;
        this.definitionGroupBy = definitionGroupBy;
        this.definitionFilterSet = definitionFilterSet;
        this.isInitializing = true;
        try {
            this.jPanelVariant.init(reportParams);
            this.jPanelVariant.writeParams(reportParams);
            this.jPanelPrinter.init(reportParams.prefix);
            this.jPanelPrinter.writeParams(reportParams);
            this.jPanelOrderByGroupBy.init(definitionOrderBy, definitionGroupBy);
            this.jPanelOrderByGroupBy.writeParams(reportParams);
            this.jPanelFilter.init(definitionFilterSet);
            this.jPanelFilter.writeParams(reportParams);
        }
        finally {
            this.isInitializing = false;
        }
        this.firstRun();
        this.jPanelVariantCtrl.setVisible(reportParams.isVariantEnabled());
        TngSwing.setOptimalHeight(this);
    }

    private void firstRun() {
        if (this.firstRun) {
            TngReportVariant toSelect = TngReportVariant.getVariantByName(this.jPanelVariant.getVariants(), this.reportParams.loadUserVariantName());
            if (toSelect != null) {
                this.reportParams.variant = toSelect;
            }
            this.firstRun = false;
            this.jPanelVariant.writeParams(this.reportParams);
        }
    }

    @Override
    public void doAfterShow() {
        super.doAfterShow();
        this.readAllParams();
    }

    private void readAllParams() {
        this.jPanelVariant.readParams(this.reportParams);
        this.jPanelPrinter.readParams(this.reportParams);
        this.jPanelOrderByGroupBy.readParams(this.reportParams);
        this.jPanelFilter.readParams(this.reportParams);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(660, 54));
        this.jPanelVariant.setVariantListener(this);
        this.jPanelVariantCtrl.setVariantListener(this);
        this.add((Component)this.jPanelVariant, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jPanelPrinter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jPanelOrderByGroupBy, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jPanelFilter, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanelVariantCtrl, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setTitle(Nat.x("V\u00fdberov\u00e1 podmienka"));
    }

    public TngReportPanelVariant getPanelVariant() {
        return this.jPanelVariant;
    }

    public TngReportPanelPrinter getPanelPrinter() {
        return this.jPanelPrinter;
    }

    public TngReportPanelOrderByGroupBy getPanelOrderByGroupBy() {
        return this.jPanelOrderByGroupBy;
    }

    public TngReportPanelFilter getPanelFilter() {
        return this.jPanelFilter;
    }

    @Override
    public void variantChanged() {
        if (this.isInitializing) {
            return;
        }
        this.jPanelVariant.readParams(this.reportParams);
        if (this.reportParams.variant != null) {
            this.reportParams.reportFile = TngReportFile.getReportFileByFileTrap(this.jPanelPrinter.getReportFiles(), this.reportParams.variant.reportFileName);
            this.reportParams.copies = this.reportParams.variant.copies;
            this.reportParams.note = this.reportParams.variant.note;
            this.reportParams.orderBy = this.reportParams.variant.orderBy;
            this.reportParams.orderByReversed = this.reportParams.variant.orderByReversed;
            this.reportParams.groupBy = this.reportParams.variant.groupBy;
            this.reportParams.where = this.reportParams.variant.where;
        }
        this.jPanelPrinter.writeParams(this.reportParams);
        this.jPanelOrderByGroupBy.writeParams(this.reportParams);
        this.jPanelFilter.writeParams(this.reportParams);
    }

    @Override
    public boolean variantSave() {
        this.readAllParams();
        if (!this.variantCanSave()) {
            return false;
        }
        int[] replaceVariantIndex = new int[]{-1};
        TngReportVariant newVariant = this.variantCreateNew(replaceVariantIndex);
        if (newVariant == null) {
            return false;
        }
        List<TngReportVariant> allVariants = this.jPanelVariant.getVariants();
        if (replaceVariantIndex[0] == -1) {
            allVariants.add(newVariant);
        } else {
            allVariants.set(replaceVariantIndex[0], newVariant);
        }
        this.variantSaveAll(allVariants);
        this.reportParams.variant = newVariant;
        this.jPanelVariant.populateVariants(this.reportParams);
        this.jPanelVariant.writeParams(this.reportParams);
        return true;
    }

    private boolean variantCanSave() {
        if (this.reportParams.variantOperator == null) {
            TngSwing.msgWarning(Nat.x("Nebol definovan\u00fd sp\u00f4sob ukladania parametrov"));
            return false;
        }
        if (this.reportParams.reportFile == null) {
            TngSwing.msgWarning(Nat.x("Najprv si mus\u00edte zvoli\u0165 tla\u010dov\u00fa zostavu"));
            return false;
        }
        if (this.reportParams.copies <= 0) {
            TngSwing.msgWarning(Nat.x("Po\u010det k\u00f3pi\u00ed mus\u00ed by\u0165 v\u00e4\u010d\u0161\u00ed ako 1"));
            return false;
        }
        return true;
    }

    @Override
    public boolean variantSaveUser() {
        if (!this.variantCanSaveUser()) {
            return false;
        }
        this.reportParams.variantOperator.saveUserDefault(this.reportParams.prefix, this.reportParams.variant.name);
        return true;
    }

    public boolean variantCanSaveUser() {
        if (this.reportParams.variantOperator == null) {
            TngSwing.msgWarning(Nat.x("Nebol definovan\u00fd sp\u00f4sob ukladania parametrov"));
            return false;
        }
        return TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te nastavi\u0165 aktu\u00e1lne ulo\u017een\u00e9 parametre ako predvolen\u00e9?"));
    }

    private TngReportVariant variantCreateNew(int[] index) {
        TngReportPanelVariantForm form = new TngReportPanelVariantForm();
        form.setVariant(this.reportParams.variant);
        if (!TngDlg.runModal(form)) {
            return null;
        }
        TngReportVariant newVariant = form.getVariant();
        if (!this.variantNewExists(newVariant, index)) {
            return null;
        }
        this.variantFill(newVariant);
        return newVariant;
    }

    private boolean variantNewExists(TngReportVariant variant, int[] index) {
        List<TngReportVariant> allVariants = this.jPanelVariant.getVariants();
        for (int i2 = 0; i2 < allVariants.size(); ++i2) {
            TngReportVariant v = allVariants.get(i2);
            if (!v.name.equals(variant.name)) continue;
            if (!TngSwing.msgAsk(Nat.x("Ulo\u017een\u00e9 parametre s t\u00fdmto n\u00e1zvom existuj\u00fa, \u017eel\u00e1te si ich nahradi\u0165?"))) {
                return false;
            }
            index[0] = i2;
            break;
        }
        return true;
    }

    private void variantFill(TngReportVariant variant) {
        variant.copies = this.reportParams.copies;
        variant.reportFileName = this.reportParams.reportFile.getFileTrap();
        variant.note = this.reportParams.note;
        variant.orderBy = this.reportParams.orderBy;
        variant.orderByReversed = this.reportParams.orderByReversed;
        variant.groupBy = this.reportParams.groupBy;
        try {
            variant.where = (TngParams)this.reportParams.where.clone();
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void variantWizard() {
        this.jPanelVariant.readParams(this.reportParams);
        TngReportPanelVariantWizard wizard = new TngReportPanelVariantWizard();
        wizard.setData(this.jPanelVariant.getVariants(), this.reportParams);
        TngDlg.runModal(wizard);
        wizard.readVariant();
        this.variantSaveAll(wizard.getVariants());
        this.jPanelVariant.populateVariants(this.reportParams);
        this.jPanelVariant.writeParams(this.reportParams);
    }

    private void variantSaveAll(List<TngReportVariant> toSave) {
        this.reportParams.variantOperator.save(this.reportParams.prefix, toSave);
    }

    @Override
    public void doValidate(TngValidationError errors) {
        this.validateParams(errors);
    }

    public boolean validateParams(TngValidationError errors) {
        this.readAllParams();
        if (this.reportParams.reportFile == null) {
            errors.addError(null, Nat.x("Najprv si mus\u00edte zvoli\u0165 tla\u010dov\u00fa zostavu"));
            return false;
        }
        if (this.reportParams.copies <= 0) {
            errors.addError(null, Nat.x("Po\u010det k\u00f3pi\u00ed mus\u00ed by\u0165 v\u00e4\u010d\u0161\u00ed ako 1"));
            return false;
        }
        if (this.definitionGroupBy != null && this.definitionGroupBy.size() > 0 && TngUtilities.isEmpty(this.reportParams.groupBy)) {
            errors.addError(null, Nat.x("Mus\u00edte zvoli\u0165 aspo\u0148 jeden medzis\u00fa\u010det"));
            return false;
        }
        this.reportParams.createWhereExpression(this.definitionFilterSet);
        this.reportParams.createWhereDescription(this.definitionFilterSet);
        this.reportParams.createOrderByExpression();
        return true;
    }
}

