/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Set;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.library.TngWindowsRegistry;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngFieldArea;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.container.TngScrollPane;
import tangram.swing.panel.TngPanel;

public class TngReportPanelMail
extends TngPanel {
    public static final String TYPE_PDF = "PDF";
    public static final String TYPE_ODT = "ODT";
    public static final String TYPE_DOCX = "DOCX";
    private static final LinkedHashMap<String, String> SUPPORTED_TYPES = new LinkedHashMap();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabel1 = new TngLabel();
    private TngFieldString jReceivers = new TngFieldString();
    private TngLabel jLabel2 = new TngLabel();
    private TngLabel jLabel3 = new TngLabel();
    private TngLabel jLabel4 = new TngLabel();
    private TngLabel jLabel5 = new TngLabel();
    private TngFieldString jSubject = new TngFieldString();
    private TngScrollPane jScrollPane1 = new TngScrollPane();
    private TngFieldArea jMessage = new TngFieldArea();
    private TngComboBox jType = new TngComboBox();
    private String fileName;

    public TngReportPanelMail() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static boolean isTypeSupported(String type) {
        if (type == null || type.length() == 0) {
            return false;
        }
        return SUPPORTED_TYPES.containsKey(type.toUpperCase());
    }

    public static int getTypeIndex(String type) {
        Set<String> keySet = SUPPORTED_TYPES.keySet();
        String[] keys = new String[keySet.size()];
        keys = keySet.toArray(keys);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            if (!keys[i2].equalsIgnoreCase(type)) continue;
            return i2;
        }
        return -1;
    }

    public static String getTypeName(int typeIndex) {
        Set<String> keySet = SUPPORTED_TYPES.keySet();
        String[] keys = new String[keySet.size()];
        keys = keySet.toArray(keys);
        return typeIndex < 0 || typeIndex >= keys.length ? null : keys[typeIndex];
    }

    public void setData(String receivers, String subject, String message, String fileName, String fileType) {
        this.fileName = fileName;
        this.jReceivers.setString(receivers);
        this.jSubject.setString(subject);
        this.jMessage.setString(message);
        int typeIndex = TngReportPanelMail.getTypeIndex(fileType);
        if (typeIndex != -1) {
            this.jType.setSelectedIndex(typeIndex);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(639, 179));
        this.setTitle(Nat.x("Odoslanie tla\u010dovej zostavy e-mailom"));
        this.setLayout(this.gridBagLayout1);
        this.jLabel1.setText(Nat.x("Pr\u00edjemcovia"));
        this.jReceivers.setValueCanNull(false);
        this.jLabel2.setText(Nat.x("Predmet"));
        this.jLabel3.setText(Nat.x("Text spr\u00e1vy"));
        this.jLabel4.setText(Nat.x("Typ pr\u00edlohy"));
        this.jMessage.setRows(6);
        this.jLabel5.setText(Nat.x("(viacer\u00fdch pr\u00edjemcov odde\u013ete bodko\u010diarkou)"));
        this.jLabel5.setHorizontalAlignment(2);
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 10), 0, 0));
        this.add((Component)this.jReceivers, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 10), 0, 0));
        this.add((Component)this.jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 0, 3, 10), 0, 0));
        this.add((Component)this.jLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 10), 0, 0));
        this.add((Component)this.jSubject, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jMessage, null);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jType, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabel5, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.populateTypes();
        this.setOptimalHeight();
    }

    private void populateTypes() {
        Set<String> keySet = SUPPORTED_TYPES.keySet();
        String[] keys = new String[keySet.size()];
        for (String key : keys = keySet.toArray(keys)) {
            this.jType.addItem(key + " - " + SUPPORTED_TYPES.get(key));
        }
    }

    public String[] getReceivers() {
        return TngUtilities.strTokenizeNotNull(this.jReceivers.getText(), ';');
    }

    public String getSubject() {
        return this.jSubject.getText();
    }

    public String getMessage() {
        return this.jMessage.getText();
    }

    public String getFileType() {
        int selType = this.jType.getSelectedIndex();
        String typeName = TngReportPanelMail.getTypeName(selType);
        return typeName == null ? TYPE_PDF : typeName;
    }

    public String getContributor() {
        int selType = this.jType.getSelectedIndex();
        String typeName = TngReportPanelMail.getTypeName(selType);
        if (TYPE_ODT.equals(typeName)) {
            return "net.sf.jasperreports.view.save.JROdtSaveContributor";
        }
        if (TYPE_DOCX.equals(typeName)) {
            return "net.sf.jasperreports.view.save.JRDocxSaveContributor";
        }
        return "net.sf.jasperreports.view.save.JRPdfSaveContributor";
    }

    public File getAttachment() {
        String fName = this.fileName == null ? this.jSubject.getText() : this.fileName;
        fName = fName + "." + this.getFileType();
        return new File(this.getDefaultPath(), fName);
    }

    private String getDefaultPath() {
        String path = null;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            try {
                path = TngWindowsRegistry.getKeySz(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common AppData");
                path = path + File.separator + "Tangram";
            }
            catch (Throwable e2) {
                TngUtilities.exceptionLog(e2);
            }
        }
        if (path == null) {
            path = System.getProperty("user.home");
        }
        return path;
    }

    static {
        SUPPORTED_TYPES.put(TYPE_PDF, Nat.x("prenosn\u00fd form\u00e1t dokumentu"));
        SUPPORTED_TYPES.put(TYPE_ODT, Nat.x("Open Office dokument"));
        SUPPORTED_TYPES.put(TYPE_DOCX, Nat.x("Microsoft Word 2007 dokument"));
    }
}

