/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import tangram.library.Nat;
import tangram.report.variant.TngReportVariant;
import tangram.report.variant.TngReportVariantListener;
import tangram.report.visual.TngReportPanelConfig;
import tangram.report.visual.TngReportParams;
import tangram.swing.TngSwing;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButton;
import tangram.swing.panel.TngPanel;

public class TngReportPanelVariant
extends TngPanel {
    private TngLabel jLabel1 = new TngLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngComboBox jVariants = new TngComboBox();
    private TngButton jButton2 = new TngButton();
    private TngReportVariantListener variantListener;
    private final List<TngReportVariant> variants = new ArrayList<TngReportVariant>();

    public TngReportPanelVariant() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(650, 74));
        this.setTitle(Nat.x("Ulo\u017een\u00e9 varianty"));
        this.setLayout(this.gridBagLayout1);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel1.setText(Nat.x("Ulo\u017een\u00e9 parametre"));
        this.jButton2.setText(Nat.x("Nastavi\u0165 ako predvolen\u00e9..."));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TngReportPanelVariant.this.variantListener != null) {
                    TngReportPanelVariant.this.variantListener.variantSaveUser();
                }
            }
        });
        this.jVariants.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TngReportPanelVariant.this.jVariants.isEnabled() && TngReportPanelVariant.this.variantListener != null) {
                    TngReportPanelVariant.this.variantListener.variantChanged();
                }
            }
        });
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.jVariants, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButton2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
        TngSwing.setOptimalHeight(this);
    }

    public List<TngReportVariant> getVariants() {
        return this.variants;
    }

    public void setVariantListener(TngReportVariantListener variantListener) {
        this.variantListener = variantListener;
    }

    public void init(TngReportParams reportParams) {
        this.populateVariants(reportParams);
    }

    public void populateVariants(TngReportParams reportParams) {
        this.jVariants.setEnabled(false);
        this.jVariants.removeAllItems();
        this.variants.clear();
        if (reportParams.variantOperator != null) {
            reportParams.variantOperator.load(reportParams.prefix, this.variants);
        }
        reportParams.predefinedVariant.name = TngReportPanelConfig.PREDEFINED_VARIANT;
        if (reportParams.predefinedVariant.copies <= 0) {
            reportParams.predefinedVariant.copies = 1;
        }
        this.jVariants.addItem(reportParams.predefinedVariant);
        for (TngReportVariant v : this.variants) {
            this.jVariants.addItem(v);
        }
        this.jVariants.setEnabled(true);
    }

    public void readParams(TngReportParams reportParams) {
        reportParams.variant = (TngReportVariant)this.jVariants.getSelectedItem();
    }

    public void writeParams(TngReportParams reportParams) {
        TngReportVariant selectedVariant = reportParams.predefinedVariant;
        if (reportParams.variant != null) {
            for (TngReportVariant variant : this.variants) {
                if (!variant.equals(reportParams.variant)) continue;
                selectedVariant = reportParams.variant;
            }
        }
        this.jVariants.setSelectedItem(selectedVariant);
    }
}

