/*
 * Decompiled with CFR 0.152.
 */
package tangram.report.visual;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tangram.filter.TngFilterSet;
import tangram.library.Nat;
import tangram.library.TngOrderNamed;
import tangram.library.TngUtilities;
import tangram.report.TngReport;
import tangram.report.TngReportFile;
import tangram.report.visual.TngReportPanelConfig;
import tangram.report.visual.TngReportParams;
import tangram.report.visual.TngReportViewer;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngProgressableWorker;

public abstract class TngReportViewerBase
extends TngReportViewer {
    private final TngReportPanelConfig jConfigurationPanel = new TngReportPanelConfig();
    private final TngReportParams reportParams = new TngReportParams();
    private final List<TngOrderNamed> definitionOrderBy = new ArrayList<TngOrderNamed>();
    private final List<TngOrderNamed> definitionGroupBy = new ArrayList<TngOrderNamed>();
    private final TngFilterSet definitionFilterSet = new TngFilterSet();
    private boolean configOnShow = true;

    public void setConfigOnShow(boolean configOnShow) {
        this.configOnShow = configOnShow;
    }

    public boolean isConfigOnShow() {
        return this.configOnShow;
    }

    public TngReportParams getReportParams() {
        return this.reportParams;
    }

    public boolean init() {
        this.initDefinition();
        this.initConfig();
        if (this.isConfigOnShow()) {
            return this.jasperConfig();
        }
        this.jasperCreate();
        return true;
    }

    private void initDefinition() {
        this.initReportParams(this.reportParams);
        this.initDefinitionOrderBy(this.definitionOrderBy);
        this.initDefinitionGroupBy(this.definitionGroupBy);
        this.initDefinitionFilterSet(this.definitionFilterSet);
    }

    protected void initReportParams(TngReportParams reportParams) {
    }

    protected void initDefinitionOrderBy(List<TngOrderNamed> definitionOrderBy) {
    }

    protected void initDefinitionGroupBy(List<TngOrderNamed> definitionGroupBy) {
    }

    protected void initDefinitionFilterSet(TngFilterSet definitionFilterSet) {
    }

    private void initConfig() {
        this.jConfigurationPanel.init(this.reportParams, this.definitionOrderBy, this.definitionGroupBy, this.definitionFilterSet);
    }

    @Override
    protected boolean jasperConfig() {
        if (!TngDlg.runModal(this.jConfigurationPanel)) {
            return false;
        }
        this.jasperCreate();
        return true;
    }

    private void jasperCreate() {
        if (!this.validateParams()) {
            return;
        }
        try {
            TngProgressableWorker worker = new TngProgressableWorker(Nat.x("Prebieha generovanie tla\u010dovej zostavy, \u010dakajte, pros\u00edm...")){

                @Override
                public void compute() throws Exception {
                    TngReportViewerBase.this.jasperCreateInner(this, TngReportViewerBase.this.getReportParams().reportFile);
                }
            };
            worker.start();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jasperCreateInner(TngProgressableWorker worker, TngReportFile reportFile) {
        try {
            this.report = new TngReport();
            this.report.setWorker(worker);
            worker.setProgressStatus(Nat.x("Na\u010d\u00edtavanie s\u00faboru tla\u010dovej zostavy"));
            this.report.load(reportFile.getFileTrap());
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            this.extendParamsMap(paramsMap);
            worker.setProgressStatus(Nat.x("Na\u010d\u00edtavanie \u00fadajov"));
            this.loadData(worker);
            worker.setProgressStatus(Nat.x("Z\u00e1pis \u00fadajov do tla\u010dovej zostavy"));
            this.fillData(worker, paramsMap);
            this.refreshReport();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
            String msg = e2.getMessage();
            this.setReportError(TngUtilities.isEmpty(msg) ? e2.toString() : msg);
        }
        finally {
            this.clearData();
        }
    }

    protected abstract void loadData(TngProgressableWorker var1) throws Exception;

    protected abstract void fillData(TngProgressableWorker var1, HashMap<String, Object> var2) throws Exception;

    protected abstract void clearData();

    private boolean validateParams() {
        TngValidationError errors = new TngValidationError();
        if (!this.jConfigurationPanel.validateParams(errors)) {
            return TngSwing.msgNovalid(errors.getError(0), errors.getComponent(0));
        }
        return true;
    }

    protected void extendParamsMap(Map<String, Object> paramsMap) {
    }

    @Override
    protected int getJasperPrintCopies() {
        return this.reportParams.copies;
    }

    @Override
    public String getDebugInfo() {
        TngReportFile reportFile = this.getReportParams().reportFile;
        return reportFile == null ? "" : "\n<b>File:</b>\n" + reportFile.getFileTrap() + "\n\n";
    }
}

