/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing;

import java.awt.Container;
import java.awt.Window;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import tangram.swing.TngSwing;

public class TngWaiter {
    private static HashMap<Container, TngWaiter> waiters = new HashMap();
    private Window parent;
    private boolean wasGlassPaneVisible = false;

    public static void start(JComponent comp) {
        Container container = TngWaiter.getTopParent(comp);
        if (container == null || waiters.containsKey(container)) {
            return;
        }
        TngWaiter waiter = new TngWaiter();
        waiter.parent = (Window)container;
        waiter.setWaitCursorOn();
        waiters.put(container, waiter);
    }

    private static Container getTopParent(JComponent comp) {
        Container container = comp.getTopLevelAncestor();
        if (container == null || !(container instanceof JDialog) && !(container instanceof JFrame)) {
            return null;
        }
        return container;
    }

    private void setWaitCursorOn() {
        if (this.parent instanceof JDialog) {
            this.wasGlassPaneVisible = ((JDialog)this.parent).getGlassPane().isVisible();
            ((JDialog)this.parent).getGlassPane().setVisible(true);
            TngSwing.waitCursorOn(((JDialog)this.parent).getGlassPane());
        } else if (this.parent instanceof JFrame) {
            this.wasGlassPaneVisible = ((JFrame)this.parent).getGlassPane().isVisible();
            ((JFrame)this.parent).getGlassPane().setVisible(true);
            TngSwing.waitCursorOn(((JFrame)this.parent).getGlassPane());
        }
    }

    private void setWaitCursorOff() {
        if (this.parent instanceof JDialog) {
            if (!this.wasGlassPaneVisible) {
                ((JDialog)this.parent).getGlassPane().setVisible(false);
            }
            TngSwing.waitCursorOff(((JDialog)this.parent).getGlassPane());
        } else if (this.parent instanceof JFrame) {
            if (!this.wasGlassPaneVisible) {
                ((JFrame)this.parent).getGlassPane().setVisible(false);
            }
            TngSwing.waitCursorOff(((JFrame)this.parent).getGlassPane());
        }
    }

    public static void stop(JComponent comp) {
        Container container = TngWaiter.getTopParent(comp);
        if (container == null || !waiters.containsKey(container)) {
            return;
        }
        TngWaiter waiter = waiters.get(container);
        waiter.setWaitCursorOff();
        waiters.remove(container);
        waiter = null;
    }
}

