/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.component.TngList;
import tangram.swing.component.TngListRendererCell;
import tangram.swing.container.TngPopupMenu;
import tangram.swing.container.TngScrollPane;

public class TngComboList
extends TngPopupMenu {
    private TngScrollPane scroll = new TngScrollPane();
    private TngList list = new TngList();
    private DefaultListModel listModel = new DefaultListModel();
    private String listValueSelected;

    public TngComboList() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(465, 348));
        this.scroll.setViewportView(this.list);
        this.list.setModel(this.listModel);
        this.list.setCellRenderer(new TngComboListRendererCell());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    TngComboList.this.listValueSelected();
                }
            }
        });
        this.list.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngComboList.this.listValueSelected();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.add(this.scroll);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                TngComboList source = (TngComboList)e2.getSource();
                Component invoker = source.getInvoker();
                if (invoker != null) {
                    source.pack();
                    int width = Math.max(invoker.getSize().width, source.getPreferredSize().width);
                    int height = source.getPreferredSize().height;
                    source.setPreferredSize(new Dimension(width, height));
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
                TngComboList.this.listValueSelected = null;
            }
        });
    }

    private void listValueSelected() {
    }

    public String getListValueSelected() {
        return this.listValueSelected;
    }

    public void setListValues(Map<String, String> listValues) {
        this.listModel.clear();
        for (Map.Entry<String, String> entry : listValues.entrySet()) {
            this.listModel.addElement(new TngComboListValue(entry.getKey(), entry.getValue()));
        }
    }

    public void selectActualValue(String value) {
        TngComboListValue listValue = new TngComboListValue();
        String[] vals = TngUtilities.strTokenizeNotNull(value, '-');
        listValue.key = vals.length > 0 ? vals[0] : "";
        listValue.value = vals.length > 1 ? vals[1] : "";
        for (int i2 = 0; i2 < this.listModel.getSize(); ++i2) {
            Object o2 = this.listModel.getElementAt(i2);
            if (!(o2 instanceof TngComboListValue)) continue;
            TngComboListValue os = (TngComboListValue)o2;
            if (!listValue.key.equals(os.key) || !listValue.value.equals(os.value)) continue;
            this.list.setSelectedIndex(i2);
            return;
        }
    }

    private static class TngComboListRendererCell
    extends TngListRendererCell {
        private TngComboListValue listValue;
        private static final Color cPcDefault = new Color(0, 0, 0, 110);
        private static final Color cPcDefault2 = new Color(0, 0, 0, 40);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof TngComboListValue) {
                this.listValue = (TngComboListValue)value;
                if (!TngUtilities.isEmpty(this.listValue.key) && !TngUtilities.isEmpty(this.listValue.value)) {
                    this.setText(Nat.nox("     ") + this.listValue.value);
                } else {
                    this.setText(Nat.nox(" "));
                }
            }
            return this;
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            Graphics2D g22 = (Graphics2D)g2;
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!TngUtilities.isEmpty(this.listValue.key)) {
                g22.setFont(this.getFont());
                g22.setColor(cPcDefault);
                g22.drawString(this.listValue.key, 3, this.getHeight() / 2 + 5);
                g22.setColor(cPcDefault2);
                g22.drawLine(14, 2, 14, this.getHeight() - 2);
            }
        }
    }

    private static class TngComboListValue {
        protected String key;
        protected String value;

        public TngComboListValue() {
        }

        public TngComboListValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

