/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TngFileChooser
extends JFileChooser {
    public void resetFileFilter() {
        this.resetChoosableFileFilters();
    }

    public void addFileFilterExtension(String description, String ... extensions) {
        FileNameExtensionFilter filter = new FileNameExtensionFilter(description, extensions);
        this.addChoosableFileFilter(filter);
    }

    public boolean isFileExtensionAllowed(File file) {
        int i2;
        FileFilter[] fileFilters = this.getChoosableFileFilters();
        if (fileFilters.length == 0 || fileFilters.length == 1 && this.isAcceptAllFileFilterUsed()) {
            return true;
        }
        int n2 = i2 = this.isAcceptAllFileFilterUsed() ? 1 : 0;
        while (i2 < fileFilters.length) {
            FileFilter fileFilter = fileFilters[i2];
            if (fileFilter.accept(file)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public String getFileFilterToString() {
        int i2;
        FileFilter[] fileFilters = this.getChoosableFileFilters();
        if (fileFilters.length == 0 || fileFilters.length == 1 && this.isAcceptAllFileFilterUsed()) {
            return "*.*";
        }
        StringBuilder sb = new StringBuilder();
        int n2 = i2 = this.isAcceptAllFileFilterUsed() ? 1 : 0;
        while (i2 < fileFilters.length) {
            FileFilter fileFilter = fileFilters[i2];
            sb.append(fileFilter.getDescription());
            if (i2 != fileFilters.length - 1) {
                sb.append(", ");
            }
            ++i2;
        }
        return sb.toString();
    }
}

