/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngField;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanelDateChooser;

public class TngFieldDate
extends TngField
implements TngValuable {
    protected Date valueDate;
    protected Date restrictionMin = null;
    protected Date restrictionMax = null;
    private GregorianCalendar fastCal = new GregorianCalendar();

    public TngFieldDate() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setHorizontalAlignment(2);
        this.setColumns(6);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                boolean consumed = true;
                switch (e2.getKeyCode()) {
                    case 38: {
                        TngFieldDate.this.changeDateByField(5, 1);
                        break;
                    }
                    case 40: {
                        TngFieldDate.this.changeDateByField(5, -1);
                        break;
                    }
                    case 34: {
                        if (e2.isControlDown()) {
                            TngFieldDate.this.changeDateByField(1, -1);
                            break;
                        }
                        TngFieldDate.this.changeDateByField(2, -1);
                        break;
                    }
                    case 33: {
                        if (e2.isControlDown()) {
                            TngFieldDate.this.changeDateByField(1, 1);
                            break;
                        }
                        TngFieldDate.this.changeDateByField(2, 1);
                        break;
                    }
                    default: {
                        consumed = false;
                    }
                }
                if (consumed) {
                    e2.consume();
                }
            }
        });
    }

    private void changeDateByField(int field, int amount) {
        Date v = TngUtilities.strToDate(this.getText());
        if (v == null) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(v);
        ((Calendar)cal).add(field, amount);
        this.setDate(cal.getTime());
        this.setCaretPosition(0);
    }

    public Class getValueClass() {
        return Date.class;
    }

    @Override
    public Date getValue() throws Exception {
        return this.getDate();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Date) {
            this.setDate((Date)value);
        } else {
            this.setTextAndCheck(value == null ? null : value.toString());
        }
    }

    public Date getDate() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.valueDate;
    }

    public Date getDateDef(Date def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.valueDate;
    }

    public void setDate(Date value) {
        this.setTextAndCheck(value == null ? null : TngUtilities.dateToStr(value));
    }

    public void setRestrictionMin(Date min) {
        if (this.restrictionMin != min) {
            this.restrictionMin = min;
        }
    }

    public Date getRestrictionMin() {
        return this.restrictionMin;
    }

    public void setRestrictionMax(Date max) {
        if (this.restrictionMax != max) {
            this.restrictionMax = max;
        }
    }

    public Date getRestrictionMax() {
        return this.restrictionMax;
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " <" + TngUtilities.dateToStr(this.restrictionMin) + "," + TngUtilities.dateToStr(this.restrictionMax) + ">";
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        this.valueDate = null;
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (text.length() == 0) {
            return null;
        }
        Date v = TngUtilities.strToDate(text);
        if (v == null) {
            return Nat.x("Neplatn\u00fd d\u00e1tum, spr\u00e1vny form\u00e1t je DD.MM.RRRR");
        }
        if (this.restrictionMin != null && v.before(this.restrictionMin)) {
            return Nat.x("D\u00e1tum je men\u0161\u00ed ako %1", TngUtilities.dateToStr(this.restrictionMin));
        }
        if (this.restrictionMax != null && v.after(this.restrictionMax)) {
            return Nat.x("D\u00e1tum je v\u00e4\u010d\u0161\u00ed ako %1", TngUtilities.dateToStr(this.restrictionMax));
        }
        this.valueDate = v;
        return null;
    }

    @Override
    protected int inputCheck(char c2, StringBuilder text, int position) {
        if (text.length() >= 10) {
            return -1;
        }
        if (c2 == '.') {
            if (TngUtilities.countOccurrences(text.toString(), '.') >= 2) {
                return -1;
            }
            text.insert(position, c2);
            return position + 1;
        }
        if (c2 < '0' || c2 > '9') {
            return -1;
        }
        text.insert(position, c2);
        return position + 1;
    }

    @Override
    @Deprecated
    public synchronized void replaceSelection(String content) {
        super.replaceSelection(content);
        int textLength = this.getText().length();
        if (textLength == 2 || textLength == 3 && content.equals(".")) {
            this.completeMonthAndYear(textLength == 2);
        } else if (textLength == 5 || textLength == 6 && content.equals(".")) {
            this.completeYear(textLength == 5);
        }
    }

    private void completeMonthAndYear(boolean appendDot) {
        String month = TngUtilities.strPadRight(String.valueOf(this.fastCal.get(2) + 1), 2, '0');
        this.setTextWithoutCheck(this.getText() + (appendDot ? "." : "") + month);
        this.completeYear(true);
        this.select(3, this.getText().length());
    }

    private void completeYear(boolean appendDot) {
        String year = TngUtilities.strPadRight(String.valueOf(this.fastCal.get(1)), 4, '0');
        this.setTextWithoutCheck(this.getText() + (appendDot ? "." : "") + year);
        this.select(6, this.getText().length());
    }

    @Override
    protected void reformat() {
        if (this.valueDate != null) {
            this.setTextWithoutCheck(TngUtilities.dateToStr(this.valueDate));
        }
    }

    @Override
    protected void openWizardDef(String text) {
        Date date = TngUtilities.strToDate(text);
        if (date == null) {
            date = new Date();
        }
        TngPanelDateChooser p2 = new TngPanelDateChooser();
        p2.setData(date);
        if (TngDlg.runModal(p2)) {
            this.setDate(p2.getCurrentDate());
            this.selectAll();
            this.fireValueChangedUser();
        }
    }
}

