/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.io.File;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngFieldFile;

public class TngFieldDirectory
extends TngFieldFile {
    protected boolean dirMustExist = true;

    public TngFieldDirectory() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle(Nat.x("Umiestnenie adres\u00e1ra"));
        this.setDefaultDirectory(new File(System.getProperty("user.dir")));
        this.setValueCanNull(false);
    }

    public void setDirMustExist(boolean dirMustExist) {
        this.dirMustExist = dirMustExist;
    }

    public boolean isDirMustExist() {
        return this.dirMustExist;
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " directory";
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        this.valueFile = null;
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (text.length() > 0) {
            String errMsg = null;
            File f2 = new File(text);
            if (this.dirMustExist && !f2.exists()) {
                errMsg = Nat.x("Adres\u00e1r neexistuje");
            } else if (f2.exists() && !f2.isDirectory()) {
                errMsg = Nat.x("Zadan\u00e1 cesta neukazuje na adres\u00e1r, ale na s\u00fabor");
            }
            if (!TngUtilities.isEmpty(errMsg)) {
                this.valueFile = null;
                return errMsg;
            }
        }
        this.valueFile = new File(this.getTextTrimed());
        return null;
    }

    @Override
    protected void openWizardDef(String text) {
        this.selectDir();
    }

    protected void selectDir() {
        this.fileChooserSet();
        if (this.fileChooser.showDialog(this, Nat.x("Zvoli\u0165")) == 0) {
            this.setFile(this.fileChooser.getSelectedFile());
            this.fireValueChangedUser();
        }
    }
}

