/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.awt.FontMetrics;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngField;

public class TngFieldInteger
extends TngField
implements TngValuable {
    protected Integer valueInteger;
    protected boolean valueCanZero = true;
    protected int valueMin = Integer.MIN_VALUE;
    protected int valueMax = Integer.MAX_VALUE;
    protected int valueSize;
    protected int restrictionMin;
    protected int restrictionMax;

    public TngFieldInteger() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setHorizontalAlignment(4);
        this.calcRestricitonMinMax();
    }

    public Class getValueClass() {
        return Integer.class;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getInt();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Integer) {
            this.setInteger((Integer)value);
        } else {
            this.setTextAndCheck(value == null ? null : value.toString());
        }
    }

    public int getInt() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.valueInteger == null ? 0 : this.valueInteger;
    }

    public int getIntDef(int def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.valueInteger == null ? 0 : this.valueInteger;
    }

    public void setInt(int value) {
        this.setTextAndCheck(Integer.toString(value));
    }

    public Integer getInteger() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.valueInteger;
    }

    public Integer getIntegerDef(Integer def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.valueInteger;
    }

    public void setInteger(Integer value) {
        this.setTextAndCheck(value == null ? null : value.toString());
    }

    public int getRestrictionMin() {
        return this.restrictionMin;
    }

    public int getRestrictionMax() {
        return this.restrictionMax;
    }

    public void setValueCanZero(boolean canZero) {
        if (this.valueCanZero != canZero) {
            this.valueCanZero = canZero;
            this.lastCheckedText = null;
        }
    }

    public boolean getValueCanZero() {
        return this.valueCanZero;
    }

    public void setValueMin(int min) {
        if (this.valueMin != min) {
            this.valueMin = min;
            this.calcRestricitonMinMax();
        }
    }

    public int getValueMin() {
        return this.valueMin;
    }

    public void setValueMax(int max) {
        if (this.valueMax != max) {
            this.valueMax = max;
            this.calcRestricitonMinMax();
        }
    }

    public int getValueMax() {
        return this.valueMax;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is bad.");
        }
        if (this.valueSize != size) {
            this.valueSize = size;
            this.calcRestricitonMinMax();
            this.setColumns(size);
        }
    }

    protected void calcRestricitonMinMax() {
        int newMax;
        int sizeMax = TngFieldInteger.calcMaxValueForSize(this.valueSize);
        int sizeMin = -sizeMax;
        int newMin = this.valueMin > sizeMin ? this.valueMin : sizeMin;
        int n2 = newMax = this.valueMax < sizeMax ? this.valueMax : sizeMax;
        if (this.restrictionMin != newMin || this.restrictionMax != newMax) {
            this.restrictionMin = newMin;
            this.restrictionMax = newMax;
            this.lastCheckedText = null;
        }
    }

    public static final int calcMaxValueForSize(int size) {
        if (size <= 0) {
            return Integer.MAX_VALUE;
        }
        int v = Integer.MAX_VALUE;
        if (size > 0 && size < 10) {
            v = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                v = v * 10 + 9;
            }
        }
        return v;
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        if (this.valueSize > 0) {
            h2 = h2 + " int(" + this.valueSize + ")";
        }
        h2 = this.restrictionMin > this.restrictionMax ? h2 + " <EMPTY>" : h2 + " <" + this.restrictionMin + "," + this.restrictionMax + ">";
        if (!this.valueCanZero) {
            h2 = h2 + " except 0";
        }
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        this.valueInteger = null;
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (text.length() == 0) {
            return null;
        }
        try {
            int v = Integer.parseInt(text);
            if (v < this.restrictionMin) {
                return Nat.x("Hodnota je men\u0161ia ako %1", this.restrictionMin);
            }
            if (v > this.restrictionMax) {
                return Nat.x("Hodnota je v\u00e4\u010d\u0161ia ako %1", this.restrictionMax);
            }
            if (!this.valueCanZero && v == 0) {
                return Nat.x("Hodnota nesmie by\u0165 0");
            }
            this.valueInteger = new Integer(v);
        }
        catch (NumberFormatException er) {
            return Nat.x("Hodnota nie je \u010d\u00edslo");
        }
        return null;
    }

    @Override
    protected void openWizardDef(String text) {
        try {
            Runtime.getRuntime().exec("calc");
        }
        catch (Exception e2) {
            this.beep();
        }
    }

    @Override
    protected int inputCheck(char c2, StringBuilder text, int position) {
        if (this.valueSize > 0 && text.length() >= this.valueSize) {
            return -1;
        }
        if (c2 == '-') {
            if (position != 0 || this.restrictionMin >= 0 || text.indexOf("-") >= 0) {
                return -1;
            }
            text.insert(position, c2);
            return position + 1;
        }
        if (c2 < '0' || c2 > '9') {
            return -1;
        }
        if (position == 0 && text.length() > 0 && text.charAt(0) == '-') {
            return -1;
        }
        text.insert(position, c2);
        return position + 1;
    }

    @Override
    protected void reformat() {
        if (this.valueInteger != null) {
            this.setTextWithoutCheck(this.valueInteger.toString());
        }
    }

    @Override
    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('8') + 1;
        }
        return this.columnWidth;
    }
}

