/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngFieldLink;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.model.TngTableModel;
import tangram.swing.valuable.TngValueEvent;

public class TngFieldLinkNonSql
extends TngFieldLink {
    private List<String[]> data;
    private final Map<String, String[]> dataMap = new LinkedHashMap<String, String[]>();

    public TngFieldLinkNonSql() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
    }

    @Override
    protected String keyColumnResolve() {
        TngTableModel tableModel = this.getTableModel();
        if (tableModel == null) {
            return null;
        }
        TngTableColumn[] columns = tableModel.getColumns();
        if (columns == null || columns.length == 0) {
            return null;
        }
        return columns[0].name;
    }

    public void setData(List<String[]> data) {
        this.data = data;
        this.createDataMap();
    }

    private void createDataMap() {
        this.dataMap.clear();
        if (this.data != null) {
            for (String[] d2 : this.data) {
                if (d2 == null || d2.length < 1) continue;
                this.dataMap.put(d2[0], d2);
            }
        }
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " nonsql";
        return h2;
    }

    @Override
    protected String valueCheckLinkValue(String text) {
        if (!this.dataMap.containsKey(text)) {
            return Nat.x("Zadan\u00e1 hodnota sa v \u010d\u00edseln\u00edku nenach\u00e1dza");
        }
        return null;
    }

    @Override
    protected void valueFieldChanged(TngValueEvent e2) {
        TngFieldString valueField = this.getValueField();
        if (valueField == null) {
            return;
        }
        String codeFieldText = this.getText();
        String valueFieldText = null;
        if (!TngUtilities.isEmpty(codeFieldText)) {
            String[] d2;
            valueFieldText = this.dataMap.containsKey(codeFieldText) ? ((d2 = this.dataMap.get(codeFieldText)).length > 1 ? d2[1] : "") : "???";
        }
        valueField.setString(valueFieldText);
    }
}

