/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.mdi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import tangram.swing.container.TngScrollPane;

public class TngOptionPanel
extends JPanel {
    private int maxButtonWidth = 0;
    private TngButtonGroup buttonGroup;
    private JPanel optionPanel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private TngScrollPane optionScroll = new TngScrollPane();
    private JScrollBar horizontalBar = new JScrollBar(0);
    private static boolean draging = false;

    public TngOptionPanel() {
        this.buttonGroup = new TngButtonGroup();
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void addOption(String title, Object o2) {
        new TngToggleButton(title, o2);
    }

    public void removeOption(Object o2) {
        this.buttonGroup.removeOne(o2);
    }

    public void removeOptions() {
        this.buttonGroup.removeAll();
    }

    public void doSelect(String title, Object o2) {
        System.out.println("SELECT [title: " + title + ", object: " + o2 + "]");
    }

    public void doSwap(String title, Object o2, String title2, Object o22) {
        System.out.println("SWAP [title: " + title + ", object: " + o2 + "] [title: " + title2 + ", object: " + o22 + "]");
    }

    public void setSelectedOption(Object o2) {
        this.buttonGroup.setSelectedOption(o2);
    }

    public void setMaxButtonWidth(int width) {
        this.maxButtonWidth = width;
    }

    private void actionSelect(AbstractButton tgb) {
        this.doSelect(((TngToggleButton)tgb).title, ((TngToggleButton)tgb).o);
    }

    private void actionSwap(AbstractButton tgb, AbstractButton tgb2) {
        this.doSwap(((TngToggleButton)tgb).title, ((TngToggleButton)tgb).o, ((TngToggleButton)tgb2).title, ((TngToggleButton)tgb2).o);
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(815, 44));
        this.setLayout(this.borderLayout1);
        this.setPreferredSize(new Dimension(264, 44));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.horizontalBar.setPreferredSize(new Dimension(55, 10));
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.optionScroll.setHorizontalScrollBarPolicy(30);
        this.optionScroll.setVerticalScrollBarPolicy(21);
        this.optionScroll.setHorizontalScrollBar(this.horizontalBar);
        this.optionScroll.setViewportView(this.optionPanel);
        this.optionPanel.setSize(new Dimension(55, 34));
        this.horizontalBar.setUnitIncrement(30);
        this.horizontalBar.setBlockIncrement(30);
        this.optionPanel.setLayout(this.flowLayout1);
        this.add((Component)this.optionScroll, "Center");
    }

    private class TngButtonGroup
    extends ButtonGroup {
        Color blue = new Color(21, 141, 225);

        @Override
        public void add(AbstractButton b2) {
            if (b2 == null) {
                return;
            }
            super.add(b2);
            TngOptionPanel.this.optionPanel.add(b2);
            TngOptionPanel.this.optionPanel.revalidate();
            TngOptionPanel.this.optionPanel.repaint();
        }

        public void add(int index, AbstractButton b2) {
            if (b2 == null) {
                return;
            }
            this.buttons.add(index, b2);
            b2.getModel().setGroup(this);
            TngOptionPanel.this.optionPanel.add((Component)b2, index);
            TngOptionPanel.this.optionPanel.revalidate();
            TngOptionPanel.this.optionPanel.repaint();
        }

        private void removeOne(Object o2) {
            for (AbstractButton but : this.buttons) {
                if (((TngToggleButton)but).o != o2) continue;
                TngOptionPanel.this.buttonGroup.remove(but);
                TngOptionPanel.this.optionPanel.remove(but);
                TngOptionPanel.this.optionPanel.revalidate();
                TngOptionPanel.this.optionPanel.repaint();
                return;
            }
        }

        private void removeAll() {
            this.buttons.clear();
            TngOptionPanel.this.optionPanel.removeAll();
            TngOptionPanel.this.optionPanel.revalidate();
            TngOptionPanel.this.optionPanel.repaint();
        }

        private void change(AbstractButton tgb, AbstractButton tgb2) {
            Vector v = this.buttons;
            int tgbIndex = v.indexOf(tgb);
            int tgb2Index = v.indexOf(tgb2);
            super.remove(tgb);
            TngOptionPanel.this.optionPanel.remove(tgb);
            super.remove(tgb2);
            TngOptionPanel.this.optionPanel.remove(tgb2);
            if (tgbIndex < tgb2Index) {
                this.add(tgbIndex, tgb2);
                this.add(tgb2Index, tgb);
            } else {
                this.add(tgb2Index, tgb);
                this.add(tgbIndex, tgb2);
            }
            TngOptionPanel.this.optionPanel.revalidate();
            TngOptionPanel.this.optionPanel.repaint();
            TngOptionPanel.this.actionSwap(tgb, tgb2);
        }

        public void select(AbstractButton m2) {
            for (AbstractButton but : this.buttons) {
                this.setSelected(but.getModel(), false);
                but.setForeground(Color.BLACK);
            }
            this.setSelected(m2.getModel(), true);
            m2.setForeground(this.blue);
        }

        private void setSelectedOption(Object o2) {
            for (AbstractButton but : this.buttons) {
                if (((TngToggleButton)but).o != o2) continue;
                TngOptionPanel.this.buttonGroup.select(but);
            }
        }
    }

    private class TngToggleButton
    extends JButton {
        private String title;
        private Object o;

        public TngToggleButton(String title, Object o2) {
            super(title);
            this.title = title;
            this.o = o2;
            this.setContentAreaFilled(true);
            this.setFocusable(false);
            this.setBorderPainted(true);
            this.setToolTipText(title);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    TngOptionPanel.this.actionSelect(TngToggleButton.this);
                }

                @Override
                public void mouseReleased(MouseEvent e2) {
                    TngToggleButton tgb2;
                    draging = false;
                    TngToggleButton.this.setCursor(new Cursor(0));
                    Point p2 = TngOptionPanel.this.optionPanel.getMousePosition();
                    if (p2 == null) {
                        return;
                    }
                    Component comp = TngOptionPanel.this.optionPanel.getComponentAt(p2);
                    if (comp == null) {
                        return;
                    }
                    if (comp instanceof TngToggleButton && (tgb2 = (TngToggleButton)comp) != TngToggleButton.this) {
                        TngOptionPanel.this.buttonGroup.change(TngToggleButton.this, tgb2);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e2) {
                    if (!draging) {
                        TngToggleButton.this.setCursor(new Cursor(10));
                        draging = true;
                    }
                }
            });
            if (TngOptionPanel.this.maxButtonWidth > 0) {
                this.setPreferredSize(new Dimension(TngOptionPanel.this.maxButtonWidth, 25));
            }
            TngOptionPanel.this.buttonGroup.add(this);
        }
    }
}

