/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import tangram.TngLibInfo;
import tangram.TngLibParams;
import tangram.TngLibResources;
import tangram.interfaces.TngCheckable;
import tangram.library.Nat;
import tangram.library.TngMnemonicController;
import tangram.library.TngUtilities;
import tangram.library.TngValueController;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.component.button.TngButton;
import tangram.swing.panel.TngDlg;

public class TngPanel
extends JPanel {
    private String title;
    private boolean autoMnemonic;

    public TngPanel createClone() {
        return null;
    }

    public TngPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAutoMnemonic() {
        return this.autoMnemonic;
    }

    public void setAutoMnemonic(boolean autoMnemonic) {
        this.autoMnemonic = autoMnemonic;
    }

    public void doParamsLoad(TngLibParams libParams) {
    }

    public boolean doBeforeShow() {
        return true;
    }

    public void doAfterShow() {
    }

    public boolean doInitSaveTopPanel() {
        return true;
    }

    public boolean doSave() throws Exception {
        return true;
    }

    public boolean doCustom() throws Exception {
        return true;
    }

    public void doParamsSave(TngLibParams libParams) throws Exception {
    }

    public boolean doCancel() throws Exception {
        return true;
    }

    public void doValidate(TngValidationError errors) {
    }

    public String getDebugInfo() {
        return null;
    }

    public static void validateAll(Container container, TngValidationError errors) {
        if (container == null) {
            return;
        }
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            Component c2 = component[i2];
            if (c2 instanceof Container) {
                TngPanel.validateAll((Container)c2, errors);
                continue;
            }
            TngPanel.validateComponent(c2, errors);
        }
        TngPanel.validateComponent(container, errors);
    }

    private static void validateComponent(Component component, TngValidationError errors) {
        if (component instanceof TngCheckable) {
            TngCheckable val = (TngCheckable)((Object)component);
            String error = val.check();
            if (error != null) {
                errors.addError(component, error);
            }
        } else if (component instanceof TngPanel) {
            TngPanel pan = (TngPanel)component;
            pan.doValidate(errors);
        }
    }

    public static boolean saveAll(Container container) throws Exception {
        if (container == null) {
            return true;
        }
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            Component c2 = component[i2];
            if (!(c2 instanceof Container) || TngPanel.saveAll((Container)c2)) continue;
            return false;
        }
        if (container instanceof TngPanel) {
            TngPanel panel = (TngPanel)container;
            if (panel.isDlgCustomAction()) {
                if (!panel.doCustom()) {
                    return false;
                }
            } else {
                if (!panel.doSave()) {
                    return false;
                }
                panel.doParamsSave(panel.getSubparams());
            }
        }
        return true;
    }

    public static boolean cancelAll(Container container) throws Exception {
        if (container == null) {
            return true;
        }
        Component[] components = container.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component c2 = components[i2];
            if (!(c2 instanceof Container) || TngPanel.cancelAll((Container)c2)) continue;
            return false;
        }
        return !(container instanceof TngPanel) || ((TngPanel)container).doCancel();
    }

    public static boolean beforeShowAll(Container container) {
        Component[] components = container.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component c2 = components[i2];
            if (!(c2 instanceof Container) || TngPanel.beforeShowAll((Container)c2)) continue;
            return false;
        }
        if (container instanceof TngPanel) {
            TngPanel panel = (TngPanel)container;
            panel.doParamsLoad(panel.getSubparams());
            panel.dlgCustomSetText(panel.getCustomText());
            if (!panel.doBeforeShow()) {
                return false;
            }
            TngValueController.valueLabelForContainer(container);
            if (panel.isAutoMnemonic()) {
                TngMnemonicController.mnemonicContainer(container);
            }
        }
        return true;
    }

    public static void afterShowAll(Container container) {
        Component[] components = container.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component c2 = components[i2];
            if (!(c2 instanceof Container)) continue;
            TngPanel.afterShowAll((Container)c2);
        }
        if (container instanceof TngPanel) {
            ((TngPanel)container).doAfterShow();
        }
    }

    public static void debugInfoAll(Container container, StringBuilder infoBuilder) {
        if (container == null) {
            return;
        }
        TngPanel.debugInfoComponent(container, infoBuilder);
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            Component c2 = component[i2];
            if (c2 instanceof Container) {
                TngPanel.debugInfoAll((Container)c2, infoBuilder);
                continue;
            }
            TngPanel.debugInfoComponent(c2, infoBuilder);
        }
    }

    private static void debugInfoComponent(Component component, StringBuilder infoBuilder) {
        if (component instanceof TngPanel) {
            if (infoBuilder.length() != 0) {
                infoBuilder.append("<hr>");
            }
            TngPanel pan = (TngPanel)component;
            String packageName = TngUtilities.getPackageName(pan);
            String className = TngUtilities.getClassName(pan);
            infoBuilder.append("<b>" + Nat.x("Bal\u00edk") + ":</b> " + (packageName == null ? "---" : packageName));
            infoBuilder.append("\n<b>" + Nat.x("Trieda") + ":</b> " + (className == null ? "---" : className));
            String info = pan.getDebugInfo();
            if (info != null && info.length() != 0) {
                infoBuilder.append("\n<b>" + Nat.x("Info") + ":</b>\n" + info);
            }
        }
    }

    public static TngPanel joinComponentsGrid(TngPanel[] panels) {
        if (panels == null) {
            return null;
        }
        TngPanel panel = new TngPanel();
        for (int i2 = 0; i2 < panels.length; ++i2) {
            TngPanel p2 = panels[i2];
            if (p2 == null) continue;
            p2.setBorder(BorderFactory.createTitledBorder(p2.getTitle()));
            panel.add(p2);
        }
        return panel;
    }

    public static void enableContent(Container container, boolean enabled) {
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            Component c2 = component[i2];
            if (c2 instanceof Container) {
                TngPanel.enableContent((Container)c2, enabled);
                continue;
            }
            c2.setEnabled(enabled);
        }
        container.setEnabled(enabled);
    }

    public void setOptimalHeight() {
        TngSwing.setOptimalHeight(this);
    }

    public void setOptimalSize() {
        TngSwing.setOptimalSize(this);
    }

    private void jbInit() throws Exception {
        TngSwing.setVariantSize(this);
        this.setLayout(null);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!TngSwing.designMode) {
            this.dispose();
        }
    }

    public void dispose() {
    }

    public boolean isPanelDlgParent() {
        return this.getTopLevelAncestor() instanceof TngDlg;
    }

    public TngDlg getPanelDlgParent() {
        if (!this.isPanelDlgParent()) {
            return null;
        }
        return (TngDlg)this.getTopLevelAncestor();
    }

    private boolean isDlgCustomAction() {
        int saveAction = 1;
        TngDlg dlg = this.getPanelDlgParent();
        if (dlg != null) {
            saveAction = dlg.getSaveAction();
        }
        return saveAction == 2;
    }

    public boolean dlgOkAction() {
        TngDlg dlg = this.getPanelDlgParent();
        if (dlg == null) {
            return false;
        }
        dlg.buttonOkAction();
        return true;
    }

    public boolean dlgCancelAction() {
        TngDlg dlg = this.getPanelDlgParent();
        if (dlg == null) {
            return false;
        }
        dlg.buttonCancelAction();
        return true;
    }

    public boolean dlgCustomAction() {
        TngDlg dlg = this.getPanelDlgParent();
        if (dlg == null) {
            return false;
        }
        dlg.buttonCustomAction();
        return true;
    }

    public boolean dlgTitleSet(String title) {
        TngDlg dlg = this.getPanelDlgParent();
        if (dlg == null) {
            return false;
        }
        dlg.setTitle(title);
        return true;
    }

    public boolean dlgCustomSetText(String text) {
        TngButton customButton = this.dlgGetCustomButton();
        if (customButton == null) {
            return false;
        }
        if (TngUtilities.isEmpty(text)) {
            return false;
        }
        customButton.setText(text);
        customButton.setToolTipText(text);
        return true;
    }

    public TngButton dlgGetCustomButton() {
        TngDlg dlg = this.getPanelDlgParent();
        if (dlg == null) {
            return null;
        }
        return dlg.getCustomButton();
    }

    protected String getCustomText() {
        return null;
    }

    private TngLibParams getSubparams() {
        return TngLibResources.libParams.getSubparams(this.getSubparamsName());
    }

    protected String getSubparamsName() {
        return TngPanel.getNameForClass(this.getClass());
    }

    protected static String getNameForClass(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    protected String getSubparamsNameLib() {
        return TngPanel.getNameForClassLib(this.getClass());
    }

    protected static String getNameForClassLib(Class<?> clazz) {
        return TngUtilities.strExt(TngLibInfo.getName(), "/", clazz.getSimpleName());
    }
}

