/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import tangram.filter.TngFilterSet;
import tangram.library.Nat;
import tangram.library.TngScroll;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButton;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.container.TngScrollPane;
import tangram.swing.icon.TngIcon;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngPanelFilter;
import tangram.swing.panel.TngPanelOrder;
import tangram.swing.valuable.TngValueAdapter;
import tangram.swing.valuable.TngValueWizardEvent;

public class TngPanelBrowserParams
extends TngPanel {
    private TngPanelOrder order;
    private TngPanelFilter filter;
    private TngScrollPane filterScrollPane1 = new TngScrollPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel orderPanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private TngLabel orderLabel = new TngLabel();
    private TngFieldString orderField = new TngFieldString();

    public TngPanelBrowserParams(TngPanelOrder order, TngPanelFilter filter) {
        this.order = order;
        this.filter = filter;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(400, 400));
        this.setMinimumSize(new Dimension(400, 0));
        this.setLayout(this.gridBagLayout1);
        this.setTitle(Nat.x("V\u00fdberov\u00e1 podmienka"));
        this.filterScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder(6, 3, 6, 1));
        this.filterScrollPane1.setVerticalScrollBarPolicy(22);
        this.orderPanel.setLayout(this.gridBagLayout2);
        this.orderPanel.setPreferredSize(new Dimension(0, 30));
        this.orderLabel.setText(Nat.x("Usporiadanie"));
        this.orderField.setValueWizard(true);
        this.orderField.addValueListener(new TngValueAdapter(){

            @Override
            public void valueWizard(TngValueWizardEvent e2) {
                e2.consume();
                TngPanelBrowserParams.this.orderButton_actionPerformed();
            }
        });
        this.orderPanel.add((Component)this.orderLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.orderPanel.add((Component)this.orderField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.orderPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.filterScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.filter != null) {
            this.filterScrollPane1.getViewport().add((Component)this.filter, null);
        }
        this.orderField.setString(this.order.getOrderDescription());
        TngScroll.scrollRegister(this.filterScrollPane1);
        TngSwing.setOptimalSize(this);
    }

    @Override
    public String getCustomText() {
        return Nat.x("Vymaza\u0165 podmienku");
    }

    @Override
    public boolean doBeforeShow() {
        TngButton button = this.dlgGetCustomButton();
        if (button == null) {
            return true;
        }
        button.setText(Nat.x("Vymaza\u0165 podmienku"));
        button.setToolTipText(Nat.x("Vymaza\u0165 v\u00fdberov\u00fa podmienky <F8>"));
        button.setIcon(TngIcon.getIcon("toolbar/clear.png"));
        return true;
    }

    private void orderButton_actionPerformed() {
        if (!TngDlg.runModal(this.order)) {
            return;
        }
        this.orderField.setString(this.order.getOrderDescription());
    }

    @Override
    public boolean doCustom() {
        if (this.filter != null) {
            TngFilterSet filterSet = this.filter.getFilterSet();
            filterSet.reset();
            this.filter.refreshVizualizers();
        }
        return false;
    }
}

