/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import tangram.library.Nat;
import tangram.library.TngSmtp;
import tangram.library.TngSmtpSecurity;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngFieldInteger;
import tangram.swing.component.field.TngFieldPassword;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngPanelConfigSmtpRecipient;

public class TngPanelConfigSmtp
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabel12 = new TngLabel();
    private TngLabel jLabel16 = new TngLabel();
    private TngLabel jLabel17 = new TngLabel();
    private TngLabel jLabel18 = new TngLabel();
    private TngLabel jLabel19 = new TngLabel();
    private TngLabel jLabel20 = new TngLabel();
    private TngLabel jLabel1 = new TngLabel();
    private TngLabel jLabel2 = new TngLabel();
    private TngFieldString smtpHost = new TngFieldString();
    private TngFieldString smtpSender = new TngFieldString();
    private TngFieldString smtpMessageId = new TngFieldString();
    private TngComboBox smtpAuth = new TngComboBox();
    private TngFieldString smtpAuthUser = new TngFieldString();
    private TngFieldPassword smtpAuthPswd = new TngFieldPassword();
    private TngFieldInteger smtpPort = new TngFieldInteger();
    private TngComboBox smtpSecurity = new TngComboBox();
    private TngSmtp smtp = new TngSmtp();

    public TngPanelConfigSmtp() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setData(TngSmtp smtp) {
        this.smtp = smtp;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(700, 92));
        this.setLayout(this.gridBagLayout1);
        this.setTitle(Nat.x("Konfigur\u00e1cia SMTP"));
        this.jLabel12.setText(Nat.x("Host"));
        this.jLabel16.setText(Nat.x("Odosielate\u013e"));
        this.jLabel17.setText(Nat.x("ID spr\u00e1vy"));
        this.jLabel18.setText(Nat.x("Autentifik\u00e1cia"));
        this.jLabel19.setText(Nat.x("Prihl. meno"));
        this.jLabel20.setText(Nat.x("Prihl. heslo"));
        this.smtpAuth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                TngPanelConfigSmtp.this.smtpAuth_itemStateChanged(e2);
            }
        });
        this.smtpAuth.setModel(new DefaultComboBoxModel<String>(new String[]{Nat.x("Nie"), Nat.x("\u00c1no")}));
        this.jLabel1.setText(Nat.x("Port"));
        this.jLabel2.setText("Zabezpe\u010denie");
        this.smtpSecurity.setModel(new DefaultComboBoxModel<TngSmtpSecurity>(TngSmtpSecurity.values()));
        this.add((Component)this.jLabel12, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jLabel16, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jLabel17, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jLabel18, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 30, 3, 3), 0, 0));
        this.add((Component)this.jLabel19, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 30, 3, 3), 0, 0));
        this.add((Component)this.jLabel20, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 30, 3, 3), 0, 0));
        this.add((Component)this.smtpHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.smtpSender, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.smtpMessageId, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.smtpAuth, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.smtpAuthUser, new GridBagConstraints(3, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.smtpAuthPswd, new GridBagConstraints(3, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.smtpPort, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 3, 3), 0, 0));
        this.add((Component)this.smtpSecurity, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.setOptimalHeight();
    }

    private void smtpAuth_itemStateChanged(ItemEvent e2) {
        if (e2.getStateChange() != 1) {
            return;
        }
        this.reenable();
    }

    private void reenable() {
        boolean enabled = this.smtpAuth.getSelectedIndex() > 0;
        this.smtpAuthUser.setEnabled(enabled);
        this.smtpAuthPswd.setEnabled(enabled);
    }

    @Override
    public String getCustomText() {
        return Nat.x("Odosla\u0165 testovac\u00ed e-mail");
    }

    @Override
    public boolean doBeforeShow() {
        this.smtpAuth.setSelectedIndex(this.smtp.isAuth() ? 1 : 0);
        this.smtpSecurity.setSelectedItem((Object)this.smtp.getSecurity(), TngSmtpSecurity.NONE.ordinal());
        this.smtpAuthPswd.setPsswd(this.smtp.getAuthPassword());
        this.smtpAuthUser.setString(this.smtp.getAuthUser());
        this.smtpHost.setString(this.smtp.getSmtpHostName());
        this.smtpMessageId.setString(this.smtp.getMessageID());
        this.smtpSender.setString(this.smtp.getSender());
        this.smtpPort.setInteger(this.smtp.getSmtpPort());
        this.reenable();
        return true;
    }

    @Override
    public boolean doSave() throws Exception {
        this.smtp.setAuth(this.smtpAuth.getSelectedIndex() == 1);
        this.smtp.setSecurity((TngSmtpSecurity)((Object)this.smtpSecurity.getSelectedItem()));
        this.smtp.setAuthPassword(this.smtpAuthPswd.getPsswd());
        this.smtp.setAuthUser(this.smtpAuthUser.getString());
        this.smtp.setSmtpHostName(this.smtpHost.getString());
        this.smtp.setMessageID(this.smtpMessageId.getString());
        this.smtp.setSender(this.smtpSender.getString());
        this.smtp.setSmtpPort(this.smtpPort.getInt());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doCustom() {
        TngPanelConfigSmtpRecipient panel = TngPanelConfigSmtpRecipient.runModal();
        if (panel == null) {
            return false;
        }
        TngSwing.waitCursorOn(this);
        try {
            String[] receps;
            TngSmtp mail = new TngSmtp();
            mail.setSmtpHostName(this.smtpHost.getString());
            mail.setSmtpPort(this.smtpPort.getInt());
            mail.setSender(this.smtpSender.getString());
            for (String r2 : receps = TngUtilities.strTokenizeNotNull(panel.getRecipients(), ',')) {
                mail.addRecepient(r2);
            }
            mail.setAuth(this.smtpAuth.getSelectedIndex() == 1);
            mail.setSecurity((TngSmtpSecurity)((Object)this.smtpSecurity.getSelectedItem()));
            mail.setAuthUser(this.smtpAuthUser.getString());
            mail.setAuthPassword(this.smtpAuthPswd.getPsswd());
            mail.setMessageID(this.smtpMessageId.getString());
            mail.setMessage(TngUtilities.dateTimeToStr(System.currentTimeMillis()) + ": testovacia spr\u00e1va odoslan\u00e1 z aplik\u00e1cie spolo\u010dnosti Tangram SW, s.r.o.");
            mail.setSubject("Testovac\u00ed e-mail");
            mail.post();
            TngSwing.msgOK(Nat.x("Odosielanie testovacieho e-mailu prebehlo \u00faspe\u0161ne"));
        }
        catch (Throwable e1) {
            TngSwing.msgError(Nat.x("Chyba pri odosielan\u00ed testovacieho e-mailu:") + "\n" + e1);
        }
        finally {
            TngSwing.waitCursorOff(this);
        }
        return false;
    }

    public static TngPanelConfigSmtp runModal(TngSmtp smtp) {
        TngPanelConfigSmtp panel = new TngPanelConfigSmtp();
        panel.setData(smtp);
        return TngDlg.runModal(panel, 7) ? panel : null;
    }
}

