/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButtonToolbar;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.icon.TngIcon;
import tangram.swing.panel.TngPanel;

public class TngPanelDateChooser
extends TngPanel {
    private static final String[] MONTHS = TngUtilities.months;
    private static final String[] DAYS_OF_WEEK = TngUtilities.daysOfWeek;
    private static final int DAY_LABELS_COUNT = DAYS_OF_WEEK.length;
    private Calendar actualCal = new GregorianCalendar();
    private JPanel dayGrid = new JPanel();
    private JPanel topPane = new JPanel();
    private TngButtonToolbar bPreviousMonth = new TngButtonToolbar();
    private TngButtonToolbar bNextMonth = new TngButtonToolbar();
    private TngButtonToolbar bPreviousYear = new TngButtonToolbar();
    private TngButtonToolbar bNextYear = new TngButtonToolbar();
    private TngLabel dateLabel = new TngLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridLayout gridLayout1 = new GridLayout(7, DAY_LABELS_COUNT, 2, 2);
    private Font boldTextfield;
    private TngLabel last;
    private LineBorder actualBorder = new LineBorder(Color.GRAY, 1, false);

    public TngPanelDateChooser() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void setData(Date date) {
        this.moveActualDateTo(date);
    }

    public Date getCurrentDate() {
        return this.actualCal.getTime();
    }

    private void jbInit() {
        this.setTitle(Nat.x("Kalend\u00e1r"));
        Font f2 = new TngFieldString().getFont();
        this.boldTextfield = new Font(f2.getName(), 1, f2.getSize());
        this.bPreviousMonth.setIcon(TngIcon.getIcon("shift_left.png"));
        this.bPreviousMonth.setToolTipText(Nat.x("Predch\u00e1dzaj\u00faci mesiac"));
        this.bPreviousMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelDateChooser.this.moveActualDateBy(2, -1);
            }
        });
        this.bNextMonth.setIcon(TngIcon.getIcon("shift_right.png"));
        this.bNextMonth.setToolTipText(Nat.x("Nasleduj\u00faci mesiac"));
        this.bNextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelDateChooser.this.moveActualDateBy(2, 1);
            }
        });
        this.bPreviousYear.setIcon(TngIcon.getIcon("shift_begin.png"));
        this.bPreviousYear.setToolTipText(Nat.x("Predch\u00e1dzaj\u00faci rok"));
        this.bPreviousYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelDateChooser.this.moveActualDateBy(1, -1);
            }
        });
        this.bNextYear.setIcon(TngIcon.getIcon("shift_end.png"));
        this.bNextYear.setToolTipText(Nat.x("Nasleduj\u00faci rok"));
        this.bNextYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelDateChooser.this.moveActualDateBy(1, 1);
            }
        });
        this.topPane.setLayout(this.gridBagLayout2);
        this.dateLabel.setHorizontalAlignment(0);
        this.dayGrid.setLayout(this.gridLayout1);
        this.topPane.add((Component)this.bPreviousYear, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.topPane.add((Component)this.bPreviousMonth, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.topPane.add((Component)this.dateLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.topPane.add((Component)this.bNextMonth, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.topPane.add((Component)this.bNextYear, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(244, 136));
        this.add((Component)this.topPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.dayGrid, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                boolean consumed = true;
                switch (e2.getKeyCode()) {
                    case 39: 
                    case 107: {
                        TngPanelDateChooser.this.moveActualDateBy(5, 1);
                        break;
                    }
                    case 37: 
                    case 109: {
                        TngPanelDateChooser.this.moveActualDateBy(5, -1);
                        break;
                    }
                    case 38: {
                        TngPanelDateChooser.this.moveActualDateBy(5, -7);
                        break;
                    }
                    case 40: {
                        TngPanelDateChooser.this.moveActualDateBy(5, 7);
                        break;
                    }
                    case 34: {
                        if (e2.isControlDown()) {
                            TngPanelDateChooser.this.moveActualDateBy(1, -1);
                            break;
                        }
                        TngPanelDateChooser.this.moveActualDateBy(2, -1);
                        break;
                    }
                    case 33: {
                        if (e2.isControlDown()) {
                            TngPanelDateChooser.this.moveActualDateBy(1, 1);
                            break;
                        }
                        TngPanelDateChooser.this.moveActualDateBy(2, 1);
                        break;
                    }
                    case 84: {
                        TngPanelDateChooser.this.moveActualDateTo(new Date());
                        break;
                    }
                    case 36: {
                        TngPanelDateChooser.this.moveActualDateToFirstDayOfWeek();
                        TngPanelDateChooser.this.updateDayGrid();
                        break;
                    }
                    case 35: {
                        TngPanelDateChooser.this.moveActualDateToLastDayOfWeek();
                        TngPanelDateChooser.this.updateDayGrid();
                        break;
                    }
                    case 10: {
                        TngPanelDateChooser.this.dlgOkAction();
                        break;
                    }
                    default: {
                        consumed = false;
                    }
                }
                if (consumed) {
                    e2.consume();
                }
            }
        });
        this.createDayLabels();
        this.createDayGrid();
        this.updateDayGrid();
        TngSwing.setOptimalHeight(this);
    }

    private void createDayLabels() {
        for (int i2 = 0; i2 < DAY_LABELS_COUNT; ++i2) {
            TngLabel d2 = new TngLabel(TngUtilities.strLeft(DAYS_OF_WEEK[i2 + 1 > 6 ? 0 : i2 + 1], 2), 0);
            d2.setFont(this.boldTextfield);
            this.dayGrid.add(d2);
        }
    }

    private void createDayGrid() {
        for (int i2 = 0; i2 < DAY_LABELS_COUNT * 6; ++i2) {
            TngLabel day = new TngLabel();
            day.setHorizontalAlignment(0);
            day.setFocusable(false);
            day.setOpaque(true);
            if (i2 % 7 == 6) {
                day.setForeground(Color.RED);
            }
            day.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    TngLabel act = (TngLabel)e2.getSource();
                    int dayInt = TngUtilities.strToInt(act.getText(), 0);
                    if (dayInt == 0) {
                        return;
                    }
                    TngPanelDateChooser.this.actualCal.set(5, dayInt);
                    if (e2.getClickCount() == 1) {
                        TngPanelDateChooser.this.selectActualDay(act);
                    } else {
                        TngPanelDateChooser.this.dlgOkAction();
                    }
                }
            });
            this.dayGrid.add(day);
        }
    }

    private void updateDayGrid() {
        int i2;
        int offset = DAY_LABELS_COUNT + this.getOffset();
        for (int i3 = DAY_LABELS_COUNT; i3 < offset; ++i3) {
            this.dayGrid.getComponent(i3).setVisible(false);
        }
        int daysOfMonth = this.actualCal.getActualMaximum(5);
        for (i2 = 1; i2 <= daysOfMonth; ++i2) {
            TngLabel day = (TngLabel)this.dayGrid.getComponent(offset + i2 - 1);
            day.setText(String.valueOf(i2));
            day.setVisible(true);
            if (this.actualCal.get(5) != i2) continue;
            this.selectActualDay(day);
        }
        for (i2 = offset + daysOfMonth; i2 < DAY_LABELS_COUNT * 7; ++i2) {
            this.dayGrid.getComponent(i2).setVisible(false);
        }
        this.updateLabel();
    }

    private int getOffset() {
        GregorianCalendar c2 = new GregorianCalendar(this.actualCal.get(1), this.actualCal.get(2), 1);
        int d2 = c2.get(7);
        if (d2 == 1) {
            return 6;
        }
        return d2 - 2;
    }

    private void updateLabel() {
        String monthName = MONTHS[this.actualCal.get(2)];
        int year = this.actualCal.get(1);
        int era = this.actualCal.get(0);
        String eraName = era == 0 ? " BC" : "";
        this.dateLabel.setText(monthName + " " + year + eraName);
    }

    private void selectActualDay(TngLabel current) {
        if (this.last != null) {
            this.last.setBackground(null);
            this.last.setBorder(null);
            this.last.setFont(null);
        }
        this.last = current;
        this.last.setFont(this.boldTextfield);
        this.last.setBorder(this.actualBorder);
        this.last.setBackground(Color.LIGHT_GRAY);
    }

    private void moveActualDateTo(Date date) {
        this.actualCal.setTime(date);
        this.updateDayGrid();
    }

    private void moveActualDateBy(int field, int amount) {
        this.actualCal.add(field, amount);
        this.updateDayGrid();
    }

    private void moveActualDateToFirstDayOfWeek() {
        int dayOfWeek;
        while ((dayOfWeek = this.actualCal.get(7)) != 2) {
            this.actualCal.add(5, -1);
        }
        return;
    }

    private void moveActualDateToLastDayOfWeek() {
        int dayOfWeek;
        while ((dayOfWeek = this.actualCal.get(7)) != 1) {
            this.actualCal.add(5, 1);
        }
        return;
    }
}

