/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tangram.library.Nat;
import tangram.swing.TngSwing;
import tangram.swing.component.TngCheckBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.TngList;
import tangram.swing.container.TngScrollPane;
import tangram.swing.panel.TngPanel;

public class TngPanelFontChooser
extends TngPanel {
    static final int MIN_FONT_SIZE = 6;
    protected Font resultFont;
    protected String resultName;
    protected int resultSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected String displayText = Nat.nox("Tangram a.s., Pre\u0161ov");
    private TngScrollPane spName = new TngScrollPane();
    private TngScrollPane spSize = new TngScrollPane();
    protected TngList name = new TngList();
    protected DefaultListModel nameModel = new DefaultListModel();
    protected TngList size = new TngList();
    protected DefaultListModel sizeModel = new DefaultListModel();
    TngCheckBox bold = new TngCheckBox();
    TngCheckBox italic = new TngCheckBox();
    protected TngLabel preview = new TngLabel(this.displayText);
    JPanel top = new JPanel();
    JPanel attrs = new JPanel();
    JPanel bottom = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();

    public TngPanelFontChooser() {
        try {
            this.jbInit();
            this.createModels();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void createModels() {
        int i2;
        this.nameModel.clear();
        this.sizeModel.clear();
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i2 = 0; i2 < fontList.length; ++i2) {
            this.nameModel.addElement(fontList[i2]);
        }
        for (i2 = 6; i2 < 100; ++i2) {
            this.sizeModel.addElement(i2);
        }
        this.name.setModel(this.nameModel);
        this.size.setModel(this.sizeModel);
        this.name.setSelectedIndex(0);
        this.size.setSelectedIndex(10);
        this.bold.setSelected(false);
        this.italic.setSelected(false);
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(520, 340));
        this.setTitle(Nat.x("V\u00fdber fontu"));
        this.setLayout(this.borderLayout1);
        this.top.setLayout(this.gridBagLayout2);
        this.top.setOpaque(false);
        this.attrs.setLayout(new GridLayout(1, 2));
        this.attrs.setOpaque(false);
        this.bold.setText(Nat.x("tu\u010dn\u00e9"));
        this.bold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                TngPanelFontChooser.this.previewFont();
            }
        });
        this.attrs.add(this.bold);
        this.italic.setText(Nat.x("\u0161ikm\u00e9"));
        this.italic.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                TngPanelFontChooser.this.previewFont();
            }
        });
        this.attrs.add(this.italic);
        this.spName.getViewport().add((Component)this.name, null);
        this.spSize.getViewport().add((Component)this.size, null);
        this.top.add((Component)this.spName, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
        this.top.add((Component)this.spSize, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 30, 0));
        this.top.add((Component)this.attrs, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.top, "Center");
        this.bottom.setLayout(new BorderLayout());
        this.bottom.setBorder(new LineBorder(Color.BLACK, 1, false));
        this.preview.setHorizontalAlignment(0);
        this.bottom.add((Component)this.preview, "South");
        this.add((Component)this.bottom, "South");
        this.name.setCellRenderer(new TngListRenderer());
        this.name.setFixedCellHeight(30);
        this.name.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TngPanelFontChooser.this.previewFont();
            }
        });
        this.size.setCellRenderer(new TngListRenderer());
        this.size.setFixedCellHeight(30);
        this.size.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TngPanelFontChooser.this.previewFont();
            }
        });
    }

    public void setData(Font font) {
        this.name.setSelectedValue(font.getName(), true);
        this.size.setSelectedIndex(font.getSize() - 6);
        this.size.ensureIndexIsVisible(font.getSize() - 6);
        this.bold.setSelected(font.isBold());
        this.italic.setSelected(font.isItalic());
        this.previewFont();
    }

    protected void saveFont() {
        this.resultName = this.name.getSelectedValue().toString();
        this.resultSize = this.size.getSelectedIndex() + 6;
        this.isBold = this.bold.isSelected();
        this.isItalic = this.italic.isSelected();
        int attrs = 0;
        if (this.isBold) {
            attrs = 1;
        }
        if (this.isItalic) {
            attrs |= 2;
        }
        this.resultFont = new Font(this.resultName, attrs, this.resultSize);
    }

    protected void previewFont() {
        this.saveFont();
        this.preview.setFont(this.resultFont);
    }

    public String getSelectedName() {
        return this.resultName;
    }

    public int getSelectedSize() {
        return this.resultSize;
    }

    public Font getSelectedFont() {
        return this.resultFont;
    }

    class TngListRenderer
    extends TngLabel
    implements ListCellRenderer {
        Color oddDefaultRowColor = Color.decode("#F0F0F0");

        TngListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setHorizontalAlignment(2);
            this.setOpaque(true);
            this.setText(value.toString());
            if (isSelected) {
                this.setBackground(((TngList)list).getSelectionBackground());
            } else if (this.oddDefaultRowColor != null) {
                this.setBackground(index % 2 == 0 ? ((TngList)list).getBackground() : this.oddDefaultRowColor);
            } else {
                this.setBackground(((TngList)list).getBackground());
            }
            return this;
        }
    }
}

