/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.sql.SQLException;
import tangram.exception.TngExceptionNoChange;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.TngWaiter;
import tangram.swing.panel.TngPanel;

public class TngPanelForm
extends TngPanel {
    public static final int OP_INSERT = 1;
    public static final int OP_EDIT = 2;
    public static final int OP_COPY = 3;
    protected int operation;
    protected String[] primaryKeys;
    private String id = null;

    public TngPanelForm() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
    }

    public boolean setData(int operation, String[] primaryKeys) {
        this.operation = operation;
        this.primaryKeys = primaryKeys;
        this.beforeLoadRecord();
        if (!this.isInsert() && !this.loadRecord()) {
            return this.loadFailed();
        }
        this.afterLoadRecord();
        this.appendTitle();
        return true;
    }

    private void appendTitle() {
        String title = this.getTitle();
        String h2 = Nat.x("nov\u00fd z\u00e1znam");
        if (this.isEdit()) {
            h2 = Nat.x("\u00faprava z\u00e1znamu");
        } else if (this.isCopy()) {
            h2 = Nat.x("kop\u00edrovanie z\u00e1znamu");
        }
        super.setTitle(TngUtilities.isEmpty(title) ? h2 : title + " - " + h2);
    }

    protected void beforeLoadRecord() {
    }

    protected boolean loadRecord() {
        return false;
    }

    protected boolean loadFailed() {
        TngSwing.msgWarning(Nat.x("Z\u00e1znam bol medzi\u010dasom zmenen\u00fd alebo zmazan\u00fd"));
        return false;
    }

    protected void afterLoadRecord() {
    }

    @Override
    public boolean doCustom() throws Exception {
        throw new Exception(Nat.x("Formul\u00e1r nepodporuje pou\u017e\u00edvate\u013esky definovan\u00fa oper\u00e1ciu"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doSave() throws Exception {
        if (!this.checkUnique()) {
            return false;
        }
        TngWaiter.start(this);
        try {
            switch (this.operation) {
                case 1: {
                    boolean bl = this.doInsert();
                    return bl;
                }
                case 2: {
                    boolean bl = this.doEdit();
                    return bl;
                }
                case 3: {
                    boolean bl = this.doCopy();
                    return bl;
                }
            }
            try {
                throw new Exception(Nat.x("Nepovolen\u00e1 oper\u00e1cia %1", this.operation));
            }
            catch (SQLException e2) {
                if (TngConnection.isUniqueViolation(e2)) {
                    boolean bl = this.uniqueViolation();
                    return bl;
                }
                throw e2;
            }
            catch (TngExceptionNoChange e3) {
                boolean bl = this.noChange(e3.getMessage());
                return bl;
            }
        }
        finally {
            TngWaiter.stop(this);
        }
    }

    @Override
    public boolean doCancel() {
        try {
            if (this.hasChanged()) {
                String msg = Nat.x("Niektor\u00e9 polo\u017eky boli zmenen\u00e9");
                msg = msg + "\n" + Nat.x("Naozaj si \u017eel\u00e1te pokra\u010dova\u0165 bez ulo\u017eenia zmien?");
                return TngSwing.msgAsk(msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected boolean isInsert() {
        return this.operation == 1;
    }

    protected boolean isEdit() {
        return this.operation == 2;
    }

    protected boolean isCopy() {
        return this.operation == 3;
    }

    protected boolean doInsert() throws Exception {
        throw new Exception(Nat.x("Formul\u00e1r nepodporuje oper\u00e1ciu vlo\u017eenia z\u00e1znamu"));
    }

    protected boolean doEdit() throws Exception {
        throw new Exception(Nat.x("Formul\u00e1r nepodporuje oper\u00e1ciu zmeny z\u00e1znamu"));
    }

    protected boolean doCopy() throws Exception {
        throw new Exception(Nat.x("Formul\u00e1r nepodporuje oper\u00e1ciu kop\u00edrovania z\u00e1znamu"));
    }

    protected boolean checkUnique() throws Exception {
        return true;
    }

    protected boolean hasChanged() throws Exception {
        return false;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    protected boolean uniqueViolation() {
        TngSwing.msgError(Nat.x("Z\u00e1znam u\u017e existuje"));
        return false;
    }

    protected boolean noChange(String msg) {
        TngSwing.msgOK(msg);
        return false;
    }
}

