/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import tangram.library.Nat;
import tangram.library.TngConfigAbstract;
import tangram.library.TngConnection;
import tangram.library.TngSys;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngCheckBox;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngFieldPassword;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngPanelListValues;

public class TngPanelSqlLogin2
extends TngPanel {
    private TngLabel lDatabase = new TngLabel();
    private TngLabel lUser = new TngLabel();
    private TngLabel lPassword = new TngLabel();
    private TngCheckBox jLogInAsSysdba = new TngCheckBox();
    private TngComboBox jDatabase = new TngComboBox();
    private TngFieldString jUser = new TngFieldString();
    private TngFieldPassword jPassword = new TngFieldPassword();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngConnection connection = new TngConnection();
    private boolean schemaEnabled = true;
    private final List<String> excludedSections = new ArrayList<String>();
    private boolean autoSave;
    private TngConfigAbstract cfg;
    private String project;
    private String defaultSchema;
    private TngSys tngSysSchema = new TngSys();
    private String lastSetUser;

    public TngPanelSqlLogin2() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(229, 94));
        this.setTitle(Nat.x("Prihl\u00e1senie k datab\u00e1ze"));
        this.setLayout(this.gridBagLayout1);
        this.jLogInAsSysdba.setText(Nat.x("prihl\u00e1si\u0165 ako &administr\u00e1tor"));
        this.jLogInAsSysdba.setForeground(null);
        this.jLogInAsSysdba.setHorizontalAlignment(2);
        this.jLogInAsSysdba.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                boolean selected;
                boolean bl = selected = e2.getStateChange() == 1;
                if (selected) {
                    TngPanelSqlLogin2.this.lastSetUser = TngPanelSqlLogin2.this.jUser.getStringDef(null);
                }
                TngPanelSqlLogin2.this.jUser.setString(selected ? "SYS AS SYSDBA" : TngPanelSqlLogin2.this.lastSetUser);
                TngPanelSqlLogin2.this.jUser.setEditable(!selected);
                if (selected) {
                    TngPanelSqlLogin2.this.jPassword.requestFocusInWindow();
                } else {
                    TngPanelSqlLogin2.this.jUser.requestFocusInWindow();
                }
            }
        });
        this.lDatabase.setText(Nat.x("&Datab\u00e1za"));
        this.lDatabase.setForeground(null);
        this.lDatabase.setHorizontalAlignment(4);
        this.lUser.setForeground(null);
        this.lUser.setHorizontalAlignment(4);
        this.lUser.setText(Nat.x("&Pou\u017e\u00edvate\u013e"));
        this.jUser.setValueCanNull(false);
        this.jUser.setValueFormat(1);
        this.lPassword.setText(Nat.x("&Heslo"));
        this.lPassword.setForeground(null);
        this.lPassword.setHorizontalAlignment(4);
        this.jPassword.setValueCanNull(false);
        this.jDatabase.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                TngPanelSqlLogin2.this.jDatabase_itemStateChanged(e2);
            }
        });
        this.add((Component)this.lDatabase, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jDatabase, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLogInAsSysdba, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.lUser, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jUser, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.lPassword, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.setLogInAsSysdbaEnabled(false);
        this.clearExcludedSections();
        this.setOptimalSize();
    }

    @Override
    public boolean doBeforeShow() {
        if (this.jDatabase.getItemCount() < 2) {
            this.jUser.requestFocusInWindow();
        }
        return true;
    }

    public TngConnection getConnection() {
        return this.connection;
    }

    public void setSchemaEnabled(boolean schemaEnabled) {
        this.schemaEnabled = schemaEnabled;
    }

    public void setLogInAsSysdbaEnabled(boolean logInAsSysdbaEnabled) {
        this.jLogInAsSysdba.setVisible(logInAsSysdbaEnabled);
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void clearExcludedSections() {
        this.excludedSections.clear();
        this.addExludedSection("GLOBAL");
    }

    public void addExludedSection(String excludedSection) {
        this.excludedSections.add(excludedSection);
    }

    public void addExludedSections(List<String> excludedSections) {
        this.excludedSections.addAll(excludedSections);
    }

    private String[] excludeSections(String[] databases) {
        if (this.excludedSections.size() == 0) {
            return databases;
        }
        ArrayList<String> ex = new ArrayList<String>();
        for (String db : databases) {
            boolean f2 = false;
            for (String es : this.excludedSections) {
                if (!es.equalsIgnoreCase(db)) continue;
                f2 = true;
            }
            if (f2) continue;
            ex.add(db);
        }
        return ex.toArray(new String[ex.size()]);
    }

    public void setData(TngConfigAbstract cfg, String project) {
        try {
            this.cfg = cfg;
            this.project = project;
            String[] databases = cfg.getDatabases();
            databases = this.excludeSections(databases);
            this.jDatabase.setModel(new DefaultComboBoxModel<String>(databases));
            this.jDatabase.setSelectedItem(cfg.getDefDatabase());
            this.jDatabase.setEnabled(databases.length != 1);
            this.databaseChanged();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Chyba pri na\u010d\u00edtavan\u00ed konfigura\u010dn\u00fdch parametrov prihl\u00e1senia"), e2);
        }
    }

    private void databaseChanged() throws Exception {
        if (this.jDatabase.getSelectedItem() == null) {
            this.jUser.setString("");
            this.jPassword.setPsswd("");
            this.defaultSchema = "";
        } else {
            String database = this.jDatabase.getSelectedItem().toString();
            this.jUser.setString(this.cfg.getDefUser(database));
            this.jPassword.setPsswd(this.cfg.getDefPassword(database));
            this.defaultSchema = this.cfg.getDefSchema(database);
        }
    }

    public String getDatabaseName() {
        return this.jDatabase.getSelectedItem() == null ? "???" : this.jDatabase.getSelectedItem().toString();
    }

    @Override
    public boolean doSave() throws Exception {
        List<String> schemas = this.connect();
        if (schemas == null) {
            return false;
        }
        if (!this.schemaEnabled) {
            return true;
        }
        String schema = this.selectSchema(schemas);
        if (schema == null) {
            return false;
        }
        this.connection.changeSchema(schema);
        return true;
    }

    private List<String> connect() {
        if (this.jDatabase.getSelectedItem() == null) {
            TngSwing.msgNovalid(Nat.x("Zvo\u013ete datab\u00e1zu"), this.jDatabase);
            return null;
        }
        try {
            String database = this.jDatabase.getSelectedItem().toString();
            this.cfg.setConnection(database, this.connection);
            this.connection.setUser(this.jUser.getText());
            this.connection.setPassword(this.jPassword.getPsswd());
            this.connection.setSchema("");
            this.connection.connect();
            return this.readSchemas(this.connection);
        }
        catch (Exception e2) {
            if (TngConnection.isErrorLogin(e2)) {
                TngSwing.msgError(Nat.x("Nespr\u00e1vne prihlasovacie meno alebo heslo"));
            } else {
                TngSwing.exceptionShow(Nat.x("Chyba pri prihlasovan\u00ed"), e2);
            }
            this.connection.close();
            return null;
        }
    }

    private List<String> readSchemas(TngConnection conn) throws Exception {
        this.tngSysSchema.setConn(conn);
        String loginname = conn.getUser();
        this.tngSysSchema.check(loginname);
        ArrayList<String> schemas = new ArrayList<String>();
        this.tngSysSchema.loadSchemas(this.project, schemas);
        Iterator it = schemas.iterator();
        while (it.hasNext()) {
            if (this.tngSysSchema.hasAccess(loginname, (String)it.next(), this.project)) continue;
            it.remove();
        }
        return schemas;
    }

    private String selectSchema(List<String> schemas) {
        if (schemas.size() == 0) {
            TngSwing.msgWarning(Nat.x("Pou\u017e\u00edvate\u013e %1 nem\u00e1 pridelen\u00fa \u017eiadnu sch\u00e9mu pre projekt %2", this.jUser.getStringDef(""), this.project));
            return null;
        }
        if (this.isAutoSave() && !TngUtilities.isEmpty(this.defaultSchema)) {
            if (schemas.contains(this.defaultSchema)) {
                return this.defaultSchema;
            }
            TngSwing.msgWarning(Nat.x("Pou\u017e\u00edvate\u013e %1 nem\u00e1 pridelen\u00fd pr\u00edstup k predvolenej sch\u00e9me %2", this.jUser.getStringDef(""), this.defaultSchema));
        }
        if (schemas.size() == 1 && !this.isAutoSave()) {
            return schemas.get(0);
        }
        TngPanelListValues p2 = new TngPanelListValues();
        p2.setTitle(Nat.x("V\u00fdber sch\u00e9my"));
        p2.setData(schemas, this.defaultSchema);
        if (!TngDlg.runModal(p2)) {
            return null;
        }
        return p2.getValue();
    }

    private void jDatabase_itemStateChanged(ItemEvent e2) {
        try {
            this.databaseChanged();
        }
        catch (Exception er) {
            TngSwing.exceptionShow(Nat.x("Chyba pri zmene parametrov datab\u00e1zy"), er);
        }
    }
}

