/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import tangram.library.Nat;
import tangram.library.TngOrder;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.component.TngLabel;
import tangram.swing.component.TngList;
import tangram.swing.component.TngListRendererCell;
import tangram.swing.component.button.TngButton;
import tangram.swing.container.TngScrollPane;
import tangram.swing.icon.TngIcon;
import tangram.swing.panel.TngPanel;
import tangram.swing.table.component.TngTableColumn;

public class TngPanelWizardOrder
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabel1 = new TngLabel();
    private TngLabel jLabel2 = new TngLabel();
    private TngScrollPane jScrollPane1 = new TngScrollPane();
    private TngScrollPane jScrollPane2 = new TngScrollPane();
    private TngList jColumns = new TngList();
    private TngList jOrder = new TngList();
    private JPanel jPanel1 = new JPanel();
    private TngButton jAdd = new TngButton();
    private TngButton jDelete = new TngButton();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JPanel jPanel2 = new JPanel();
    private TngButton jTop = new TngButton();
    private TngButton jUp = new TngButton();
    private TngButton jDown = new TngButton();
    private TngButton jBottom = new TngButton();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private TngButton jAscending = new TngButton();
    private TngButton jDescending = new TngButton();
    private TngButton jSwap = new TngButton();
    private TngButton jSwapAll = new TngButton();
    static final ImageIcon iconAsc = TngIcon.getIcon("order_up.png");
    static final ImageIcon iconDesc = TngIcon.getIcon("order_down.png");
    private DefaultListModel mdColumns = new DefaultListModel();
    private DefaultListModel mdOrder = new DefaultListModel();
    private boolean validateEmpty;

    public TngPanelWizardOrder() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(635, 453));
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(635, 280));
        this.setTitle(Nat.x("Usporiadanie"));
        this.jLabel1.setText(Nat.x("Dostupn\u00e9 st\u013apce"));
        this.jLabel1.setLabelFor(this.jColumns);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel2.setText(Nat.x("Zvolen\u00e9 usporiadanie"));
        this.jLabel2.setLabelFor(this.jOrder);
        this.jLabel2.setHorizontalAlignment(2);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 130));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 130));
        this.jColumns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TngPanelWizardOrder.this.jColumns_mouseClicked(e2);
            }
        });
        this.jOrder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TngPanelWizardOrder.this.jOrder_mouseClicked(e2);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jAdd.setMargin(new Insets(0, 0, 0, 0));
        this.jAdd.setToolTipText(Nat.x("Prida\u0165"));
        this.jAdd.setText("M");
        this.jAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jAdd_actionPerformed(e2);
            }
        });
        this.jDelete.setMargin(new Insets(0, 0, 0, 0));
        this.jDelete.setToolTipText(Nat.x("Odobra\u0165"));
        this.jDelete.setText("M");
        this.jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jDelete_actionPerformed(e2);
            }
        });
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.jTop.setMargin(new Insets(0, 0, 0, 0));
        this.jTop.setToolTipText(Nat.x("Presun\u00fa\u0165 na za\u010diatok"));
        this.jTop.setText("M");
        this.jTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jFirst_actionPerformed(e2);
            }
        });
        this.jUp.setMargin(new Insets(0, 0, 0, 0));
        this.jUp.setToolTipText(Nat.x("Posun\u00fa\u0165 hore"));
        this.jUp.setText("M");
        this.jUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jUp_actionPerformed(e2);
            }
        });
        this.jDown.setMargin(new Insets(0, 0, 0, 0));
        this.jDown.setToolTipText(Nat.x("Posun\u00fa\u0165 dole"));
        this.jDown.setText("M");
        this.jDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jDown_actionPerformed(e2);
            }
        });
        this.jBottom.setMargin(new Insets(0, 0, 0, 0));
        this.jBottom.setToolTipText(Nat.x("Presun\u00fa\u0165 na koniec"));
        this.jBottom.setText("M");
        this.jBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jLast_actionPerformed(e2);
            }
        });
        this.jAscending.setMargin(new Insets(0, 0, 0, 0));
        this.jAscending.setToolTipText(Nat.x("Vzostupne"));
        this.jAscending.setText("M");
        this.jAscending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jAscending_actionPerformed(e2);
            }
        });
        this.jDescending.setMargin(new Insets(0, 0, 0, 0));
        this.jDescending.setToolTipText(Nat.x("Zostupne"));
        this.jDescending.setText("M");
        this.jDescending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jDescending_actionPerformed(e2);
            }
        });
        this.jSwap.setMargin(new Insets(0, 0, 0, 0));
        this.jSwap.setToolTipText(Nat.x("Prevr\u00e1ti\u0165"));
        this.jSwap.setText("M");
        this.jSwap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jSwap_actionPerformed(e2);
            }
        });
        this.jSwapAll.setMargin(new Insets(0, 0, 0, 0));
        this.jSwapAll.setToolTipText(Nat.x("Prevr\u00e1ti\u0165 v\u0161etko"));
        this.jSwapAll.setText("M");
        this.jSwapAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelWizardOrder.this.jSwapAll_actionPerformed(e2);
            }
        });
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jColumns, null);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane2.getViewport().add((Component)this.jOrder, null);
        this.add((Component)this.jScrollPane2, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jDelete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.jPanel2.add((Component)this.jTop, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jUp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jDown, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jBottom, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jAscending, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jDescending, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jSwap, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jSwapAll, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.changeButton(this.jAdd, "shift_right.png");
        this.changeButton(this.jDelete, "shift_left.png");
        this.changeButton(this.jTop, "arrow_top.png");
        this.changeButton(this.jUp, "arrow_up.png");
        this.changeButton(this.jDown, "arrow_down.png");
        this.changeButton(this.jBottom, "arrow_bottom.png");
        this.changeButton(this.jAscending, "arrow_asc.png");
        this.changeButton(this.jDescending, "arrow_desc.png");
        this.changeButton(this.jSwap, "arrow_swap.png");
        this.changeButton(this.jSwapAll, "arrow_swap_all.png");
        this.jColumns.setCellRenderer(new AscendingCellRenderer(false));
        this.jOrder.setCellRenderer(new AscendingCellRenderer(true));
        this.setOptimalHeight();
    }

    private void changeButton(TngButton c2, String icon) {
        c2.setIcon(TngIcon.getIcon(icon));
        c2.setText(null);
    }

    public void setData(TngTableColumn[] columns, String order, boolean validateEmpty) {
        this.validateEmpty = validateEmpty;
        this.setColumns(columns);
        this.setOrder(order);
    }

    public void setColumns(TngTableColumn[] columns) {
        if (columns == null) {
            columns = new TngTableColumn[]{};
        }
        this.jColumns.setModel(this.mdColumns);
        this.mdColumns.clear();
        this.mdOrder.clear();
        this.setOrder(null);
        for (int i2 = 0; i2 < columns.length; ++i2) {
            if (!columns[i2].canOrdered) continue;
            TngOrder o2 = new TngOrder(columns[i2].name, columns[i2].title);
            this.mdColumns.addElement(o2);
        }
        this.selectAndScroll(this.jColumns, 0);
    }

    public void setOrder(String order) {
        this.jOrder.setModel(this.mdOrder);
        this.orderClear();
        TngOrder[] o2 = TngOrder.analyzeOrder(order);
        for (int i2 = 0; i2 < o2.length; ++i2) {
            this.orderAdd(o2[i2].name, o2[i2].asc);
        }
        this.selectAndScroll(this.jColumns, 0);
        this.selectAndScroll(this.jOrder, 0);
    }

    public String getOrder() {
        StringBuilder buff = new StringBuilder(64);
        for (int i2 = 0; i2 < this.mdOrder.getSize(); ++i2) {
            TngOrder o2 = (TngOrder)this.mdOrder.getElementAt(i2);
            if (i2 > 0) {
                buff.append(',');
            }
            buff.append(o2.createExpression());
        }
        return buff.toString();
    }

    private void orderClear() {
        for (int i2 = 0; i2 < this.mdOrder.getSize(); ++i2) {
            TngOrder o2 = (TngOrder)this.mdOrder.getElementAt(i2);
            this.mdColumns.addElement(o2);
        }
        this.mdOrder.clear();
        this.selectAndScroll(this.jColumns, this.mdColumns.getSize() - 1);
    }

    private void orderChangeAscSelected(int mode) {
        int a2 = this.jOrder.getMinSelectionIndex();
        int b2 = this.jOrder.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        for (int i2 = a2; i2 <= b2; ++i2) {
            if (!this.jOrder.isSelectedIndex(i2)) continue;
            TngOrder o2 = (TngOrder)this.mdOrder.getElementAt(i2);
            o2.asc = mode < 0 ? !o2.asc : mode != 0;
            this.mdOrder.setElementAt(o2, i2);
        }
    }

    private void orderChangeAscAll() {
        for (int i2 = 0; i2 < this.mdOrder.getSize(); ++i2) {
            TngOrder o2 = (TngOrder)this.mdOrder.getElementAt(i2);
            o2.asc = !o2.asc;
            this.mdOrder.setElementAt(o2, i2);
        }
    }

    private void orderDeleteSelected() {
        int i2;
        int a2 = this.jOrder.getMinSelectionIndex();
        int b2 = this.jOrder.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        for (i2 = a2; i2 <= b2; ++i2) {
            if (!this.jOrder.isSelectedIndex(i2)) continue;
            TngOrder o2 = (TngOrder)this.mdOrder.getElementAt(i2);
            this.mdColumns.addElement(o2);
        }
        for (i2 = b2; i2 >= a2; --i2) {
            if (!this.jOrder.isSelectedIndex(i2)) continue;
            this.mdOrder.removeElementAt(i2);
        }
        this.selectAndScroll(this.jColumns, this.mdColumns.getSize() - 1);
        this.selectAndScroll(this.jOrder, Math.min(a2, this.mdOrder.getSize() - 1));
    }

    private void orderAddSelected() {
        int i2;
        int a2 = this.jColumns.getMinSelectionIndex();
        int b2 = this.jColumns.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        for (i2 = a2; i2 <= b2; ++i2) {
            if (!this.jColumns.isSelectedIndex(i2)) continue;
            TngOrder o2 = (TngOrder)this.mdColumns.getElementAt(i2);
            this.mdOrder.addElement(o2);
        }
        for (i2 = b2; i2 >= a2; --i2) {
            if (!this.jColumns.isSelectedIndex(i2)) continue;
            this.mdColumns.removeElementAt(i2);
        }
        this.selectAndScroll(this.jOrder, this.mdOrder.getSize() - 1);
        this.selectAndScroll(this.jColumns, Math.min(a2, this.mdColumns.getSize() - 1));
    }

    private void orderAdd(String sqlName, boolean asc) {
        for (int i2 = 0; i2 < this.mdColumns.getSize(); ++i2) {
            TngOrder o2 = (TngOrder)this.mdColumns.getElementAt(i2);
            if (!o2.name.equals(sqlName)) continue;
            o2.asc = asc;
            this.mdOrder.addElement(o2);
            this.mdColumns.removeElementAt(i2);
            break;
        }
    }

    private void orderShiftSelectedUp(int shift) {
        if (shift == 0) {
            return;
        }
        int a2 = this.jOrder.getMinSelectionIndex();
        int b2 = this.jOrder.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        if (a2 == 0) {
            return;
        }
        if (shift < 0) {
            shift = a2;
        }
        for (int i2 = a2; i2 <= b2; ++i2) {
            if (!this.jOrder.isSelectedIndex(i2)) continue;
            this.moveElement(this.mdOrder, i2, i2 - shift);
            this.jOrder.addSelectionInterval(i2 - shift, i2 - shift);
        }
        int v = a2 - shift - 1;
        if (v < 0) {
            v = 0;
        }
        this.jOrder.ensureIndexIsVisible(v);
    }

    private void orderShiftSelectedDown(int shift) {
        if (shift == 0) {
            return;
        }
        int a2 = this.jOrder.getMinSelectionIndex();
        int b2 = this.jOrder.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        if (b2 == this.mdOrder.getSize() - 1) {
            return;
        }
        if (shift < 0) {
            shift = this.mdOrder.getSize() - b2 - 1;
        }
        for (int i2 = b2; i2 >= a2; --i2) {
            if (!this.jOrder.isSelectedIndex(i2)) continue;
            this.moveElement(this.mdOrder, i2, i2 + shift);
            this.jOrder.addSelectionInterval(i2 + shift, i2 + shift);
        }
        int v = b2 + shift + 1;
        if (v >= this.mdOrder.getSize()) {
            v = this.mdOrder.getSize() - 1;
        }
        this.jOrder.ensureIndexIsVisible(v);
    }

    private void moveElement(DefaultListModel m2, int from, int to) {
        if (m2 == null || from == to) {
            return;
        }
        if (from < 0 || to < 0 || from >= m2.getSize() || to >= m2.getSize()) {
            return;
        }
        Object o2 = m2.getElementAt(from);
        m2.removeElementAt(from);
        m2.insertElementAt(o2, to);
    }

    private void selectAndScroll(TngList list, int index) {
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    private void jAdd_actionPerformed(ActionEvent e2) {
        this.orderAddSelected();
    }

    private void jDelete_actionPerformed(ActionEvent e2) {
        this.orderDeleteSelected();
    }

    private void jAscending_actionPerformed(ActionEvent e2) {
        this.orderChangeAscSelected(1);
    }

    private void jDescending_actionPerformed(ActionEvent e2) {
        this.orderChangeAscSelected(0);
    }

    private void jSwap_actionPerformed(ActionEvent e2) {
        this.orderChangeAscSelected(-1);
    }

    private void jSwapAll_actionPerformed(ActionEvent e2) {
        this.orderChangeAscAll();
    }

    private void jColumns_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() == 2) {
            this.orderAddSelected();
        }
    }

    private void jOrder_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() == 2) {
            this.orderDeleteSelected();
        }
    }

    private void jFirst_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedUp(-1);
    }

    private void jUp_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedUp(1);
    }

    private void jDown_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedDown(1);
    }

    private void jLast_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedDown(-1);
    }

    @Override
    public boolean doBeforeShow() {
        this.selectAndScroll(this.jColumns, 0);
        this.selectAndScroll(this.jOrder, 0);
        return true;
    }

    @Override
    public void doValidate(TngValidationError errors) {
        if (this.validateEmpty && this.mdOrder.getSize() == 0) {
            errors.addError(this.jColumns, Nat.x("Zvo\u013ete usporiadanie"));
        }
    }

    class AscendingCellRenderer
    extends TngListRendererCell {
        private boolean showAsc;

        public AscendingCellRenderer(boolean showAsc) {
            this.showAsc = showAsc;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            TngOrder o2 = (TngOrder)value;
            this.setText(o2.title);
            this.setHorizontalAlignment(2);
            if (this.showAsc) {
                this.setIcon(o2.asc ? iconAsc : iconDesc);
            }
            return this;
        }
    }
}

