/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import tangram.interfaces.TngProgressable;
import tangram.library.Nat;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButtonCancel;
import tangram.swing.panel.TngPanel;
import tangram.swing.progress.TngProgressBar;

public abstract class TngProgressableWorker
extends JDialog
implements TngProgressable {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private TngPanel jContent = new TngPanel();
    private TngLabel jTitle = new TngLabel();
    private TngLabel jStatus = new TngLabel();
    private TngProgressBar jProgressBar = new TngProgressBar();
    private TngButtonCancel jCancel = new TngButtonCancel();
    private String title = " ";
    private String status = " ";
    private boolean cancelable;
    private boolean isCanceled;
    private WorkerThread runner;
    private static int actives = 0;
    private int actualProgressValue = 0;
    public Object result;

    public static boolean isAnyActive() {
        return actives > 0;
    }

    public TngProgressableWorker(String title) {
        super(TngSwing.mainWindow);
        this.title = title;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(435, 110));
        this.setModal(true);
        this.setUndecorated(true);
        TngSwing.waitCursorOn(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e2) {
                TngProgressableWorker.this.this_componentShown(e2);
            }
        });
        this.jTitle.setText(this.title);
        this.jTitle.setHorizontalAlignment(2);
        this.jTitle.setFont(new Font("Dialog", 1, 14));
        this.jTitle.setHorizontalTextPosition(2);
        this.jTitle.setForeground(Color.black);
        this.jStatus.setText(this.status);
        this.jStatus.setHorizontalAlignment(2);
        this.jStatus.setHorizontalTextPosition(2);
        this.jStatus.setForeground(Color.black);
        this.jProgressBar.setIndeterminate(true);
        this.jProgressBar.setStringPainted(false);
        this.jCancel.setText(Nat.x("Preru\u0161i\u0165"));
        this.jCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngProgressableWorker.this.isCanceled = true;
            }
        });
        this.setProgressCancelable(false);
        this.jContent.setLayout(this.gridBagLayout2);
        this.jContent.setBorder(BorderFactory.createEtchedBorder(0));
        this.jContent.add((Component)this.jTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 12, 3, 12), 0, 0));
        this.jContent.add((Component)this.jProgressBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 3, 12), 0, 0));
        this.jContent.add((Component)this.jStatus, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 3, 12), 0, 0));
        this.jContent.add((Component)this.jCancel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.getContentPane().add((Component)this.jContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        TngSwing.windowCenter(this);
        TngSwing.setOptimalSize(this.jContent);
    }

    private void this_componentShown(ComponentEvent e2) {
        Thread threadRunner = new Thread(this.runner);
        threadRunner.start();
    }

    public void start() throws Exception {
        ++actives;
        this.runner = new WorkerThread();
        this.setVisible(true);
        Throwable e2 = this.runner.getException();
        --actives;
        if (e2 != null) {
            if (e2 instanceof Exception) {
                throw (Exception)e2;
            }
            Exception e22 = new Exception(Nat.x("Chyba vykonania oper\u00e1cie:") + "\n" + e2.toString());
            e22.setStackTrace(e2.getStackTrace());
            throw e22;
        }
    }

    @Override
    public void setProgressTitle(String title) {
        this.jTitle.setText(title);
    }

    @Override
    public void setProgressStatus(String status) {
        this.jStatus.setText(status);
    }

    @Override
    public void setProgressMax(int max) {
        this.jProgressBar.setMaximum(max);
        this.actualProgressValue = 0;
    }

    @Override
    public void setProgressValue(int value) {
        if (this.actualProgressValue == value) {
            return;
        }
        this.actualProgressValue = value;
        this.jProgressBar.setValue(this.actualProgressValue);
    }

    @Override
    public void addProgressValue(int value) {
        if (value == 0) {
            return;
        }
        this.actualProgressValue += value;
        this.jProgressBar.setValue(this.actualProgressValue);
    }

    @Override
    public boolean isProgressCanceled() {
        if (!this.isCanceled) {
            return false;
        }
        this.isCanceled = false;
        return TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te preru\u0161i\u0165 prebiehaj\u00facu oper\u00e1ciu?"));
    }

    public void setProgressCancelable(boolean cancelable) {
        this.cancelable = cancelable;
        this.jCancel.setEnabled(cancelable);
    }

    public abstract void compute() throws Exception;

    private class WorkerThread
    implements Runnable {
        private Throwable exception;

        private WorkerThread() {
        }

        public Throwable getException() {
            return this.exception;
        }

        @Override
        public void run() {
            this.exception = null;
            try {
                TngProgressableWorker.this.result = null;
                TngProgressableWorker.this.compute();
            }
            catch (Throwable e2) {
                this.exception = e2;
            }
            TngProgressableWorker.this.dispose();
        }
    }
}

