/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tangram.exception.TngException;
import tangram.filter.TngFilterSet;
import tangram.library.Nat;
import tangram.library.TngOrderNamed;
import tangram.swing.TngSwing;
import tangram.swing.component.button.TngButton;
import tangram.swing.container.TngScrollPane;
import tangram.swing.mdi.TngMdiChild;
import tangram.swing.mdi.TngMdiMain;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngPanelFilter;
import tangram.swing.table.component.TngTable;
import tangram.swing.table.component.TngTablePanelCorner;
import tangram.swing.table.component.TngTablePanelKeyAdapter;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.component.TngTableRowHeader;
import tangram.swing.table.component.TngTableToolbar;
import tangram.swing.table.component.TngTableViewport;
import tangram.swing.table.export.TngTableExportPanel;
import tangram.swing.table.export.TngTableExporter;
import tangram.swing.table.model.TngTableModel;

public class TngTablePanel
extends TngPanel {
    private TngScrollPane jScrollPane = new TngScrollPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private TngTableViewport jViewPort = new TngTableViewport();
    protected TngTableToolbar jPanelToolbar;
    protected TngTable jTable;
    protected TngFilterSet filterSet;
    protected TngOrderNamed[] orderSet;
    protected JComponent upperLeftCorner;
    protected boolean selectableMode = false;
    protected boolean multiSelectEnabled;

    public void explode() {
        try {
            this.jTable = this.tableInitialize();
            this.jTable.setModel(this.modelInitialize());
            this.jTable.setRowHeader(this.rowHeaderInitialize());
            this.jPanelToolbar = this.toolbarInitialize();
            this.filterSet = this.filterInitialize();
            this.orderSet = this.orderInitialize();
            this.upperLeftCorner = this.upperLeftCornerInitialize();
            this.jbInit();
            this.listenerInit();
            this.jPanelToolbar.setTablePanel(this);
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void setSelectableMode(boolean selectableMode) {
        this.selectableMode = selectableMode;
    }

    public boolean isSelectableMode() {
        return this.selectableMode;
    }

    public void setMultiSelectEnabled(boolean multiSelectEnabled) {
        this.multiSelectEnabled = multiSelectEnabled;
    }

    public boolean isMultiSelectEnabled() {
        return this.multiSelectEnabled;
    }

    protected TngTable tableInitialize() {
        return new TngTable();
    }

    public TngTable getTable() {
        return this.jTable;
    }

    protected TngTableRowHeader rowHeaderInitialize() {
        return new TngTableRowHeader(this.jTable);
    }

    protected TngTableModel modelInitialize() {
        TngTableModel model = new TngTableModel(){

            @Override
            protected void prepareData() {
                this.countRows = 0;
            }
        };
        return model;
    }

    public TngTableModel getTableModel() {
        TngTable table = this.getTable();
        return table == null ? null : table.getTableModel();
    }

    protected TngTableToolbar toolbarInitialize() {
        return new TngTableToolbar();
    }

    protected TngFilterSet filterInitialize() {
        return null;
    }

    protected TngOrderNamed[] orderInitialize() {
        return new TngOrderNamed[0];
    }

    protected String getFilter() {
        if (this.filterSet == null) {
            return null;
        }
        return this.filterSet.createFilterExpression();
    }

    protected JComponent upperLeftCornerInitialize() {
        TngTablePanelCorner upperLeftCorner = new TngTablePanelCorner();
        upperLeftCorner.setTable(this.jTable);
        return upperLeftCorner;
    }

    public TngFilterSet getFilterSet() {
        return this.filterSet;
    }

    public TngOrderNamed[] getOrderSet() {
        return this.orderSet;
    }

    public String getTableTitle() {
        return this.getClass().getSimpleName();
    }

    public void tableRefresh() {
        this.jTable.refreshAndReset();
    }

    protected void rowSelectionChanged() {
        int count = this.jTable.getTableModel().getRowCount();
        int row = this.jTable.getSelectedRow();
        this.jPanelToolbar.setPosition(row + 1 + "/" + count);
    }

    protected void tableRowValues(TngTableRow r2) {
    }

    protected void tableInsert() {
    }

    protected void tableEdit() {
    }

    protected void tableCopy() {
    }

    protected void tableDelete() {
        this.getTable().deleteMarkedRows();
    }

    protected void tableFile() {
        TngTableExportPanel writerPanel = new TngTableExportPanel();
        writerPanel.setData(this.getTableTitle(), this.getTableModel().getColumns());
        if (!TngDlg.runModal(writerPanel, 7)) {
            return;
        }
        TngTableExporter tableExporter = writerPanel.getExporter();
        tableExporter.setTableModel(this.getTableModel());
        try {
            tableExporter.export();
            TngSwing.msgOK(Nat.x("Export \u00fadajov do s\u00faboru prebehol \u00faspe\u0161ne"));
        }
        catch (TngException e2) {
            TngSwing.msgWarning(e2.getMessage());
        }
        catch (Exception e3) {
            TngSwing.exceptionShow(Nat.x("Chyba pri exporte \u00fadajov do s\u00faboru"), e3);
        }
    }

    protected void tableOk() {
        this.dlgOkAction();
    }

    protected void tableCancel() {
        this.dlgCancelAction();
    }

    protected void tableExit() {
        Container topLevelAncestor = this.getTopLevelAncestor();
        if (topLevelAncestor instanceof TngMdiMain) {
            TngMdiMain mdiMain = (TngMdiMain)topLevelAncestor;
            JInternalFrame child = mdiMain.getActiveChild();
            if (child instanceof TngMdiChild) {
                ((TngMdiChild)child).close();
            } else {
                mdiMain.closeChild(child);
            }
        }
    }

    public boolean openFilter() {
        TngSwing.msgWarning(Nat.x("Oper\u00e1cia usporiadania a filtrovania nie je dostupn\u00e1"));
        return false;
    }

    protected TngPanelFilter createPanelFilter() {
        return null;
    }

    protected void tableFilter() {
        if (this.openFilter()) {
            this.tableRefresh();
        }
    }

    protected void listenerInit() {
        this.jTable.addKeyListener(new TngTablePanelKeyAdapter(this));
        this.jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting()) {
                    TngTablePanel.this.rowSelectionChanged();
                }
            }
        });
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    if (TngTablePanel.this.isSelectableMode()) {
                        TngTablePanel.this.doToolbarButtonAction(12);
                    } else {
                        TngTablePanel.this.doToolbarButtonAction(2);
                    }
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.jScrollPane.setViewport(this.jViewPort);
        this.jScrollPane.setViewportView(this.jTable);
        this.jScrollPane.setRowHeaderView(this.jTable.getRowHeader());
        this.jScrollPane.setCorner("UPPER_LEFT_CORNER", this.upperLeftCorner);
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(1039, 300));
        this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.jPanelToolbar, "North");
        this.add((Component)this.jScrollPane, "Center");
        this.setFocusable(false);
        this.jTable.setFocusable(true);
        TngSwing.setOptimalSize(this);
    }

    @Override
    public void doAfterShow() {
        this.jPanelToolbar.resolveCloseButton();
    }

    public boolean doToolbarButtonAction(int actionId) {
        TngButton b2 = this.jPanelToolbar.getButton(actionId);
        if (b2 == null) {
            TngSwing.msgWarning(Nat.x("Oper\u00e1cia nad nedefinovan\u00fdm tla\u010didlom %1", actionId));
            return false;
        }
        if (b2.isVisible() && b2.isEnabled()) {
            b2.doClick();
            return true;
        }
        return false;
    }

    public void requestTableFocus() {
        this.jTable.requestFocusInWindow();
    }
}

