/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Point;
import tangram.filter.TngFilterSet;
import tangram.filter.item.TngFilterItemDate;
import tangram.filter.item.TngFilterItemString;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngOrderNamed;
import tangram.swing.TngSwing;
import tangram.swing.panel.TngPanelForm;
import tangram.swing.panel.TngPanelFormSqlUni;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableColumnSql;
import tangram.swing.table.component.TngTablePanelSqlLink;
import tangram.swing.table.component.TngTableToolbarSql;
import tangram.swing.table.model.TngTableModelSql;
import tangram.swing.table.visualizer.TngTableVisualizer;
import tangram.swing.table.visualizer.TngTableVisualizerDate;

public class TngTablePanelSqlLinkUni
extends TngTablePanelSqlLink {
    protected TngConnection conn;
    protected String tableName;
    protected Point columnsSize;

    public TngTablePanelSqlLinkUni() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void setConnection(TngConnection conn) {
        this.conn = conn;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName.toUpperCase();
    }

    public void setColumnsSize(Point columnsSize) {
        this.columnsSize = columnsSize;
    }

    private void jbInit() throws Exception {
    }

    @Override
    public TngTableModelSql modelInitialize() {
        TngTableModelSql model = new TngTableModelSql();
        int extColumnsSize = this.extendedColumns == null ? 0 : this.extendedColumns.length;
        TngTableColumn[] c2 = new TngTableColumn[6 + extColumnsSize];
        c2[0] = new TngTableColumnSql(Nat.x("K\u00f3d"), this.tableName + ".XX");
        c2[1] = new TngTableColumnSql(Nat.x("N\u00e1zov"), this.tableName + ".NAZOV");
        for (int i2 = 0; i2 < extColumnsSize; ++i2) {
            c2[2 + i2] = this.extendedColumns[i2];
        }
        c2[2 + extColumnsSize] = new TngTableColumnSql(Nat.x("Vlo\u017eil"), this.tableName + ".XIO");
        c2[3 + extColumnsSize] = new TngTableColumnSql(Nat.x("Vlo\u017een\u00e9 d\u0148a"), this.tableName + ".XID", (TngTableVisualizer)new TngTableVisualizerDate());
        c2[4 + extColumnsSize] = new TngTableColumnSql(Nat.x("Zmenil"), this.tableName + ".XUO");
        c2[5 + extColumnsSize] = new TngTableColumnSql(Nat.x("Zmenen\u00e9 d\u0148a"), this.tableName + ".XUD", (TngTableVisualizer)new TngTableVisualizerDate());
        model.setConnection(this.conn);
        model.setColumns(c2);
        model.setSqlTables(this.tableName);
        model.setSqlOrder(this.tableName + ".XX ASC");
        return model;
    }

    @Override
    protected TngTableToolbarSql toolbarInitialize() {
        if (this.columnsSize == null) {
            return super.toolbarInitialize();
        }
        return new TngTableToolbarSql();
    }

    @Override
    public TngFilterSet filterInitialize() {
        TngFilterSet f2 = new TngFilterSet();
        f2.setLabel(this.getTitle() + " - " + Nat.x("filter"));
        f2.add(new TngFilterItemString(this.tableName + ".XX", Nat.x("K\u00f3d"), false));
        f2.add(new TngFilterItemString(this.tableName + ".NAZOV", Nat.x("N\u00e1zov"), false));
        f2.add(new TngFilterItemString(this.tableName + ".XIO", Nat.x("Vlo\u017eil"), false));
        f2.add(new TngFilterItemDate(this.tableName + ".XID", Nat.x("D\u00e1tum vlo\u017eenia")));
        f2.add(new TngFilterItemString(this.tableName + ".XUO", Nat.x("Zmenil"), false));
        f2.add(new TngFilterItemDate(this.tableName + ".XUD", Nat.x("D\u00e1tum zmeny")));
        return f2;
    }

    @Override
    protected TngOrderNamed[] orderInitialize() {
        TngOrderNamed[] orderSet = new TngOrderNamed[]{new TngOrderNamed(Nat.x("K\u00f3d"), this.tableName + ".XX ASC"), new TngOrderNamed(Nat.x("N\u00e1zov"), this.tableName + ".NAZOV ASC")};
        return orderSet;
    }

    @Override
    protected TngPanelForm createPanelForm() {
        if (this.columnsSize == null) {
            return super.createPanelForm();
        }
        TngPanelFormSqlUni form = new TngPanelFormSqlUni();
        form.setData(this.conn, this.tableName, this.columnsSize);
        return form;
    }

    @Override
    public String[] getRowIndexValues() {
        int row = this.getTable().getSelectedRow();
        String key = this.getTable().getColumnValueAsString(row, this.getTableModel().getColumnPosition(this.tableName + ".XX"));
        return new String[]{key};
    }
}

