/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Color;

public class TngTableRow {
    public int irow;
    public Object editId;
    public boolean inserted;
    public boolean updated;
    public boolean deleted;
    public boolean valuesLoaded;
    public boolean valuesLoadedAsync;
    public Color foregroundColor;
    public Object[] values;
    public static final int ROW_STATUS_DELETED = 3;
    public static final int ROW_STATUS_UPDATED = 2;
    public static final int ROW_STATUS_INSERTED = 1;
    public static final int ROW_STATUS_NONE = 0;

    public TngTableRow(int irow, int columns) {
        this.irow = irow;
        this.values = new Object[columns];
    }

    public void clearValues() {
        if (this.values != null) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2] = null;
            }
        }
    }

    public void clearForegroundColor() {
        this.foregroundColor = null;
    }

    public int getInternalRow() {
        return this.irow;
    }

    public boolean isInserted() {
        if (this.deleted || this.updated) {
            return false;
        }
        return this.inserted;
    }

    public boolean isUpdated() {
        if (this.deleted) {
            return false;
        }
        return this.updated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isUnedited() {
        return !this.inserted && !this.updated && !this.deleted;
    }

    public boolean hasFlagInserted() {
        return this.inserted;
    }

    public boolean hasFlagUpdated() {
        return this.updated;
    }

    public boolean hasFlagDeleted() {
        return this.deleted;
    }

    public int getMainEditedStatus() {
        if (this.deleted) {
            return 3;
        }
        if (this.updated) {
            return 2;
        }
        if (this.inserted) {
            return 1;
        }
        return 0;
    }
}

