/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.TngWaiter;
import tangram.swing.component.TngLabel;
import tangram.swing.component.button.TngButton;
import tangram.swing.component.button.TngButtonToolbar;
import tangram.swing.icon.TngIcon;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.table.component.TngTable;
import tangram.swing.table.component.TngTablePanel;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.model.TngTableModel;

public class TngTableToolbar
extends TngPanel {
    private TngTablePanel tablePanel;
    private LinkedHashMap<Integer, TngButton> buttons = new LinkedHashMap();
    private TngLabel jPosition = new TngLabel();
    private int bCount = 0;
    public static final int B_INSERT = 1;
    public static final int B_UPDATE = 2;
    public static final int B_COPY = 3;
    public static final int B_MARK_DEL = 4;
    public static final int B_DELETE = 5;
    public static final int B_REFRESH = 6;
    public static final int B_FILTER = 7;
    public static final int B_FILE_WRITE = 8;
    public static final int B_COLS_RESIZE = 9;
    public static final int B_MARK_SEL = 10;
    public static final int B_EXIT = 11;
    public static final int B_OK = 12;
    public static final int B_CANCEL = 13;
    public static final int FIRST_USER_BUTTON = 100;
    private int pc = 100;

    public TngTableToolbar() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setTablePanel(TngTablePanel tablePanel) {
        this.tablePanel = tablePanel;
        this.resolveButtons();
    }

    public TngTablePanel getTablePanel() {
        return this.tablePanel;
    }

    protected void resolveButtons() {
        TngButton bOk;
        boolean isSelectableMode = this.tablePanel.isSelectableMode();
        bOk.setVisible((bOk = this.getButton(12)).isVisible() && isSelectableMode);
        TngButton bCancel = this.getButton(13);
        bCancel.setVisible(bCancel.isVisible() && isSelectableMode);
        TngButton bExit = this.getButton(11);
        bExit.setVisible(bExit.isVisible() && !isSelectableMode);
        if (isSelectableMode) {
            TngButton bUpdate = this.getButton(2);
            bUpdate.setToolTipText("Oprava riadka <Ctrl+Enter>");
        }
    }

    public void resolveCloseButton() {
        TngDlg panelDlg;
        TngTablePanel panel;
        boolean isSelectableMode = this.tablePanel.isSelectableMode();
        TngButton bCancel = this.getButton(13);
        if (bCancel.isVisible() && isSelectableMode && (panel = this.getTablePanel()) != null && (panelDlg = panel.getPanelDlgParent()) != null) {
            panelDlg.setCloseButton(bCancel);
        }
    }

    public void setPosition(String position) {
        this.jPosition.setText(position);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(0, 38));
        TngButtonToolbar b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Pridanie riadka") + " <Insert>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableInsert();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/insert.png"));
        this.putButton(1, b2);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Oprava riadka") + " <Enter>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableEdit();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/update.png"));
        this.putButton(2, b2);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Kop\u00edrovanie riadka") + " <+>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableCopy();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/copy.png"));
        this.putButton(3, b2);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Ozna\u010denie riadka na zmazanie") + " <Del>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.getTable().markRowDelete();
                TngTableToolbar.this.tablePanel.getTable().toNextRow();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/mark_del.png"));
        this.putButton(4, b2);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Zmazanie ozna\u010den\u00fdch riadkov") + " <Ctrl+Del>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableDelete();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/delete.png"));
        this.putButton(5, b2, 12);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Obnovenie obsahu obrazovky") + " <F9>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableRefresh();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/refresh.png"));
        this.putButton(6, b2);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("V\u00fdberov\u00e1 podmienka a \u010fal\u0161ie parametre") + " <F5>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableFilter();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/filter.png"));
        this.putButton(7, b2, 12);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Z\u00e1pis do s\u00faboru") + " <F10>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableFile();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/file_write.png"));
        this.putButton(8, b2, 12);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Nastavenie \u0161\u00edrky st\u013apcov") + " <F6>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.getTable().tableAutoresizeVisible(true);
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/cols_resize.png"));
        this.putButton(9, b2);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Ozna\u010denie riadka") + " <" + Nat.x("medzern\u00edk") + ">");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.getTable().markRowSelect();
                TngTableToolbar.this.tablePanel.getTable().toNextRow();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/mark_sel.png"));
        this.putButton(10, b2, 12);
        this.createUserButtons();
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Koniec") + " <Esc>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableExit();
            }
        });
        b2.setIcon(TngIcon.getIcon("toolbar/exit.png"));
        this.putButton(11, b2, 12);
        this.jPosition.setHorizontalAlignment(2);
        this.add((Component)this.jPosition, new GridBagConstraints(this.bCount++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Potvrdenie v\u00fdberu") + " <F2 " + Nat.x("alebo") + " Enter>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableOk();
            }
        });
        b2.setIcon(TngIcon.getIcon("ok.png"));
        this.putButton(12, b2);
        b2 = new TngButtonToolbar();
        b2.setToolTipText(Nat.x("Zru\u0161enie v\u00fdberu") + " <Esc>");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.tableCancel();
            }
        });
        b2.setIcon(TngIcon.getIcon("cancel.png"));
        this.putButton(13, b2, 12);
    }

    protected void createUserButtons() {
    }

    protected void addUserButton(TngButton button) {
        this.addUserButton(button, 0);
    }

    protected void addUserButton(TngButton button, int hSpace) {
        this.putButton(this.pc++, button, hSpace);
    }

    private void putButton(int pc, TngButton button) {
        this.putButton(pc, button, 0);
    }

    private void putButton(int pc, TngButton button, int hSpace) {
        this.buttons.put(pc, button);
        this.add((Component)button, new GridBagConstraints(this.bCount++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, hSpace), 0, 0));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableToolbar.this.tablePanel.requestTableFocus();
            }
        });
    }

    public void addLegend(JComponent legend) {
        this.addLegend(legend, 0);
    }

    public void addLegend(JComponent legend, int hSpace) {
        this.add((Component)legend, new GridBagConstraints(this.bCount++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, hSpace), 0, 0));
    }

    public TngButton getButton(int buttonId) {
        return this.buttons.get(buttonId);
    }

    public String getSelectedRowValue(int column) {
        if (!this.isRowSelected()) {
            return null;
        }
        int selRow = this.getSelectedRowIndex();
        TngTable table = this.tablePanel.getTable();
        String value = table.getColumnValueAsString(selRow, column);
        if (TngUtilities.isEmpty(value)) {
            TngSwing.msgWarning(Nat.x("Z\u00e1znam bol medzi\u010dasom zmenen\u00fd alebo zmazan\u00fd"));
        }
        return value == null ? null : value.toString();
    }

    public int getSelectedRowIndex() {
        TngTable table = this.tablePanel.getTable();
        return table.getSelectedRow();
    }

    public boolean isRowSelected() {
        TngTableModel model = this.tablePanel.getTableModel();
        int selRow = this.getSelectedRowIndex();
        if (selRow < 0 || selRow >= model.getRowCount()) {
            TngSwing.msgWarning(Nat.x("Nebol zvolen\u00fd \u017eiaden riadok tabu\u013eky"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<Integer, String> getSelectedRowsValues(int primaryColumnIndex) {
        LinkedHashMap<Integer, String> values = new LinkedHashMap<Integer, String>();
        try {
            TngWaiter.start(this);
            TngTableModel model = this.tablePanel.getTableModel();
            Iterator<Integer> iter = model.getIteratorMarkSelect();
            while (iter.hasNext()) {
                int ir = iter.next();
                int row = model.getTabularRow(ir);
                TngTableRow r2 = model.getRow(row);
                if (r2.isDeleted()) continue;
                Object value = model.getObject(row, primaryColumnIndex);
                values.put(row, value == null ? null : value.toString());
            }
        }
        finally {
            TngWaiter.stop(this);
        }
        return values;
    }
}

