/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import tangram.library.Nat;
import tangram.library.TngOrder;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.component.TngLabel;
import tangram.swing.component.TngList;
import tangram.swing.component.TngListRendererCell;
import tangram.swing.component.button.TngButton;
import tangram.swing.container.TngScrollPane;
import tangram.swing.icon.TngIcon;
import tangram.swing.panel.TngPanel;
import tangram.swing.table.component.TngTableColumn;

public class TngTableExportPanelColumns
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabel1 = new TngLabel();
    private TngLabel jLabel2 = new TngLabel();
    private TngScrollPane jScrollPane1 = new TngScrollPane();
    private TngScrollPane jScrollPane2 = new TngScrollPane();
    private TngList jUnusedColumns = new TngList();
    private TngList jExportedColumns = new TngList();
    private JPanel jPanel1 = new JPanel();
    private TngButton jAdd = new TngButton();
    private TngButton jDelete = new TngButton();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JPanel jPanel2 = new JPanel();
    private TngButton jTop = new TngButton();
    private TngButton jUp = new TngButton();
    private TngButton jDown = new TngButton();
    private TngButton jBottom = new TngButton();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private TngTableColumn[] allColumns;
    private List<String> exportedColumns;
    private DefaultListModel mdExportedColumns = new DefaultListModel();
    private DefaultListModel mdUnusedColumns = new DefaultListModel();

    public TngTableExportPanelColumns() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(635, 453));
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(635, 280));
        this.setTitle(Nat.x("Konfigur\u00e1cia exportovan\u00fdch st\u013apcov"));
        this.jLabel1.setText(Nat.x("Dostupn\u00e9 st\u013apce"));
        this.jLabel1.setLabelFor(this.jUnusedColumns);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel2.setText(Nat.x("Exportovan\u00e9 st\u013apce"));
        this.jLabel2.setLabelFor(this.jExportedColumns);
        this.jLabel2.setHorizontalAlignment(2);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 130));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 130));
        this.jUnusedColumns.setSelectionMode(2);
        this.jUnusedColumns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TngTableExportPanelColumns.this.jUnusedColumns_mouseClicked(e2);
            }
        });
        this.jExportedColumns.setSelectionMode(2);
        this.jExportedColumns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TngTableExportPanelColumns.this.jExportedOrder_mouseClicked(e2);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jAdd.setMargin(new Insets(0, 0, 0, 0));
        this.jAdd.setToolTipText(Nat.x("Prida\u0165"));
        this.jAdd.setText("M");
        this.jAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableExportPanelColumns.this.jAdd_actionPerformed(e2);
            }
        });
        this.jDelete.setMargin(new Insets(0, 0, 0, 0));
        this.jDelete.setToolTipText(Nat.x("Odobra\u0165"));
        this.jDelete.setText("M");
        this.jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableExportPanelColumns.this.jDelete_actionPerformed(e2);
            }
        });
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.jTop.setMargin(new Insets(0, 0, 0, 0));
        this.jTop.setToolTipText(Nat.x("Presun\u00fa\u0165 na za\u010diatok"));
        this.jTop.setText("M");
        this.jTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableExportPanelColumns.this.jFirst_actionPerformed(e2);
            }
        });
        this.jUp.setMargin(new Insets(0, 0, 0, 0));
        this.jUp.setToolTipText(Nat.x("Posun\u00fa\u0165 hore"));
        this.jUp.setText("M");
        this.jUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableExportPanelColumns.this.jUp_actionPerformed(e2);
            }
        });
        this.jDown.setMargin(new Insets(0, 0, 0, 0));
        this.jDown.setToolTipText(Nat.x("Posun\u00fa\u0165 dole"));
        this.jDown.setText("M");
        this.jDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableExportPanelColumns.this.jDown_actionPerformed(e2);
            }
        });
        this.jBottom.setMargin(new Insets(0, 0, 0, 0));
        this.jBottom.setToolTipText(Nat.x("Presun\u00fa\u0165 na koniec"));
        this.jBottom.setText("M");
        this.jBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTableExportPanelColumns.this.jLast_actionPerformed(e2);
            }
        });
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jUnusedColumns, null);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane2.getViewport().add((Component)this.jExportedColumns, null);
        this.add((Component)this.jScrollPane2, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jDelete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.jPanel2.add((Component)this.jTop, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jUp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jDown, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jBottom, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.changeButton(this.jAdd, "shift_right.png");
        this.changeButton(this.jDelete, "shift_left.png");
        this.changeButton(this.jTop, "arrow_top.png");
        this.changeButton(this.jUp, "arrow_up.png");
        this.changeButton(this.jDown, "arrow_down.png");
        this.changeButton(this.jBottom, "arrow_bottom.png");
        this.jUnusedColumns.setCellRenderer(new AscendingCellRenderer());
        this.jExportedColumns.setCellRenderer(new AscendingCellRenderer());
    }

    private void changeButton(TngButton c2, String icon) {
        c2.setIcon(TngIcon.getIcon(icon));
        c2.setText(null);
    }

    public void setData(TngTableColumn[] allColumns, List<String> exportedColumns) {
        this.allColumns = allColumns == null ? new TngTableColumn[]{} : allColumns;
        this.exportedColumns = exportedColumns == null ? new ArrayList() : exportedColumns;
        this.setUnusedColumns();
        this.setExportedColumns();
    }

    private void setUnusedColumns() {
        this.jUnusedColumns.setModel(this.mdUnusedColumns);
        this.mdUnusedColumns.clear();
        for (TngTableColumn column : this.allColumns) {
            TngOrder o2 = new TngOrder(column.name, column.title);
            this.mdUnusedColumns.addElement(o2);
        }
        this.selectAndScroll(this.jUnusedColumns, 0);
    }

    private void setExportedColumns() {
        this.jExportedColumns.setModel(this.mdExportedColumns);
        this.mdExportedColumns.clear();
        for (String exportedColumn : this.exportedColumns) {
            this.exportedColumnAdd(exportedColumn);
        }
        this.selectAndScroll(this.jUnusedColumns, 0);
        this.selectAndScroll(this.jExportedColumns, 0);
    }

    private void exportedColumnAdd(String exportedColumnName) {
        for (int i2 = 0; i2 < this.mdUnusedColumns.getSize(); ++i2) {
            TngOrder o2 = (TngOrder)this.mdUnusedColumns.getElementAt(i2);
            if (!o2.name.equals(exportedColumnName)) continue;
            this.mdExportedColumns.addElement(o2);
            this.mdUnusedColumns.removeElementAt(i2);
            break;
        }
    }

    public List<String> getExportedColumns() {
        ArrayList<String> exportedColumns = new ArrayList<String>();
        for (int i2 = 0; i2 < this.mdExportedColumns.getSize(); ++i2) {
            TngOrder o2 = (TngOrder)this.mdExportedColumns.getElementAt(i2);
            exportedColumns.add(o2.name);
        }
        return exportedColumns;
    }

    private void exportedColumnsDeleteSelected() {
        int i2;
        int a2 = this.jExportedColumns.getMinSelectionIndex();
        int b2 = this.jExportedColumns.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        for (i2 = a2; i2 <= b2; ++i2) {
            if (!this.jExportedColumns.isSelectedIndex(i2)) continue;
            TngOrder o2 = (TngOrder)this.mdExportedColumns.getElementAt(i2);
            this.mdUnusedColumns.addElement(o2);
        }
        for (i2 = b2; i2 >= a2; --i2) {
            if (!this.jExportedColumns.isSelectedIndex(i2)) continue;
            this.mdExportedColumns.removeElementAt(i2);
        }
        this.selectAndScroll(this.jUnusedColumns, this.mdUnusedColumns.getSize() - 1);
        this.selectAndScroll(this.jExportedColumns, Math.min(a2, this.mdExportedColumns.getSize() - 1));
    }

    private void exportedColumnsAddSelected() {
        int i2;
        int a2 = this.jUnusedColumns.getMinSelectionIndex();
        int b2 = this.jUnusedColumns.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        for (i2 = a2; i2 <= b2; ++i2) {
            if (!this.jUnusedColumns.isSelectedIndex(i2)) continue;
            TngOrder o2 = (TngOrder)this.mdUnusedColumns.getElementAt(i2);
            this.mdExportedColumns.addElement(o2);
        }
        for (i2 = b2; i2 >= a2; --i2) {
            if (!this.jUnusedColumns.isSelectedIndex(i2)) continue;
            this.mdUnusedColumns.removeElementAt(i2);
        }
        this.selectAndScroll(this.jUnusedColumns, Math.min(a2, this.mdUnusedColumns.getSize() - 1));
        this.selectAndScroll(this.jExportedColumns, this.mdExportedColumns.getSize() - 1);
    }

    private void orderShiftSelectedUp(int shift) {
        if (shift == 0) {
            return;
        }
        int a2 = this.jExportedColumns.getMinSelectionIndex();
        int b2 = this.jExportedColumns.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        if (a2 == 0) {
            return;
        }
        if (shift < 0) {
            shift = a2;
        }
        for (int i2 = a2; i2 <= b2; ++i2) {
            if (!this.jExportedColumns.isSelectedIndex(i2)) continue;
            this.moveElement(this.mdExportedColumns, i2, i2 - shift);
            this.jExportedColumns.addSelectionInterval(i2 - shift, i2 - shift);
        }
        int v = a2 - shift - 1;
        if (v < 0) {
            v = 0;
        }
        this.jExportedColumns.ensureIndexIsVisible(v);
    }

    private void orderShiftSelectedDown(int shift) {
        if (shift == 0) {
            return;
        }
        int a2 = this.jExportedColumns.getMinSelectionIndex();
        int b2 = this.jExportedColumns.getMaxSelectionIndex();
        if (a2 < 0 || b2 < 0) {
            return;
        }
        if (b2 == this.mdExportedColumns.getSize() - 1) {
            return;
        }
        if (shift < 0) {
            shift = this.mdExportedColumns.getSize() - b2 - 1;
        }
        for (int i2 = b2; i2 >= a2; --i2) {
            if (!this.jExportedColumns.isSelectedIndex(i2)) continue;
            this.moveElement(this.mdExportedColumns, i2, i2 + shift);
            this.jExportedColumns.addSelectionInterval(i2 + shift, i2 + shift);
        }
        int v = b2 + shift + 1;
        if (v >= this.mdExportedColumns.getSize()) {
            v = this.mdExportedColumns.getSize() - 1;
        }
        this.jExportedColumns.ensureIndexIsVisible(v);
    }

    private void moveElement(DefaultListModel m2, int from, int to) {
        if (m2 == null || from == to) {
            return;
        }
        if (from < 0 || to < 0 || from >= m2.getSize() || to >= m2.getSize()) {
            return;
        }
        Object o2 = m2.getElementAt(from);
        m2.removeElementAt(from);
        m2.insertElementAt(o2, to);
    }

    private void selectAndScroll(TngList list, int index) {
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    private void jAdd_actionPerformed(ActionEvent e2) {
        this.exportedColumnsAddSelected();
    }

    private void jDelete_actionPerformed(ActionEvent e2) {
        this.exportedColumnsDeleteSelected();
    }

    private void jUnusedColumns_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() == 2) {
            this.exportedColumnsAddSelected();
        }
    }

    private void jExportedOrder_mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() == 2) {
            this.exportedColumnsDeleteSelected();
        }
    }

    private void jFirst_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedUp(-1);
    }

    private void jUp_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedUp(1);
    }

    private void jDown_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedDown(1);
    }

    private void jLast_actionPerformed(ActionEvent e2) {
        this.orderShiftSelectedDown(-1);
    }

    @Override
    public String getCustomText() {
        return Nat.x("Obnovi\u0165");
    }

    @Override
    public boolean doBeforeShow() {
        this.selectAndScroll(this.jUnusedColumns, 0);
        this.selectAndScroll(this.jExportedColumns, 0);
        return true;
    }

    @Override
    public void doValidate(TngValidationError errors) {
        if (this.mdExportedColumns.getSize() == 0) {
            errors.addError(this.jUnusedColumns, Nat.x("Vyberte exportovan\u00e9 st\u013apce zo zoznamu dostupn\u00fdch st\u013apcov"));
        }
    }

    @Override
    public boolean doCustom() {
        this.mdUnusedColumns.clear();
        this.mdExportedColumns.clear();
        for (TngTableColumn column : this.allColumns) {
            TngOrder o2 = new TngOrder(column.name, column.title);
            this.mdExportedColumns.addElement(o2);
        }
        this.selectAndScroll(this.jExportedColumns, 0);
        return false;
    }

    class AscendingCellRenderer
    extends TngListRendererCell {
        AscendingCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            TngOrder o2 = (TngOrder)value;
            this.setText(o2.title);
            this.setHorizontalAlignment(2);
            return this;
        }
    }
}

