/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.awt.Dimension;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import tangram.library.TngUtilities;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.export.TngTableExporter;
import tangram.swing.table.export.TngTableExporterColumn;

public class TngTableExporterXML
extends TngTableExporter {
    private List<XmlColumn> xmlColumns = new ArrayList<XmlColumn>();
    private OutputStream outputStream;
    private ContentHandler xmlContentHandler;

    @Override
    protected void processBefore() throws Exception {
        this.loadXmlColumns();
        this.createXmlWriter();
        this.writeXmlHeader();
    }

    @Override
    protected void processTableRowValues(String[] transformedTableRowValues) throws Exception {
        AttributesImpl atts = new AttributesImpl();
        this.xmlContentHandler.startElement("", "", "DATA_ROW", atts);
        for (int col = 0; col < transformedTableRowValues.length; ++col) {
            XmlColumn xmlColumn = this.xmlColumns.get(col);
            String value = transformedTableRowValues[col];
            this.xmlContentHandler.startElement("", "", xmlColumn.getName(), atts);
            if (TngUtilities.isEmpty(value)) {
                this.xmlContentHandler.characters("".toCharArray(), 0, 0);
            } else {
                this.xmlContentHandler.characters(value.toCharArray(), 0, value.length());
            }
            this.xmlContentHandler.endElement("", "", xmlColumn.getName());
        }
        this.xmlContentHandler.endElement("", "", "DATA_ROW");
    }

    @Override
    protected String transformTableRowValue(TngTableColumn tableColumn, String tableRowValue) throws Exception {
        if (TngUtilities.isEmpty(tableRowValue)) {
            return "";
        }
        return tableRowValue.replace('\"', ' ');
    }

    @Override
    protected void processAfter() throws Exception {
        this.xmlContentHandler.endElement("", "", "DATA");
        this.xmlContentHandler.endElement("", "", "TABLE");
        this.xmlContentHandler.endDocument();
        TngUtilities.streamCloseSafe(this.outputStream);
    }

    private void loadXmlColumns() throws Exception {
        TngTableColumn[] usedTableColumns;
        this.xmlColumns.clear();
        for (TngTableColumn usedTableColumn : usedTableColumns = this.getUsedTableColumns()) {
            XmlColumn xmlColumn = new XmlColumn();
            xmlColumn.resolveColumn(usedTableColumn);
            this.xmlColumns.add(xmlColumn);
        }
    }

    private void createXmlWriter() throws Exception {
        this.outputStream = new FileOutputStream(this.getFile());
        OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", true);
        outputFormat.setIndent(1);
        outputFormat.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(this.outputStream, outputFormat);
        this.xmlContentHandler = serializer.asContentHandler();
    }

    private void writeXmlHeader() throws Exception {
        this.xmlContentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        this.xmlContentHandler.startElement("", "", "TABLE", atts);
        this.xmlContentHandler.startElement("", "", "STRUCTURE", atts);
        for (XmlColumn xmlColumn : this.xmlColumns) {
            atts.clear();
            atts.addAttribute("", "", "TYPE", "CDATA", xmlColumn.getTypeAsString());
            atts.addAttribute("", "", "PRECISION", "CDATA", String.valueOf(xmlColumn.getPrecision()));
            atts.addAttribute("", "", "SCALE", "CDATA", String.valueOf(xmlColumn.getScale()));
            this.xmlContentHandler.startElement("", "", xmlColumn.getName(), atts);
            this.xmlContentHandler.endElement("", "", xmlColumn.getName());
        }
        this.xmlContentHandler.endElement("", "", "STRUCTURE");
        atts.clear();
        this.xmlContentHandler.startElement("", "", "DATA", atts);
    }

    private class XmlColumn
    extends TngTableExporterColumn {
        private XmlColumn() {
        }

        @Override
        protected void resolveName() {
            this.name = this.tableColumn.title.toUpperCase();
            this.name = this.name.replace(" ", "_");
        }

        @Override
        protected void resolveDimension() {
            Dimension dim = TngTableExporterXML.this.resolveDimensionByModel(this.tableColumn);
            this.precision = dim.width;
            this.scale = dim.height;
        }

        private String getTypeAsString() {
            return this.tableColumn.type.toString();
        }
    }
}

