/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.model;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import tangram.library.Nat;
import tangram.swing.TngSwing;
import tangram.swing.icon.TngIcon;
import tangram.swing.table.component.TngTable;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.model.TngTableModelAsyncLoader;

public abstract class TngTableModel
extends AbstractTableModel {
    protected int countColumns;
    protected int countRows;
    protected int countInserted;
    protected int countUpdated;
    protected int countErased;
    private boolean markUnorderedColumn;
    protected TngTableColumn[] columns;
    private boolean columnsChanged;
    private int cacheRowsSize = 150;
    private TngTableRow[] cacheRows;
    private Hashtable<Integer, TngTableRow> cacheEdited;
    private HashSet<Integer> cacheMarkDelete;
    private HashSet<Integer> cacheMarkSelect;
    private boolean asyncLoad;
    private TngTableModelAsyncLoader asyncLoader = new TngTableModelAsyncLoader(this);
    private static ImageIcon iconOrderUp = TngIcon.getIcon("order_up.png");
    private static ImageIcon iconOrderDown = TngIcon.getIcon("order_down.png");
    private static ImageIcon iconOrderDisable = TngIcon.getIcon("cancel.png");
    private int lastMarkDeleteIR;
    private int lastMarkDelete;
    private int lastMarkSelectIR;
    private int lastMarkSelect;
    private TngTableRow lastEditedRow;
    private TngTableRow lastRow;
    private int lastIndex;

    public TngTableModel() {
        this.cacheEdited = new Hashtable();
        this.cacheMarkDelete = new HashSet();
        this.cacheMarkSelect = new HashSet();
    }

    public void close() {
        this.asyncLoader.close();
    }

    public String toString() {
        String h2 = Nat.x("Po\u010det st\u013apcov:") + " " + this.countColumns + "\n";
        h2 = h2 + Nat.x("Po\u010det riadkov:") + " " + this.countRows + "\n";
        h2 = h2 + Nat.x("Po\u010det vlo\u017een\u00fdch riadkov:") + " " + this.getCountInserted() + "\n";
        h2 = h2 + Nat.x("Po\u010det zmenen\u00fdch riadkov:") + " " + this.getCountUpdated() + "\n";
        h2 = h2 + Nat.x("Po\u010det zmazan\u00fdch riadkov:") + " " + this.getCountErased() + "\n";
        h2 = h2 + Nat.x("Po\u010det modifikovan\u00fdch riadkov:") + " " + this.getCountEdited() + "\n";
        h2 = h2 + Nat.x("Po\u010det riadkov na zmazanie:") + " " + this.getCountMarkDelete() + "\n";
        h2 = h2 + Nat.x("Po\u010det ozna\u010den\u00fdch riadkov:") + " " + this.getCountMarkSelect() + "\n";
        h2 = h2 + Nat.x("Po\u010det riadkov v cache:") + " " + this.getCacheRowsSize() + "\n";
        h2 = h2 + Nat.x("Asynchr\u00f3nne do\u010d\u00edtavanie \u00fadajov:") + " " + (this.asyncLoad ? Nat.x("\u00c1no") : Nat.x("Nie"));
        return h2;
    }

    public String getInfo() {
        return this.toString();
    }

    public int getCountInserted() {
        return this.countInserted;
    }

    public int getCountUpdated() {
        return this.countUpdated;
    }

    public int getCountErased() {
        return this.countErased;
    }

    public int getCountEdited() {
        return this.cacheEdited.size();
    }

    public int getCacheRowsSize() {
        return this.cacheRowsSize;
    }

    public void setCacheRowsSize(int cacheRowsSize) {
        if (cacheRowsSize <= 0) {
            throw new IllegalArgumentException("Cache size is invalid");
        }
        this.cacheRowsSize = cacheRowsSize;
    }

    public boolean isAsyncLoad() {
        return this.asyncLoad;
    }

    public void setAsyncLoad(boolean loadValuesAsync) {
        this.asyncLoad = loadValuesAsync;
    }

    public boolean getMarkUnorderedColumn() {
        return this.markUnorderedColumn;
    }

    public void setMarkUnorderedColumn(boolean markUnorderedColumn) {
        this.markUnorderedColumn = markUnorderedColumn;
    }

    public int getCountMarkDelete() {
        return this.cacheMarkDelete.size();
    }

    public boolean hasRowMarkDelete(int row) {
        return this.getRowMarkDeleteIR(this.getInternalRow(row));
    }

    public void setRowMarkDetete(int row) {
        int ir = this.getInternalRow(row);
        this.setRowMarkDeleteIR(ir, true);
        this.fireTableRowsUpdated(row, row);
    }

    public void clearRowMarkDelete(int row, int mark) {
        int ir = this.getInternalRow(row);
        this.setRowMarkDeleteIR(ir, false);
        this.fireTableRowsUpdated(row, row);
    }

    public void changeRowMarkDelete(int row) {
        int ir = this.getInternalRow(row);
        boolean mark = !this.getRowMarkDeleteIR(ir);
        this.setRowMarkDeleteIR(ir, mark);
        this.fireTableRowsUpdated(row, row);
    }

    public Iterator<Integer> getIteratorMarkDelete() {
        return this.cacheMarkDelete.iterator();
    }

    public void clearMarkDeleteFromIterator(Iterator iter, int irow) {
        int row = this.getTabularRow(irow);
        this.clearRowMarkDelete(iter, irow);
        this.fireTableRowsUpdated(row, row);
    }

    public int getCountMarkSelect() {
        return this.cacheMarkSelect.size();
    }

    public boolean hasRowMarkSelect(int row) {
        return this.getRowMarkSelectIR(this.getInternalRow(row));
    }

    public void setRowMarkSelect(int row) {
        int ir = this.getInternalRow(row);
        this.setRowMarkSelectIR(ir, true);
        this.fireTableRowsUpdated(row, row);
    }

    public void clearRowMarkSelect(int row, int mark) {
        int ir = this.getInternalRow(row);
        this.setRowMarkSelectIR(ir, false);
        this.fireTableRowsUpdated(row, row);
    }

    public void changeRowMarkSelect(int row) {
        int ir = this.getInternalRow(row);
        boolean mark = !this.getRowMarkSelectIR(ir);
        this.setRowMarkSelectIR(ir, mark);
        this.fireTableRowsUpdated(row, row);
    }

    public Iterator<Integer> getIteratorMarkSelect() {
        return this.cacheMarkSelect.iterator();
    }

    public void clearMarkSelectFromIterator(Iterator iter, int irow) {
        int row = this.getTabularRow(irow);
        this.clearRowMarkSelect(iter, irow);
        this.fireTableRowsUpdated(row, row);
    }

    public synchronized void insertRow(Object editId) {
        int row = this.countInserted++;
        int ir = this.getInternalRow(row);
        TngTableRow r2 = new TngTableRow(ir, this.countColumns);
        r2.inserted = true;
        r2.editId = editId;
        this.addEditedRow(r2);
        this.fireTableRowsInserted(row, row);
    }

    public synchronized void updateRow(int row, Object editId) {
        int ir = this.getInternalRow(row);
        TngTableRow old = this.findEditedRowIR(ir);
        TngTableRow r2 = new TngTableRow(ir, this.countColumns);
        r2.updated = true;
        r2.editId = editId;
        ++this.countUpdated;
        this.addEditedRow(r2);
        if (old != null) {
            this.deleteRowFromCache(ir);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void eraseRow(int row) throws Exception {
        this.eraseRow(row, null);
    }

    public synchronized void eraseRow(int row, Iterator iter) throws Exception {
        int ir = this.getInternalRow(row);
        TngTableRow r2 = this.findEditedRowIR(ir);
        if (r2 == null) {
            r2 = this.getRow(row);
            this.doEraseRow(r2);
            r2.deleted = true;
            r2.editId = null;
            ++this.countErased;
            this.addEditedRow(r2);
            this.deleteRowFromCache(ir);
        } else {
            if (!r2.valuesLoaded) {
                r2 = this.getRow(row);
            }
            if (r2.deleted) {
                return;
            }
            this.doEraseRow(r2);
            r2.editId = null;
            r2.deleted = true;
            ++this.countErased;
        }
        if (iter == null) {
            this.setRowMarkDeleteIR(ir, false);
        } else {
            this.clearMarkDeleteFromIterator(iter, ir);
        }
        this.fireTableRowsUpdated(row, row);
    }

    protected void doEraseRow(TngTableRow r2) throws Exception {
        throw new Exception(Nat.x("Mazanie z\u00e1znamov nie je implementovan\u00e9"));
    }

    public synchronized int eraseMarkedRows() throws Exception {
        if (this.getCountMarkDelete() == 0) {
            return 0;
        }
        Iterator<Integer> e2 = this.getIteratorMarkDelete();
        int count = 0;
        while (e2.hasNext()) {
            int ir = e2.next();
            int row = this.getTabularRow(ir);
            this.eraseRow(row, e2);
            ++count;
        }
        return count;
    }

    public int getInternalRow(int row) {
        if (row >= this.countInserted) {
            return row - this.countInserted;
        }
        return -(row + 1);
    }

    public int getTabularRow(int ir) {
        if (ir >= 0) {
            return ir + this.countInserted;
        }
        return -(ir + 1);
    }

    public boolean refreshSafe() {
        try {
            this.refresh();
            return true;
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() throws Exception {
        try {
            this.asyncLoader.close();
            this.countRows = 0;
            this.countInserted = 0;
            this.countUpdated = 0;
            this.countErased = 0;
            this.prepareData();
            this.countColumns = this.columns == null ? 0 : this.columns.length;
            this.clearCacheRows();
            this.clearEditedRows();
            this.clearMarksDelete();
            this.clearMarksSelect();
            if (this.asyncLoad) {
                this.asyncLoader.start();
            }
        }
        finally {
            if (this.columnsChanged) {
                this.columnsChanged = false;
                this.fireTableStructureChanged();
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    public void setColumns(TngTableColumn[] columns) {
        this.countColumns = 0;
        this.columnsChanged = true;
        this.columns = columns;
    }

    public void setColumns(Vector<TngTableColumn> v) {
        TngTableColumn[] c2 = null;
        if (v != null && v.size() > 0) {
            c2 = new TngTableColumn[v.size()];
            for (int i2 = 0; i2 < v.size(); ++i2) {
                c2[i2] = v.get(i2);
            }
        }
        this.setColumns(c2);
    }

    public TngTableColumn[] getColumns() {
        return this.columns;
    }

    protected abstract void prepareData() throws Exception;

    protected void getRowValues(TngTableRow r2) {
    }

    public synchronized TngTableRow getRow(int row) {
        TngTableRow r2 = null;
        int ir = this.getInternalRow(row);
        r2 = this.findEditedRowIR(ir);
        if (r2 == null && (r2 = this.findCacheRowIR(ir)) == null) {
            r2 = new TngTableRow(ir, this.countColumns);
            this.addRowToCache(r2);
        }
        if (!r2.valuesLoaded) {
            this.getRowValues(r2);
            r2.valuesLoaded = true;
            if (!r2.valuesLoadedAsync && this.asyncLoad) {
                this.asyncLoader.add(r2);
            }
        }
        return r2;
    }

    public Object getObject(int row, int column) {
        return this.getRow((int)row).values[column];
    }

    public void columnClicked(MouseEvent evt, JTable table, int column) {
        if (!this.canOrdered(column)) {
            TngSwing.msgWarning(Nat.x("Nie je mo\u017en\u00e9 usporiada\u0165 pod\u013ea st\u013apca <%1>", this.getColumnName(column)));
        } else {
            if (evt.isControlDown()) {
                this.changeOrderMulti(column);
            } else {
                this.changeOrderSimple(column);
            }
            if (table instanceof TngTable) {
                ((TngTable)table).refreshAndReset();
            }
        }
    }

    public boolean canOrdered(int column) {
        return this.columns[column].canOrdered;
    }

    public void changeOrderSimple(int column) {
    }

    public void changeOrderMulti(int column) {
    }

    public int findInOrder(int column, Point p2) {
        return 0;
    }

    public void setColumnHeader(JLabel header, int column) {
        String title = this.getColumnName(column);
        ImageIcon icon = null;
        Point p2 = new Point();
        int o2 = this.findInOrder(column, p2);
        if (o2 > 0) {
            if (p2.y > 1) {
                title = title + " (" + p2.x + ")";
            }
            icon = iconOrderUp;
        } else if (o2 < 0) {
            if (p2.y > 1) {
                title = title + " (" + p2.x + ")";
            }
            icon = iconOrderDown;
        } else if (this.markUnorderedColumn && !this.canOrdered(column)) {
            icon = iconOrderDisable;
        }
        header.setText(title);
        header.setIcon(icon);
    }

    @Override
    public int getColumnCount() {
        return this.countColumns;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column].title;
    }

    public int getColumnPosition(String name) {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            if (!this.columns[i2].name.equalsIgnoreCase(name)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.countRows + this.countInserted;
    }

    public Class getColumnClass(int column) {
        return TngTableColumn.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object o2;
        this.columns[column].renderValue = o2 = this.getObject(row, column);
        return this.columns[column];
    }

    private void clearMarksDelete() {
        this.lastMarkDelete = -1;
        this.cacheMarkDelete.clear();
    }

    private synchronized boolean getRowMarkDeleteIR(int ir) {
        if (this.lastMarkDelete >= 0 && this.lastMarkDeleteIR == ir) {
            return this.lastMarkDelete == 1;
        }
        return this.cacheMarkDelete.contains(new Integer(ir));
    }

    private synchronized void setRowMarkDeleteIR(int ir, boolean set) {
        Integer key = new Integer(ir);
        if (set) {
            TngTableRow r2 = this.findEditedRowIR(ir);
            if (r2 != null && r2.deleted) {
                return;
            }
            this.cacheMarkDelete.add(key);
            this.setRowMarkSelectIR(ir, false);
        } else {
            this.cacheMarkDelete.remove(key);
        }
        this.lastMarkDeleteIR = ir;
        this.lastMarkDelete = set ? 1 : 0;
    }

    private synchronized void clearRowMarkDelete(Iterator iter, int ir) {
        iter.remove();
        this.lastMarkDeleteIR = ir;
        this.lastMarkDelete = 0;
    }

    private void clearMarksSelect() {
        this.lastMarkSelect = -1;
        this.cacheMarkSelect.clear();
    }

    private synchronized boolean getRowMarkSelectIR(int ir) {
        if (this.lastMarkSelect >= 0 && this.lastMarkSelectIR == ir) {
            return this.lastMarkSelect == 1;
        }
        return this.cacheMarkSelect.contains(new Integer(ir));
    }

    private synchronized void setRowMarkSelectIR(int ir, boolean set) {
        Integer key = new Integer(ir);
        if (set) {
            TngTableRow r2 = this.findEditedRowIR(ir);
            if (r2 != null && r2.deleted) {
                return;
            }
            this.cacheMarkSelect.add(key);
            this.setRowMarkDeleteIR(ir, false);
        } else {
            this.cacheMarkSelect.remove(key);
        }
        this.lastMarkSelectIR = ir;
        this.lastMarkSelect = set ? 1 : 0;
    }

    private synchronized void clearRowMarkSelect(Iterator iter, int ir) {
        iter.remove();
        this.lastMarkSelectIR = ir;
        this.lastMarkSelect = 0;
    }

    private void clearEditedRows() {
        this.lastEditedRow = null;
        this.cacheEdited.clear();
    }

    private TngTableRow findEditedRowIR(int ir) {
        if (this.lastEditedRow != null && this.lastEditedRow.irow == ir) {
            return this.lastEditedRow;
        }
        return this.cacheEdited.get(new Integer(ir));
    }

    private void addEditedRow(TngTableRow r2) {
        this.lastEditedRow = r2;
        this.cacheEdited.put(new Integer(r2.irow), r2);
    }

    private void clearCacheRows() {
        this.cacheRows = new TngTableRow[this.cacheRowsSize];
        this.lastRow = null;
        this.lastIndex = -1;
    }

    public boolean isCacheInitialized() {
        return this.cacheRows != null;
    }

    private TngTableRow findCacheRowIR(int irow) {
        if (this.lastRow != null && this.lastRow.irow == irow) {
            return this.lastRow;
        }
        int len = this.cacheRows.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.cacheRows[i2] == null || this.cacheRows[i2].irow != irow) continue;
            this.lastRow = this.cacheRows[i2];
            return this.lastRow;
        }
        return null;
    }

    private void addRowToCache(TngTableRow r2) {
        ++this.lastIndex;
        if (this.lastIndex >= this.cacheRows.length) {
            this.lastIndex = 0;
        }
        if (this.asyncLoad && this.cacheRows[this.lastIndex] != null) {
            this.asyncLoader.delete(this.cacheRows[this.lastIndex]);
        }
        this.cacheRows[this.lastIndex] = r2;
        this.lastRow = r2;
    }

    private void deleteRowFromCache(int irow) {
        int len = this.cacheRows.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.cacheRows[i2] == null || this.cacheRows[i2].irow != irow) continue;
            if (this.asyncLoad) {
                this.asyncLoader.delete(this.cacheRows[i2]);
            }
            if (this.lastRow == this.cacheRows[i2]) {
                this.lastRow = null;
            }
            this.cacheRows[i2] = null;
            return;
        }
    }

    protected void loadRowAsync(TngTableRow r2) {
        this.getRowValuesAsync(r2);
        r2.valuesLoadedAsync = true;
        int row = this.getTabularRow(r2.irow);
        this.invokeRowUpdated(row);
    }

    protected void invokeRowUpdated(final int row) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TngTableModel.this.fireTableRowsUpdated(row, row);
            }
        });
    }

    protected void getRowValuesAsync(TngTableRow r2) {
    }
}

