/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.model;

import java.awt.Point;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngOrder;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.table.component.TngTableColumnSql;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.model.TngTableModel;

public class TngTableModelSql
extends TngTableModel {
    public static final int MAX_ROWS_LIMIT_SHOW = 100000;
    private String sqlTables;
    protected String sqlColumns;
    private String sqlKeyColumn;
    private int sqlKeyColumnIdx;
    private String sqlFilterJoin;
    private String sqlFilterMain;
    private String sqlFilterExt;
    private String sqlOrder;
    private String sqlGroup;
    private Statement stmtData;
    private Statement stmtRow;
    private TngConnection connection;
    private String sqlSelect;
    protected ResultSet resData;
    protected int[] SqlColumnIndexes;

    public TngTableModelSql() {
        this.setMarkUnorderedColumn(true);
    }

    public TngTableModelSql(TngConnection connection) {
        this();
        this.connection = connection;
    }

    @Override
    public void close() {
        super.close();
        this.closeStmt(this.stmtData);
        this.closeStmt(this.stmtRow);
        this.stmtData = null;
        this.stmtRow = null;
    }

    @Override
    public String toString() {
        String h2 = Nat.x("SQL pr\u00edkaz:") + "\n" + this.getSqlSelect() + "\n\n";
        h2 = h2 + Nat.x("K\u013e\u00fa\u010dov\u00fd st\u013apec:") + " " + this.sqlKeyColumn + " (" + this.sqlKeyColumnIdx + ")\n";
        h2 = h2 + Nat.x("Hlavn\u00e1 tabu\u013eka:") + " " + this.getMainSqlTable() + "\n";
        h2 = h2 + super.toString();
        return h2;
    }

    protected void closeStmt(Statement stmt) {
        if (this.connection != null) {
            this.connection.close(stmt);
        }
    }

    protected void closeResult(ResultSet res) {
        if (this.connection != null) {
            this.connection.close(res);
        }
    }

    public TngConnection getConnection() {
        return this.connection;
    }

    public void setConnection(TngConnection connection) {
        this.connection = connection;
    }

    public String getSqlTables() {
        return this.sqlTables;
    }

    public void setSqlTables(String sqlTables) {
        this.sqlTables = sqlTables;
    }

    public String getSqlFilterJoin() {
        return this.sqlFilterJoin;
    }

    public void setSqlFilterJoin(String sqlFilterJoin) {
        this.sqlFilterJoin = sqlFilterJoin;
    }

    public String getSqlFilterMain() {
        return this.sqlFilterMain;
    }

    public void setSqlFilterMain(String sqlFilterMain) {
        this.sqlFilterMain = sqlFilterMain;
    }

    public String getSqlFilterExt() {
        return this.sqlFilterExt;
    }

    public void setSqlFilterExt(String sqlFilterExt) {
        this.sqlFilterExt = sqlFilterExt;
    }

    public String getSqlGroup() {
        return this.sqlGroup;
    }

    public void setSqlGroup(String sqlGroup) {
        this.sqlGroup = sqlGroup;
    }

    public String getSqlOrder() {
        return this.sqlOrder;
    }

    public void setSqlOrder(String sqlOrder) {
        this.sqlOrder = sqlOrder;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public String getSqlColumns() {
        return this.sqlColumns;
    }

    public String getSqlKeyColumn() {
        return this.sqlKeyColumn;
    }

    public void setSqlKeyColumn(String sqlKeyColumn) {
        this.sqlKeyColumn = sqlKeyColumn;
    }

    public String createSqlColumns() {
        this.SqlColumnIndexes = new int[this.columns.length];
        int index = 0;
        String cols = null;
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            this.SqlColumnIndexes[i2] = 0;
            if (!(this.columns[i2] instanceof TngTableColumnSql)) continue;
            this.SqlColumnIndexes[i2] = ++index;
            cols = index == 1 ? ((TngTableColumnSql)this.columns[i2]).getSqlColumn() : cols + "," + ((TngTableColumnSql)this.columns[i2]).getSqlColumn();
        }
        return cols;
    }

    protected int findSqlKeyColumn() {
        if (this.columns == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            if (!(this.columns[i2] instanceof TngTableColumnSql)) continue;
            return i2;
        }
        return -1;
    }

    protected String createSqlSelect() {
        if (this.sqlTables == null) {
            return null;
        }
        this.sqlColumns = this.createSqlColumns();
        this.createSqlKeyColumns();
        if (this.sqlColumns == null || this.sqlColumns.length() == 0) {
            return null;
        }
        String select = "SELECT " + this.sqlColumns + "\nFROM " + this.sqlTables;
        select = select + TngUtilities.where3(this.sqlFilterJoin, this.sqlFilterMain, this.sqlFilterExt);
        if (this.sqlGroup != null && this.sqlGroup.length() > 0) {
            select = select + "\nGROUP BY " + this.sqlGroup;
        }
        if (this.sqlOrder != null && this.sqlOrder.length() > 0) {
            select = select + "\nORDER BY " + this.sqlOrder;
        }
        return select;
    }

    public String createSqlKeyColumns() {
        this.sqlKeyColumnIdx = this.findSqlKeyColumn();
        this.sqlKeyColumn = this.sqlKeyColumnIdx < 0 ? null : ((TngTableColumnSql)this.columns[this.sqlKeyColumnIdx]).getSqlColumn();
        return this.sqlKeyColumn;
    }

    protected String createSqlSelectRowEdited(Object editId) {
        String filterRow = this.createSqlFilterRowEdited(editId);
        if (this.sqlTables == null || filterRow == null) {
            return null;
        }
        String select = "SELECT " + this.sqlColumns + "\nFROM " + this.sqlTables;
        select = select + TngUtilities.where2(this.sqlFilterJoin, filterRow);
        if (this.sqlGroup != null && this.sqlGroup.length() > 0) {
            select = select + "\nGROUP BY " + this.sqlGroup;
        }
        return select;
    }

    public String createSqlFilterRowEdited(Object editId) {
        if (editId == null) {
            return null;
        }
        return editId.toString();
    }

    public String createSqlFilterRow(int row) {
        if (this.sqlKeyColumn == null) {
            return null;
        }
        return this.sqlKeyColumn + "=" + this.getRowKeyValue(row);
    }

    public String getRowKeyValue(int row) {
        Object o2 = this.getObject(row, this.sqlKeyColumnIdx);
        if (o2 == null) {
            return null;
        }
        return "'" + o2.toString() + "'";
    }

    public String getSqlFilterMarked() {
        return this.getSqlFilterMarked(this.sqlKeyColumn);
    }

    public String getSqlFilterMarked(String fieldName) {
        int count = 0;
        if (this.getCountMarkSelect() == 0 || this.sqlKeyColumn == null) {
            return null;
        }
        StringBuilder flt = new StringBuilder();
        Iterator<Integer> e2 = this.getIteratorMarkSelect();
        while (e2.hasNext()) {
            int irow = e2.next();
            int row = this.getTabularRow(irow);
            if (count > 0) {
                flt.append(",");
            }
            flt.append(this.getRowKeyValue(row));
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return fieldName + "=" + flt.toString();
        }
        return fieldName + " IN(" + flt.toString() + ")";
    }

    protected void connectStmt() throws Exception {
        this.closeResult(this.resData);
        this.resData = null;
        if (this.connection == null) {
            throw new Exception("Connection is NULL");
        }
        this.stmtData = this.connection.execStatement(this.stmtData, null, true);
        this.stmtRow = this.connection.execStatement(this.stmtRow, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int calcRows() throws Exception {
        ResultSet res = null;
        try {
            String select = "SELECT count(*) FROM (" + this.sqlSelect + ")";
            this.stmtRow = this.connection.execStatement(this.stmtRow, select);
            res = this.stmtRow.getResultSet();
            res.next();
            int n2 = res.getInt(1);
            this.closeResult(res);
            return n2;
        }
        catch (Throwable throwable) {
            this.closeResult(res);
            throw throwable;
        }
    }

    @Override
    protected void prepareData() throws Exception {
        this.connectStmt();
        this.sqlSelect = this.createSqlSelect();
        if (this.sqlSelect == null) {
            return;
        }
        this.countRows = this.calcRows();
        if (this.countRows > 100000) {
            TngSwing.msgWarning(Nat.x("V tabu\u013eke je pr\u00edli\u0161 ve\u013ea z\u00e1znamov, zobraz\u00ed sa len prv\u00fdch %1 z\u00e1znamov", 100000));
            this.sqlSelect = "SELECT * FROM (" + this.sqlSelect + ") WHERE rownum<=" + 100000;
            this.countRows = 100000;
        }
        this.stmtData = this.connection.execStatement(this.stmtData, this.sqlSelect);
        this.resData = this.stmtData.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getRowValues(TngTableRow r2) {
        if (r2.editId == null) {
            try {
                this.resData.absolute(r2.irow + 1);
                this.fetchRow(this.resData, r2.values);
            }
            catch (Exception e2) {
                TngUtilities.exceptionLog(e2);
                return;
            }
        }
        ResultSet res = null;
        try {
            String select = this.createSqlSelectRowEdited(r2.editId);
            this.stmtRow = this.connection.execStatement(this.stmtRow, select);
            res = this.stmtRow.getResultSet();
            if (res.next()) {
                this.fetchRow(res, r2.values);
            }
            this.closeResult(res);
        }
        catch (Exception e3) {
            TngUtilities.exceptionLog(e3);
            return;
        }
        finally {
            this.closeResult(res);
        }
    }

    protected void fetchRow(ResultSet res, Object[] o2) {
        for (int i2 = 0; i2 < this.countColumns; ++i2) {
            int idx = this.SqlColumnIndexes[i2];
            if (idx <= 0) continue;
            try {
                o2[i2] = res.getObject(idx);
                if (!(o2[i2] instanceof Date)) continue;
                o2[i2] = res.getTimestamp(idx);
                continue;
            }
            catch (Exception e2) {
                o2[i2] = e2;
            }
        }
    }

    @Override
    protected void doEraseRow(TngTableRow r2) throws Exception {
        if (this.sqlKeyColumn == null) {
            throw new Exception(Nat.x("Nie je definovan\u00fd k\u013e\u00fa\u010dov\u00fd st\u013apec, zmazanie z\u00e1znamu nie je mo\u017en\u00e9"));
        }
        int row = this.getTabularRow(r2.irow);
        String flt = this.createSqlFilterRow(row);
        if (flt == null || flt.length() == 0) {
            throw new Exception(Nat.x("Nie je zn\u00e1my filter na zmazanie %1. z\u00e1znamu", row + 1));
        }
        this.connection.exec("DELETE FROM " + this.getMainSqlTable() + " WHERE " + flt);
        this.connection.commit();
    }

    public String getMainSqlTable() {
        if (this.sqlTables == null || this.sqlTables.length() == 0) {
            return null;
        }
        if (this.sqlTables.charAt(0) == '(') {
            return null;
        }
        if (this.sqlTables.indexOf(44) < 0) {
            return this.sqlTables;
        }
        String[] tables = this.sqlTables.split(",");
        return tables[0].trim();
    }

    @Override
    public void changeOrderSimple(int column) {
        if (this.canOrdered(column)) {
            this.sqlOrder = TngOrder.changeOrderSimple(this.sqlOrder, this.columns[column].name);
        }
    }

    @Override
    public void changeOrderMulti(int column) {
        if (this.canOrdered(column)) {
            this.sqlOrder = TngOrder.changeOrderMulti(this.sqlOrder, this.columns[column].name);
        }
    }

    @Override
    public int findInOrder(int column, Point p2) {
        if (column < 0 || column > this.columns.length) {
            return 0;
        }
        return TngOrder.findInOrder(this.sqlOrder, this.columns[column].name, p2);
    }
}

