/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.model.TngTableModel;

public class TngTableRendererCell
extends DefaultTableCellRenderer {
    public static Color selectionBackground = new Color(130, 170, 210);
    public static Color selectionBackgroundNoFocus = new Color(165, 195, 220);

    public TngTableRendererCell() {
        this.putClientProperty("html.disable", Boolean.TRUE);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TngTableColumn c2 = (TngTableColumn)value;
        c2.prepareRender();
        super.getTableCellRendererComponent(table, c2.renderString, isSelected, hasFocus, row, column);
        this.setIcon(c2.renderIcon);
        this.setHorizontalAlignment(c2.horizontalAlignment);
        Color fc = table.getForeground();
        if (table.getModel() instanceof TngTableModel) {
            TngTableRow r2 = ((TngTableModel)table.getModel()).getRow(row);
            if (r2.foregroundColor != null) {
                fc = r2.foregroundColor;
            }
        }
        if (c2.foregroundColor != null) {
            fc = c2.foregroundColor;
        }
        if (c2.font != null) {
            this.setFont(c2.font);
        }
        if (isSelected) {
            if (table.hasFocus()) {
                this.setBackground(selectionBackground);
            } else {
                this.setBackground(selectionBackgroundNoFocus);
            }
        } else {
            Color bcolor = table.getBackground();
            this.setBackground(bcolor);
        }
        this.setForeground(fc);
        this.setBorder(new EmptyBorder(0, 4, 0, 2));
        return this;
    }
}

