/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.renderer;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import tangram.swing.icon.TngIcon;
import tangram.swing.table.component.TngTableRowHeader;
import tangram.swing.table.model.TngTableModel;

public class TngTableRendererRowHeader
extends JButton
implements ListCellRenderer {
    private static final ImageIcon iconInserted = TngIcon.getIcon("table_row_ins.png");
    private static final ImageIcon iconUpdated = TngIcon.getIcon("table_row_upd.png");
    private static final ImageIcon iconErased = TngIcon.getIcon("table_row_ers.png");
    private static final ImageIcon iconDelete = TngIcon.getIcon("table_row_delete.png");
    private static final ImageIcon iconDeleteInserted = TngIcon.getIcon("table_row_delete_ins.png");
    private static final ImageIcon iconDeleteUpdated = TngIcon.getIcon("table_row_delete_upd.png");
    private static final ImageIcon iconDeleteErased = TngIcon.getIcon("table_row_delete_ers.png");
    private static final ImageIcon iconSelect = TngIcon.getIcon("table_row_select.png");
    private static final ImageIcon iconSelectInserted = TngIcon.getIcon("table_row_select_ins.png");
    private static final ImageIcon iconSelectUpdated = TngIcon.getIcon("table_row_select_upd.png");
    private static final ImageIcon iconSelectErased = TngIcon.getIcon("table_row_select_ers.png");
    private static final Icon[] iconsPure = new Icon[]{null, iconInserted, iconUpdated, iconErased};
    private static final Icon[] iconsDeleted = new Icon[]{iconDelete, iconDeleteInserted, iconDeleteUpdated, iconDeleteErased};
    private static final Icon[] iconsSelected = new Icon[]{iconSelect, iconSelectInserted, iconSelectUpdated, iconSelectErased};

    public TngTableRendererRowHeader() {
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list instanceof TngTableRowHeader) {
            TngTableModel model = ((TngTableRowHeader)list).getTableModel();
            Icon icon = null;
            if (model.isCacheInitialized()) {
                int i2 = model.getRow(index).getMainEditedStatus();
                icon = model.hasRowMarkDelete(index) ? iconsDeleted[i2] : (model.hasRowMarkSelect(index) ? iconsSelected[i2] : iconsPure[i2]);
            }
            this.setIcon(icon);
            this.setBackground(list.getBackground());
        }
        return this;
    }
}

