/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.valuable;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngFieldArea;

public class TngValueErrorPopup
extends TngFieldArea {
    private Component owner;
    private Popup popup;
    private Timer timer;

    public TngValueErrorPopup() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setForeground(TngSwing.colorErrorPopupForeground);
        this.setBackgroundNotEditable(TngSwing.colorErrorPopupBackground);
        this.setEditable(false);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setMargin(new Insets(6, 6, 6, 6));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TngValueErrorPopup.this.this_mouseClicked(e2);
            }
        });
        this.createTimer();
    }

    private void this_mouseClicked(MouseEvent e2) {
        this.popupHide();
    }

    public void setData(Component owner, String error) {
        this.owner = owner;
        this.setString(" " + error + " ");
    }

    public boolean popupIsVisible() {
        return this.popup != null;
    }

    public void popupShow(int showMillis) {
        if (this.popup != null) {
            this.retimer(showMillis);
            return;
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        Point pos = this.owner.getLocationOnScreen();
        int x = pos.x;
        int y = pos.y - this.getPreferredSize().height;
        this.popup = popupFactory.getPopup(this.owner, this, x, y);
        this.popup.show();
        this.retimer(showMillis);
    }

    public void popupHide() {
        if (this.popup != null) {
            this.popup.hide();
        }
        this.popup = null;
        this.timer.stop();
    }

    private void retimer(int millis) {
        this.timer.stop();
        if (millis > 0) {
            this.timer.setInitialDelay(millis);
            this.timer.start();
        }
    }

    private void createTimer() {
        ActionListener showTime = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TngValueErrorPopup.this.popupHide();
            }
        };
        this.timer = new Timer(0, showTime);
        this.timer.setRepeats(false);
    }
}

