/*
 * Decompiled with CFR 0.152.
 */
package tangram.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import tangram.exception.TngExceptionAbort;
import tangram.interfaces.TngProgressable;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;
import tangram.xml.XmlColumn;
import tangram.xml.XmlColumns;
import tangram.xml.XmlTableExportPrm;

public final class XmlTableExport {
    private static final SimpleDateFormat fmtDateTime = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTable(XmlTableExportPrm prm, TngConnection connection, File file, TngProgressable progress) throws Exception {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "windows-1250"));
            XmlTableExport.exportTable(prm, connection, writer, progress);
            ((Writer)writer).close();
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(writer);
            throw throwable;
        }
        TngUtilities.closeSafe(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTable(XmlTableExportPrm prm, TngConnection connection, Writer writer, TngProgressable progress) throws Exception {
        Statement st = null;
        try {
            st = connection.execStatement(prm.getSelect());
            ResultSet res = st.getResultSet();
            List<XmlColumn> columns = XmlColumns.getColumns(res.getMetaData(), true);
            String[] cols = XmlColumns.getNames(columns);
            boolean readed = res.next();
            if (readed) {
                prm.rows = res.getInt(1);
            }
            progress.setProgressMax(prm.rows);
            XmlTableExport.writeHeader(writer, prm, columns);
            writer.write("<rows>\n");
            while (readed) {
                if (progress.isProgressCanceled()) {
                    throw new TngExceptionAbort();
                }
                writer.write("<row>\r\n");
                for (int i2 = 0; i2 < cols.length; ++i2) {
                    Object value = res.getObject(i2 + 2);
                    if (value == null) continue;
                    String column = cols[i2];
                    writer.write("<");
                    writer.write(column);
                    writer.write(">");
                    XmlTableExport.writeValue(writer, value);
                    writer.write("</");
                    writer.write(column);
                    writer.write(">\r\n");
                }
                writer.write("</row>\r\n");
                progress.addProgressValue(1);
                readed = res.next();
            }
            writer.write("</rows>\n");
            writer.write("</table>");
            writer.flush();
        }
        finally {
            connection.close(st);
        }
    }

    private static void writeHeader(Writer writer, XmlTableExportPrm prm, List<XmlColumn> columns) throws Exception {
        writer.write("<?xml");
        XmlTableExport.writeAttribute(writer, "version", "1.0");
        XmlTableExport.writeAttribute(writer, "encoding", "WINDOWS-1250");
        writer.write("?>\r\n");
        writer.write("<table");
        XmlTableExport.writeAttribute(writer, "name", prm.sqlName);
        XmlTableExport.writeAttribute(writer, "schema", prm.schema);
        XmlTableExport.writeAttribute(writer, "template", prm.template);
        XmlTableExport.writeAttribute(writer, "version", prm.version);
        XmlTableExport.writeAttribute(writer, "time", TngUtilities.dateTimeToStr(new Date()));
        XmlTableExport.writeAttribute(writer, "columns", Integer.toString(columns.size()));
        XmlTableExport.writeAttribute(writer, "rows", Integer.toString(prm.rows));
        XmlTableExport.writeAttribute(writer, "filter", prm.filter);
        XmlTableExport.writeAttribute(writer, "order", prm.order);
        writer.write(">\r\n");
        XmlTableExport.writeColumns(writer, columns);
    }

    private static void writeColumns(Writer writer, List<XmlColumn> columns) throws Exception {
        writer.write("<columns>\r\n");
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            XmlColumn c2 = columns.get(i2);
            writer.write("<column");
            XmlTableExport.writeAttribute(writer, "name", c2.name);
            XmlTableExport.writeAttribute(writer, "type", c2.type);
            if (c2.precision != 0) {
                XmlTableExport.writeAttribute(writer, "precision", Integer.toString(c2.precision));
            }
            if (c2.scale != 0) {
                XmlTableExport.writeAttribute(writer, "scale", Integer.toString(c2.scale));
            }
            writer.write("/>\r\n");
        }
        writer.write("</columns>\r\n");
    }

    private static void writeAttribute(Writer writer, String atribute, String value) throws Exception {
        if (value == null || value.length() == 0) {
            return;
        }
        writer.write(" ");
        writer.write(atribute);
        writer.write("=\"");
        XmlTableExport.writeStringExtends(writer, value);
        writer.write("\"");
    }

    private static void writeValue(Writer writer, Object value) throws Exception {
        if (value instanceof BigDecimal) {
            writer.write(value.toString());
        } else if (value instanceof Date) {
            String h2 = fmtDateTime.format((Date)value);
            if (h2.endsWith("00:00:00")) {
                writer.write(h2, 0, 10);
            } else {
                writer.write(h2);
            }
        } else {
            XmlTableExport.writeStringExtends(writer, value.toString());
        }
    }

    private static void writeStringExtends(Writer writer, String string) throws Exception {
        char c2;
        int i2;
        int firstExtends = -1;
        for (i2 = 0; i2 < string.length(); ++i2) {
            c2 = string.charAt(i2);
            if (c2 != '&' && c2 != '<' && c2 != '\"' && c2 >= ' ') continue;
            firstExtends = i2;
            break;
        }
        if (firstExtends < 0) {
            writer.write(string);
            return;
        }
        if (firstExtends > 0) {
            writer.write(string, 0, firstExtends);
        }
        for (i2 = firstExtends; i2 < string.length(); ++i2) {
            c2 = string.charAt(i2);
            if (c2 == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c2 == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c2 == '\"') {
                writer.write("&quot;");
                continue;
            }
            if (c2 < ' ') {
                writer.write("&#");
                writer.write(Integer.toString(c2));
                writer.write(59);
                continue;
            }
            writer.write(c2);
        }
    }
}

