/*
 * Decompiled with CFR 0.152.
 */
package tangram.xml;

import java.io.BufferedReader;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tangram.exception.TngExceptionAbort;
import tangram.exception.TngExceptionLine;
import tangram.exception.TngExceptionSql;
import tangram.interfaces.TngProgressable;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngSqlUtilities;
import tangram.library.TngUtilities;
import tangram.xml.XmlColumn;
import tangram.xml.XmlColumns;
import tangram.xml.XmlTable;
import tangram.xml.XmlTableImportListener;

public final class XmlTableImport {
    public static void importTable(BufferedReader reader, boolean overwrite, TngConnection connection, String sqlTable, XmlTableImportListener listener, TngProgressable progress) throws Exception {
        XmlTable xmlTable = XmlTableImport.readXmlTable(reader);
        XmlTableImport.importRows(reader, xmlTable, overwrite, connection, sqlTable, listener, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importRows(BufferedReader reader, XmlTable xmlTable, boolean overwrite, TngConnection connection, String schemaAndTable, XmlTableImportListener listener, TngProgressable progress) throws Exception {
        String[] cols = XmlTableImport.resolveColumns(xmlTable, connection, schemaAndTable, listener);
        if (cols == null) {
            return;
        }
        String insert = "INSERT INTO " + schemaAndTable + "(" + XmlTableImport.syntetizeColumns(cols) + ") VALUES(" + XmlTableImport.syntetizeMarks(cols) + ")";
        PreparedStatement stInsert = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        int uncommited = 0;
        try {
            stInsert = connection.prepareStatement(insert);
            if (overwrite) {
                TngSqlUtilities.truncateTable(connection, schemaAndTable);
            }
            progress.setProgressMax(xmlTable.rows);
            while (XmlTableImport.readNextRow(xmlTable, reader, binds)) {
                block14: {
                    if (progress.isProgressCanceled()) {
                        throw new TngExceptionAbort();
                    }
                    for (int i2 = 0; i2 < cols.length; ++i2) {
                        stInsert.setString(i2 + 1, (String)binds.get(cols[i2]));
                    }
                    try {
                        connection.executeUpdate(stInsert);
                    }
                    catch (TngExceptionSql e2) {
                        if (listener.onError(xmlTable, schemaAndTable, binds, e2)) break block14;
                        if (uncommited > 0) {
                            connection.commit();
                        }
                        connection.close(stInsert);
                        return;
                    }
                }
                if (++uncommited > 1000) {
                    uncommited = 0;
                    connection.commit();
                }
                progress.addProgressValue(1);
            }
        }
        finally {
            if (uncommited > 0) {
                connection.commit();
            }
            connection.close(stInsert);
        }
    }

    private static String[] resolveColumns(XmlTable xmlTable, TngConnection connection, String schemaAndTable, XmlTableImportListener listener) throws Exception {
        List<XmlColumn> dstColumns = XmlColumns.getColumns(connection, schemaAndTable);
        if (xmlTable.columns == null) {
            return XmlColumns.getNames(dstColumns);
        }
        List<String> importCols = new ArrayList<String>();
        ArrayList<String> differCols = new ArrayList<String>();
        ArrayList<String> missingInSrc = new ArrayList<String>();
        ArrayList<String> missingInDst = new ArrayList<String>();
        XmlColumns.compare(xmlTable.columns, dstColumns, importCols, differCols, missingInSrc, missingInDst);
        if (importCols.size() == 0) {
            throw new Exception(Nat.x("Tabu\u013eka %1 nem\u00e1 ani jeden spolo\u010dn\u00fd st\u013apec pre import", schemaAndTable));
        }
        if (!(differCols.size() == 0 && missingInSrc.size() == 0 && missingInDst.size() == 0 || (importCols = listener.onColumnsDifference(xmlTable, schemaAndTable, dstColumns, importCols, differCols, missingInSrc, missingInDst)) != null && importCols.size() != 0)) {
            return null;
        }
        return importCols.toArray(new String[0]);
    }

    public static XmlTable readXmlTable(BufferedReader reader) throws Exception {
        int lineNumber = 1;
        String line = reader.readLine();
        if (line == null || !line.startsWith("<?xml ")) {
            throw new TngExceptionLine(Nat.x("O\u010dak\u00e1va sa riadok: '<?xml ...'"), line, lineNumber);
        }
        String a2 = XmlTableImport.getAttribute(line, lineNumber, "encoding");
        if (a2 != null && !a2.toUpperCase().equals("WINDOWS-1250")) {
            throw new TngExceptionLine(Nat.x("Nepodporovan\u00e9 k\u00f3dovanie %1, mus\u00ed by\u0165 WINDOWS-1250", a2), line, lineNumber);
        }
        ++lineNumber;
        line = reader.readLine();
        if (line == null || !line.startsWith("<table ")) {
            throw new TngExceptionLine(Nat.x("O\u010dak\u00e1va sa riadok '<table ...'"), line, lineNumber);
        }
        XmlTable table = new XmlTable();
        table.name = XmlTableImport.getAttribute(line, lineNumber, "name");
        table.schema = XmlTableImport.getAttribute(line, lineNumber, "schema");
        table.filter = XmlTableImport.getAttribute(line, lineNumber, "filter");
        table.order = XmlTableImport.getAttribute(line, lineNumber, "order");
        table.template = XmlTableImport.getAttribute(line, lineNumber, "template");
        table.version = XmlTableImport.getAttribute(line, lineNumber, "version");
        int cols = TngUtilities.strToInt(XmlTableImport.getAttribute(line, lineNumber, "columns"), -1);
        table.rows = TngUtilities.strToInt(XmlTableImport.getAttribute(line, lineNumber, "rows"), -1);
        table.lineNumber = lineNumber;
        if (cols > 0) {
            XmlTableImport.readXmlTableColumns(reader, table, cols);
            ++table.lineNumber;
            line = reader.readLine();
            if (line == null || !line.equals("<rows>")) {
                throw new TngExceptionLine(Nat.x("O\u010dak\u00e1va sa riadok '<rows>'"), line, table.lineNumber);
            }
        }
        return table;
    }

    public static void readXmlTableColumns(BufferedReader reader, XmlTable table, int cols) throws Exception {
        ++table.lineNumber;
        String line = reader.readLine();
        if (line == null || !line.equals("<columns>")) {
            throw new TngExceptionLine(Nat.x("O\u010dak\u00e1va sa riadok '<columns>'"), line, table.lineNumber);
        }
        table.columns = new ArrayList<XmlColumn>(cols);
        while (true) {
            ++table.lineNumber;
            line = reader.readLine();
            if (line.equals("</columns>")) break;
            if (line == null || !line.startsWith("<column ")) {
                throw new TngExceptionLine(Nat.x("O\u010dak\u00e1va sa riadok '<column ...>'"), line, table.lineNumber);
            }
            XmlColumn col = new XmlColumn();
            col.name = XmlTableImport.getAttribute(line, table.lineNumber, "name");
            col.type = XmlTableImport.getAttribute(line, table.lineNumber, "type");
            col.precision = TngUtilities.strToInt(XmlTableImport.getAttribute(line, table.lineNumber, "precision"), 0);
            col.scale = TngUtilities.strToInt(XmlTableImport.getAttribute(line, table.lineNumber, "scale"), 0);
            table.columns.add(col);
        }
    }

    public static boolean readNextRow(XmlTable table, BufferedReader reader, Map<String, String> binds) throws Exception {
        binds.clear();
        ++table.lineNumber;
        String line = reader.readLine();
        if (line == null) {
            throw new TngExceptionLine(Nat.x("Neo\u010dak\u00e1van\u00fd koniec d\u00e1t"), line, table.lineNumber);
        }
        if (line.equals("</rows>")) {
            return false;
        }
        if (line.equals("</table>")) {
            return false;
        }
        if (!line.equals("<row>")) {
            throw new TngExceptionLine(Nat.x("O\u010dak\u00e1va sa riadok: '<row>'"), line, table.lineNumber);
        }
        while (true) {
            ++table.lineNumber;
            line = reader.readLine();
            if (line == null) {
                throw new TngExceptionLine(Nat.x("Neo\u010dak\u00e1van\u00fd koniec d\u00e1t"), line, table.lineNumber);
            }
            if (line.equals("</row>")) break;
            XmlTableImport.extractColumnAndValue(line, table.lineNumber, binds);
        }
        return true;
    }

    private static String getAttribute(String line, int lineNumber, String attribute) throws TngExceptionLine {
        int e2;
        String find = " " + attribute + "=";
        int f2 = line.indexOf(find);
        if (f2 < 0) {
            return null;
        }
        int s2 = f2 + find.length();
        if (line.charAt(s2) != '\"') {
            throw new TngExceptionLine(Nat.x("Za atrib\u00fatom %1= mus\u00ed nasledova\u0165 znak '\"'", attribute), line, lineNumber);
        }
        if ((e2 = line.indexOf(34, ++s2)) < 0) {
            throw new TngExceptionLine(Nat.x("Hodnota atrib\u00fatu %1 nem\u00e1 koncov\u00fd znak '\"'", attribute), line, lineNumber);
        }
        String value = line.substring(s2, e2);
        return XmlTableImport.convertStringExtends(value);
    }

    private static String convertStringExtends(String string) {
        int firstExtends = string.indexOf(38);
        if (firstExtends < 0) {
            return string;
        }
        StringBuilder h2 = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                i2 = XmlTableImport.convertOneExtends(string, i2, h2);
                continue;
            }
            h2.append(c2);
        }
        return h2.toString();
    }

    private static int convertOneExtends(String string, int offset, StringBuilder dest) {
        String nnn;
        int c2;
        int b2;
        int e2;
        if (string.startsWith("&amp;", offset)) {
            dest.append('&');
            return offset + 4;
        }
        if (string.startsWith("&lt;", offset)) {
            dest.append('<');
            return offset + 3;
        }
        if (string.startsWith("&quot;", offset)) {
            dest.append('\"');
            return offset + 5;
        }
        if (string.startsWith("&#", offset) && (e2 = string.indexOf(59, b2 = offset + 2)) > b2 && (c2 = TngUtilities.strToInt(nnn = string.substring(b2, e2), -1)) >= 0) {
            dest.append((char)c2);
            return e2;
        }
        dest.append('&');
        return offset + 1;
    }

    private static void extractColumnAndValue(String line, int lineNumber, Map<String, String> binds) throws TngExceptionLine {
        if (line == null || line.charAt(0) != '<') {
            throw new TngExceptionLine(Nat.x("Na za\u010diatku riadka sa o\u010dak\u00e1va znak '<'"), line, lineNumber);
        }
        int b2 = 1;
        int e2 = line.indexOf(62, b2);
        if (e2 < 0) {
            throw new TngExceptionLine(Nat.x("Nen\u00e1jden\u00fd koncov\u00fd znak '>' pre n\u00e1zov st\u013apca"), line, lineNumber);
        }
        if (b2 == e2) {
            throw new TngExceptionLine(Nat.x("Pr\u00e1zdny n\u00e1zov st\u013apca"), line, lineNumber);
        }
        String column = line.substring(b2, e2);
        b2 = e2 + 1;
        if ((e2 = line.indexOf(60, b2)) < 0) {
            throw new TngExceptionLine(Nat.x("Nen\u00e1jden\u00fd znak '<' pre ukon\u010denie hodnoty st\u013apca"), line, lineNumber);
        }
        String value = line.substring(b2, e2);
        b2 = e2 + 1;
        if (line.charAt(b2) != '/') {
            throw new TngExceptionLine(Nat.x("Za hodnotu st\u013apca %1 sa o\u010dak\u00e1va ukon\u010denie '</%1>'", column), line, lineNumber);
        }
        ++b2;
        e2 = line.length() - 1;
        if (line.charAt(e2) != '>') {
            throw new TngExceptionLine(Nat.x("Na konci riadka sa o\u010dak\u00e1va znak '>'"), line, lineNumber);
        }
        String column2 = line.substring(b2, e2);
        if (!column.equals(column2)) {
            throw new TngExceptionLine(Nat.x("Neo\u010dak\u00e1van\u00e9 ukon\u010denie st\u013apca %1, malo by\u0165 '%2'", column2, column), line, lineNumber);
        }
        if (value.length() == 0) {
            return;
        }
        value = XmlTableImport.convertStringExtends(value);
        binds.put(column, value);
    }

    private static String syntetizeColumns(String[] cols) {
        StringBuilder h2 = new StringBuilder();
        for (int i2 = 0; i2 < cols.length; ++i2) {
            h2.append(cols[i2]);
            h2.append(',');
        }
        h2.setLength(h2.length() - 1);
        return h2.toString();
    }

    private static String syntetizeMarks(String[] cols) {
        StringBuilder h2 = new StringBuilder(cols.length * 2);
        for (int i2 = 0; i2 < cols.length; ++i2) {
            h2.append("?,");
        }
        h2.setLength(h2.length() - 1);
        return h2.toString();
    }
}

