/*
 * Decompiled with CFR 0.152.
 */
package tangram.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tangram.exception.TngExceptionAbort;
import tangram.exception.TngExceptionSql;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.xml.XmlColumn;
import tangram.xml.XmlTable;
import tangram.xml.XmlTableImportListener;

public class XmlTableImportListenerImpl
implements XmlTableImportListener {
    int tables;
    private String lastTable;
    private HashMap<Integer, Boolean> skipAll = new HashMap();

    public XmlTableImportListenerImpl(int tables) {
        this.tables = tables;
    }

    @Override
    public List<String> onColumnsDifference(XmlTable xmlTable, String schemaAndTable, List<XmlColumn> dstColumns, List<String> importCols, List<String> differCols, List<String> missingInSrc, List<String> missingInDst) throws Exception {
        StringBuilder message = new StringBuilder();
        message.append(Nat.x("Zisten\u00fd rozdiel v \u0161trukt\u00fare tabu\u013eky %1.", schemaAndTable));
        this.addColumns(message, Nat.x("St\u013apce ch\u00fdbaj\u00face v XML"), missingInSrc);
        this.addColumns(message, Nat.x("St\u013apce navy\u0161e v XML"), missingInDst);
        this.addColumns(message, Nat.x("St\u013apce s rozdielnym typom"), differCols);
        ChooseOnDifference choose = this.showDifference(message.toString());
        if (choose == ChooseOnDifference.ABORT_ALL) {
            throw new TngExceptionAbort();
        }
        if (choose == ChooseOnDifference.ABOR_TABLE) {
            return null;
        }
        return importCols;
    }

    private void addColumns(StringBuilder message, String info, List<String> cols) {
        if (cols.size() == 0) {
            return;
        }
        message.append("\n" + info + ": ");
        message.append(TngUtilities.strExt(cols, ", ", 64));
    }

    protected ChooseOnDifference showDifference(String message) {
        if (this.tables == 1) {
            return this.showDifferenceOne(message);
        }
        return this.showDifferenceMore(message);
    }

    protected ChooseOnDifference showDifferenceOne(String message) {
        Object[] options = new String[]{Nat.x("Preru\u0161i\u0165 import"), Nat.x("Importova\u0165 tabu\u013eku")};
        int o2 = TngSwing.msgWarning(message, options, 0);
        if (o2 == 0) {
            return ChooseOnDifference.ABORT_ALL;
        }
        return ChooseOnDifference.IMPORT;
    }

    protected ChooseOnDifference showDifferenceMore(String message) {
        Object[] options = new String[]{Nat.x("Preru\u0161i\u0165 cel\u00fd import"), Nat.x("Preru\u0161i\u0165 import tabu\u013eky"), Nat.x("Importova\u0165 tabu\u013eku")};
        int o2 = TngSwing.msgWarning(message, options, 0);
        if (o2 == 0) {
            return ChooseOnDifference.ABORT_ALL;
        }
        if (o2 == 1) {
            return ChooseOnDifference.ABOR_TABLE;
        }
        return ChooseOnDifference.IMPORT;
    }

    @Override
    public boolean onError(XmlTable xmlTable, String schemaAndTable, Map<String, String> binds, TngExceptionSql e2) throws Exception {
        int errorCode;
        if (!schemaAndTable.equals(this.lastTable)) {
            this.lastTable = schemaAndTable;
            this.skipAll.clear();
        }
        if (this.skipAll.containsKey(errorCode = e2.getErrorCode())) {
            return true;
        }
        String message = Nat.x("Chyba pri z\u00e1pise z\u00e1znamu do tabu\u013eky %1: %2\n%3", schemaAndTable, e2.getMessage(), this.getRecordInfo(xmlTable, binds));
        ChooseOnError choose = this.showError(message);
        if (choose == ChooseOnError.ABORT_ALL) {
            throw new TngExceptionAbort();
        }
        if (choose == ChooseOnError.ABOR_TABLE) {
            return false;
        }
        if (choose == ChooseOnError.SKIP_ALL) {
            this.skipAll.put(errorCode, Boolean.TRUE);
        }
        return true;
    }

    protected ChooseOnError showError(String message) {
        if (this.tables == 1) {
            return this.showErrorOne(message);
        }
        return this.showErrorMore(message);
    }

    protected ChooseOnError showErrorOne(String message) {
        Object[] options = new String[]{Nat.x("Preru\u0161i\u0165 import"), Nat.x("Vynecha\u0165 podobn\u00e9 z\u00e1znamy"), Nat.x("Vynecha\u0165 z\u00e1znam")};
        int o2 = TngSwing.msgWarning(message, options, 2);
        if (o2 == 0) {
            return ChooseOnError.ABORT_ALL;
        }
        if (o2 == 1) {
            return ChooseOnError.SKIP_ALL;
        }
        return ChooseOnError.SKIP_RECORD;
    }

    protected ChooseOnError showErrorMore(String message) {
        Object[] options = new String[]{Nat.x("Preru\u0161i\u0165 cel\u00fd import"), Nat.x("Preru\u0161i\u0165 import tabu\u013eky"), Nat.x("Vynecha\u0165 podobn\u00e9 z\u00e1znamy"), Nat.x("Vynecha\u0165 z\u00e1znam")};
        int o2 = TngSwing.msgWarning(message, options, 3);
        if (o2 == 0) {
            return ChooseOnError.ABORT_ALL;
        }
        if (o2 == 1) {
            return ChooseOnError.ABOR_TABLE;
        }
        if (o2 == 2) {
            return ChooseOnError.SKIP_ALL;
        }
        return ChooseOnError.SKIP_RECORD;
    }

    private String getRecordInfo(XmlTable table, Map<String, String> binds) {
        String v = binds.get("XX");
        if (v != null) {
            return "XX='" + v + "'";
        }
        StringBuilder info = new StringBuilder();
        String[] cols = TngUtilities.strTokenizeOrNull(table.order, ',');
        if (cols == null) {
            cols = binds.keySet().toArray(new String[1]);
        }
        for (int i2 = 0; i2 < cols.length; ++i2) {
            String h2 = cols[i2].toUpperCase();
            if (h2.endsWith(" ASC")) {
                h2 = TngUtilities.strCutEnd(h2, 4).trim();
            } else if (h2.endsWith(" DESC")) {
                h2 = TngUtilities.strCutEnd(h2, 5).trim();
            }
            String value = binds.get(h2);
            if (value == null) {
                value = "NULL";
            }
            if (value.length() > 127) {
                value = value.substring(0, 127) + "...";
            }
            if (info.length() > 0) {
                info.append(", ");
            }
            info.append(h2 + "='" + value + "'");
            if (info.length() > 255) break;
        }
        return info.toString();
    }

    protected static enum ChooseOnError {
        ABORT_ALL,
        ABOR_TABLE,
        SKIP_ALL,
        SKIP_RECORD;

    }

    protected static enum ChooseOnDifference {
        ABORT_ALL,
        ABOR_TABLE,
        IMPORT;

    }
}

