/*
 * Decompiled with CFR 0.152.
 */
package tangram.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tangram.interfaces.TngProgressable;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngUtilities;
import tangram.xml.XmlTable;
import tangram.xml.XmlTableImport;
import tangram.xml.XmlTableImportListener;
import tangram.xml.XmlTableImportPrm;

public final class XmlTableImportZip {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getXmlTables(File fileZip, List<XmlTable> tables) throws Exception {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileZip);
            XmlTableImportZip.getXmlTables(zipFile, tables);
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.closeSafe(zipFile);
    }

    public static void getXmlTables(ZipFile zipFile, List<XmlTable> tables) throws Exception {
        tables.clear();
        ArrayList<String> tableNames = new ArrayList<String>();
        XmlTableImportZip.getTables(zipFile, tableNames);
        for (int i2 = 0; i2 < tableNames.size(); ++i2) {
            XmlTable table = XmlTableImportZip.getXmlTable(zipFile, tableNames.get(i2));
            tables.add(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTables(File fileZip, List<String> tableNames) throws Exception {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileZip);
            XmlTableImportZip.getTables(zipFile, tableNames);
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.closeSafe(zipFile);
    }

    public static void getTables(ZipFile zipFile, List<String> tableNames) throws Exception {
        tableNames.clear();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String h2 = zipEntry.getName().toUpperCase();
            if (!h2.endsWith(".XML")) continue;
            tableNames.add(TngUtilities.strCutEnd(h2, 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlTable getXmlTable(ZipFile zipFile, String tableName) throws Exception {
        BufferedReader reader = XmlTableImportZip.getReader(zipFile, tableName);
        if (reader == null) {
            return null;
        }
        try {
            XmlTable xmlTable = XmlTableImport.readXmlTable(reader);
            return xmlTable;
        }
        finally {
            TngUtilities.closeSafe(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importTables(File fileZip, List<String> tables, boolean overwrite, TngConnection connection, String schema, XmlTableImportListener listener, TngProgressable progress) throws Exception {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileZip);
            int count = tables.size();
            for (int i2 = 0; i2 < count; ++i2) {
                String table = tables.get(i2);
                XmlTableImportPrm prm = new XmlTableImportPrm();
                prm.xmlName = table;
                prm.sqlName = table;
                prm.schema = schema;
                progress.setProgressStatus(Nat.x("Import tabu\u013eky %1 (%2/%3)", table, i2 + 1, count));
                progress.setProgressMax(0);
                XmlTableImportZip.importTable(zipFile, prm, overwrite, connection, listener, progress);
            }
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.closeSafe(zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importTable(File fileZip, XmlTableImportPrm prm, boolean overwrite, TngConnection connection, XmlTableImportListener listener, TngProgressable progress) throws Exception {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileZip);
            XmlTableImportZip.importTable(zipFile, prm, overwrite, connection, listener, progress);
        }
        catch (Throwable throwable) {
            TngUtilities.closeSafe(zipFile);
            throw throwable;
        }
        TngUtilities.closeSafe(zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importTable(ZipFile zipFile, XmlTableImportPrm prm, boolean overwrite, TngConnection connection, XmlTableImportListener listener, TngProgressable progress) throws Exception {
        BufferedReader reader = XmlTableImportZip.getReader(zipFile, prm.xmlName);
        if (reader == null) {
            throw new Exception(Nat.x("ZIP s\u00fabor %1 neobsahuje tabu\u013eku %2", zipFile.getName(), prm.xmlName));
        }
        try {
            XmlTableImport.importTable(reader, overwrite, connection, prm.getSchemaAndTable(), listener, progress);
        }
        finally {
            TngUtilities.closeSafe(reader);
        }
    }

    public static BufferedReader getReader(ZipFile zipFile, String tableName) throws Exception {
        tableName = tableName.toUpperCase();
        String xmlFile = tableName + ".XML";
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (!zipEntry.getName().equalsIgnoreCase(xmlFile)) continue;
            return new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry), "windows-1250"));
        }
        return null;
    }
}

