/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare;

import com.bysquare.UnknownDocumentException;
import com.bysquare.document.BysquareDocument;
import com.bysquare.document.invoice.AdvanceInvoice;
import com.bysquare.document.invoice.CreditNote;
import com.bysquare.document.invoice.DebitNote;
import com.bysquare.document.invoice.Invoice;
import com.bysquare.document.invoice.ProformaInvoice;
import com.bysquare.document.invoiceitems.InvoiceItems;
import com.bysquare.document.pay.Pay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header {
    public static final String VERSION = "1.0.3";
    public static final boolean DECODER = Header._decoder();
    public static final int SIZE = 2;
    public static final int TYPE_PAY = 0;
    public static final int TYPE_INVOICE = 1;
    public static final int TYPE_INVOICE_ITEMS = 2;
    public static final int DOCUMENT_PAY = 0;
    public static final int DOCUMENT_INVOICE = 0;
    public static final int DOCUMENT_PROFORMA_INVOICE = 1;
    public static final int DOCUMENT_CREDIT_NOTE = 2;
    public static final int DOCUMENT_DEBIT_NOTE = 3;
    public static final int DOCUMENT_ADVANCE_INVOICE = 4;
    public static final int DOCUMENT_INVOICE_ITEMS = 0;
    public static final Header Pay = new Header(0, 0, 0, Pay.class);
    public static final Header Invoice = new Header(1, 0, 0, Invoice.class);
    public static final Header ProformaInvoice = new Header(1, 1, 0, ProformaInvoice.class);
    public static final Header CreditNote = new Header(1, 2, 0, CreditNote.class);
    public static final Header DebitNote = new Header(1, 3, 0, DebitNote.class);
    public static final Header AdvanceInvoice = new Header(1, 4, 0, AdvanceInvoice.class);
    public static final Header InvoiceItems = new Header(2, 0, 0, InvoiceItems.class);
    private static final Header[] values = Header.values();
    private final Class<? extends BysquareDocument> clazz;
    private final int bysquareType;
    private final int documentType;
    private final int version;

    private static boolean _decoder() {
        try {
            Class.forName("com.bysquare.BysquareDecoder");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Header[] values() {
        return new Header[]{Pay, Invoice, ProformaInvoice, CreditNote, DebitNote, AdvanceInvoice, InvoiceItems};
    }

    public static Header find(BysquareDocument bysquareDocument) throws UnknownDocumentException {
        Class<?> clazz = bysquareDocument.getClass();
        for (Header header : values) {
            if (!clazz.equals(header.clazz)) continue;
            return header;
        }
        throw new UnknownDocumentException("Unknown header found. ");
    }

    public static Header find(byte[] byArray) throws UnknownDocumentException {
        if (byArray.length < 2) {
            throw new UnknownDocumentException("Input data is too short to contain a by square header. ");
        }
        int n2 = (byArray[0] & 0xF0) >> 4;
        int n3 = byArray[0] & 0xF;
        int n4 = (byArray[1] & 0xF0) >> 4;
        return Header.find(n2, n3, n4);
    }

    public static Header find(int n2, int n3, int n4) throws UnknownDocumentException {
        for (Header header : values) {
            if (header.getBysquareType() != n2 || header.getVersion() != n3 || header.getDocumentType() != n4) continue;
            return header;
        }
        throw new UnknownDocumentException("Unknown header found. ");
    }

    Header(int n2, int n3, int n4, Class<? extends BysquareDocument> clazz) {
        this.clazz = clazz;
        this.bysquareType = n2;
        this.documentType = n3;
        this.version = n4;
    }

    public Header(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    Header(byte ... byArray) {
        this((byArray[0] & 0xF0) >> 4, (byArray[1] & 0xF0) >> 4, byArray[0] & 0xF);
    }

    public byte[] encode() {
        return new byte[]{(byte)(this.bysquareType << 4 | this.version & 0xF), (byte)(this.documentType << 4)};
    }

    public int getBysquareType() {
        return this.bysquareType;
    }

    public int getVersion() {
        return this.version;
    }

    public int getDocumentType() {
        return this.documentType;
    }

    public boolean equals(Object object) {
        if (object instanceof Header) {
            Header header = (Header)object;
            return this.bysquareType == header.bysquareType && this.version == header.version && this.documentType == header.documentType;
        }
        return false;
    }

    public String toString() {
        return "by square type: " + this.bysquareType + "\nversion: " + this.version + "\ndocument type: " + this.documentType;
    }

    public Class<? extends BysquareDocument> getDocumentClass() {
        return this.clazz;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Pay,
        Invoice,
        InvoiceItems;

    }
}

