/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoice;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Order(elements={"PartyName", "CompanyTaxID", "CompanyVATID", "CompanyRegisterID"})
@Root(name="Party", strict=false)
public class Party
implements IVerifiable {
    protected String partyName;
    protected String companyTaxID;
    protected String companyVATID;
    protected String companyRegisterID;

    @Element(name="PartyName", required=false)
    public String getPartyName() {
        return this.partyName;
    }

    @Element(name="PartyName", required=false)
    public void setPartyName(String string) {
        this.partyName = Verify.trim(string);
    }

    @Element(name="CompanyTaxID", required=false)
    public String getCompanyTaxID() {
        return this.companyTaxID;
    }

    @Element(name="CompanyTaxID", required=false)
    public void setCompanyTaxID(String string) {
        this.companyTaxID = Verify.trimAll(string);
    }

    @Element(name="CompanyVATID", required=false)
    public String getCompanyVATID() {
        return this.companyVATID;
    }

    @Element(name="CompanyVATID", required=false)
    public void setCompanyVATID(String string) {
        this.companyVATID = Verify.trimAll(string);
    }

    @Element(name="CompanyRegisterID", required=false)
    public String getCompanyRegisterID() {
        return this.companyRegisterID;
    }

    @Element(name="CompanyRegisterID", required=false)
    public void setCompanyRegisterID(String string) {
        this.companyRegisterID = Verify.trimAll(string);
    }

    public boolean isEmpty() {
        return this.partyName == null && this.companyTaxID == null && this.companyVATID == null && this.companyRegisterID == null;
    }

    public void verify() throws InvalidValueException {
        Verify.notNull("PartyName", this.getPartyName());
    }

    public String toString() {
        return this.partyName == null ? "" : this.partyName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Party)) {
            return false;
        }
        Party party = (Party)object;
        if (this.companyRegisterID == null ? party.companyRegisterID != null : !this.companyRegisterID.equals(party.companyRegisterID)) {
            return false;
        }
        if (this.companyTaxID == null ? party.companyTaxID != null : !this.companyTaxID.equals(party.companyTaxID)) {
            return false;
        }
        if (this.companyVATID == null ? party.companyVATID != null : !this.companyVATID.equals(party.companyVATID)) {
            return false;
        }
        return !(this.partyName == null ? party.partyName != null : !this.partyName.equals(party.partyName));
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.companyRegisterID == null ? 0 : this.companyRegisterID.hashCode());
        n2 = 31 * n2 + (this.companyTaxID == null ? 0 : this.companyTaxID.hashCode());
        n2 = 31 * n2 + (this.companyVATID == null ? 0 : this.companyVATID.hashCode());
        n2 = 31 * n2 + (this.partyName == null ? 0 : this.partyName.hashCode());
        return n2;
    }
}

