/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.logo;

import com.bysquare.Header;
import com.bysquare.logo.FrameLogo;
import com.bysquare.logo.Logo;
import com.bysquare.logo.LogoKey;
import com.bysquare.logo.MissingLogoException;
import com.bysquare.logo.NoFrameLogo;
import com.bysquare.utilities.SoftMap;
import java.io.InputStream;

public abstract class LogoFactory {
    protected static final String EXT = ".png";
    private final SoftMap<LogoKey, Logo> map = new SoftMap();

    protected LogoFactory() {
    }

    public Logo getLogo(LogoKey logoKey) throws MissingLogoException {
        Header.Type type = logoKey.getType();
        if (type != Header.Type.Pay && type != Header.Type.Invoice) {
            throw new MissingLogoException("Specified by square type (" + (Object)((Object)type) + ") does not have a logo. ");
        }
        Logo logo = this.map.get(logoKey);
        if (logo != null) {
            return logo;
        }
        InputStream inputStream = this.getInputStream(logoKey);
        if (inputStream == null) {
            throw new MissingLogoException("Missing logo image: " + logoKey);
        }
        try {
            logo = logoKey.getFrame() ? new FrameLogo(inputStream) : new NoFrameLogo(inputStream, logoKey.getRotation());
        }
        catch (Throwable throwable) {
            throw new MissingLogoException("Cannot create logo image: " + logoKey, throwable);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
        this.map.put(logoKey.clone(), logo);
        return logo;
    }

    protected abstract InputStream getInputStream(LogoKey var1) throws MissingLogoException;
}

